/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.progressivebosses.module.dragon.feature;

import insane96mcp.insanelib.base.Feature;
import insane96mcp.insanelib.base.Label;
import insane96mcp.insanelib.base.Module;
import insane96mcp.progressivebosses.setup.Config;
import java.util.Arrays;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.boss.enderdragon.phases.DragonPhaseInstance;
import net.minecraft.world.entity.boss.enderdragon.phases.EnderDragonPhase;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@Label(name="Resistances & Vulnerabilities", description="Handles the Damage Resistances and Vulnerabilities")
public class ResistancesFeature
extends Feature {
    private final ForgeConfigSpec.ConfigValue<Double> damageRedutionWhenSittingConfig;
    private final ForgeConfigSpec.ConfigValue<Double> explosionDamageReductionConfig;
    public double damageRedutionWhenSitting = 0.08;
    public double explosionDamageReduction = 0.667;
    private static final List<EnderDragonPhase<? extends DragonPhaseInstance>> sittingPhases = Arrays.asList(EnderDragonPhase.f_31383_, EnderDragonPhase.f_31384_, EnderDragonPhase.f_31382_, EnderDragonPhase.f_31381_);

    public ResistancesFeature(Module module) {
        super(Config.builder, module);
        this.pushConfig(Config.builder);
        this.damageRedutionWhenSittingConfig = Config.builder.comment("Melee Damage reduction per difficulty while the Ender Dragon is at the center.").defineInRange("Melee Damage reduction while at the center", this.damageRedutionWhenSitting, 0.0, Double.MAX_VALUE);
        this.explosionDamageReductionConfig = Config.builder.comment("Damage reduction when hit by explosions (firework rockets excluded).").defineInRange("Explosion Damage reduction", this.explosionDamageReduction, 0.0, Double.MAX_VALUE);
        Config.builder.pop();
    }

    public void loadConfig() {
        super.loadConfig();
        this.damageRedutionWhenSitting = (Double)this.damageRedutionWhenSittingConfig.get();
        this.explosionDamageReduction = (Double)this.explosionDamageReductionConfig.get();
    }

    @SubscribeEvent
    public void onDragonDamage(LivingDamageEvent event) {
        if (!this.isEnabled()) {
            return;
        }
        Entity entity = event.getEntity();
        if (!(entity instanceof EnderDragon)) {
            return;
        }
        EnderDragon dragon = (EnderDragon)entity;
        this.meleeDamageReduction(event, dragon);
        this.explosionDamageReduction(event, dragon);
    }

    private void meleeDamageReduction(LivingDamageEvent event, EnderDragon dragon) {
        if (this.damageRedutionWhenSitting == 0.0) {
            return;
        }
        CompoundTag compoundNBT = dragon.getPersistentData();
        float difficulty = compoundNBT.m_128457_("progressivebosses:difficulty");
        if (sittingPhases.contains(dragon.m_31157_().m_31415_().m_7309_()) && event.getSource().m_7640_() instanceof Player) {
            event.setAmount(event.getAmount() - (float)((double)event.getAmount() * (this.damageRedutionWhenSitting * (double)difficulty)));
        }
    }

    private void explosionDamageReduction(LivingDamageEvent event, EnderDragon dragon) {
        if (this.explosionDamageReduction == 0.0) {
            return;
        }
        if (event.getSource().m_19372_() && !event.getSource().m_19385_().equals("fireworks")) {
            event.setAmount(event.getAmount() - (float)((double)event.getAmount() * this.explosionDamageReduction));
        }
    }
}

