/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.progressivebosses.module.dragon.feature;

import insane96mcp.insanelib.base.Feature;
import insane96mcp.insanelib.base.Label;
import insane96mcp.insanelib.base.Module;
import insane96mcp.progressivebosses.classutils.Drop;
import insane96mcp.progressivebosses.setup.Config;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingExperienceDropEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@Label(name="Rewards", description="Bonus Experience and Dragon Egg per player")
public class RewardFeature
extends Feature {
    private final ForgeConfigSpec.ConfigValue<Double> bonusExperienceConfig;
    private final ForgeConfigSpec.ConfigValue<Boolean> dragonEggPerPlayerConfig;
    private final ForgeConfigSpec.ConfigValue<List<? extends String>> dropsListConfig;
    public double bonusExperience = 4.5;
    public boolean dragonEggPerPlayer = true;
    public ArrayList<Drop> dropsList;

    public RewardFeature(Module module) {
        super(Config.builder, module);
        this.pushConfig(Config.builder);
        this.bonusExperienceConfig = Config.builder.comment("How much more experience (percentage) will Dragon drop per Difficulty. The percentage is additive (e.g. with this set to 100%, 7 dragons killed = 700% more experience)").defineInRange("Bonus Experience per Difficulty", this.bonusExperience, 0.0, Double.MAX_VALUE);
        this.dragonEggPerPlayerConfig = Config.builder.comment("If true whenever a player, that has never killed the dragon, kills the dragon a Dragon Egg \u00c3\u00ac\u00c3\u00ac will drop. E.g. If 2 players kill the Dragon for the first time, she will drop 2 Dragon Eggs").define("Dragon Egg per Player", this.dragonEggPerPlayer);
        this.dropsListConfig = Config.builder.comment("A list of drops for the Dragons. Entry format: item,amount,difficulty_required,chance,difficulty_mode,chance_mode\nitem: item id\namount: amount\ndifficulty_required: the amount of difficulty required for the item to drop, works differently based on mode\nchance: chance for the drop to happen, between 0 and 1\ndifficulty_mode:\n* MINIMUM: will try to drop the item when the difficulty matches or is higher\n* PER_DIFFICULTY: will try to drop the item once per difficulty (e.g. at difficulty 10, difficulty required 3, there is the chance to drop the item, trying 7 times)\nchance_mode:\n* FLAT: chance is the percentage chance for the item to drop if the difficulty criteria matches\n* SCALING: each point of difficulty >= 'difficulty to drop the item' will be multiplied by the chance (e.g. chance 2% and difficulty 10, difficulty required 5, chance to drop the item will be chance * (difficulty - difficulty_required + 1) = 2% * (10 - 5 + 1) = 12%)").defineList("Drops", ArrayList::new, o -> o instanceof String);
        Config.builder.pop();
    }

    public void loadConfig() {
        super.loadConfig();
        this.bonusExperience = (Double)this.bonusExperienceConfig.get();
        this.dragonEggPerPlayer = (Boolean)this.dragonEggPerPlayerConfig.get();
        this.dropsList = Drop.parseDropsList((List)this.dropsListConfig.get());
    }

    @SubscribeEvent
    public void onUpdate(LivingEvent.LivingUpdateEvent event) {
        if (!this.isEnabled()) {
            return;
        }
        Entity entity = event.getEntity();
        if (!(entity instanceof EnderDragon)) {
            return;
        }
        EnderDragon dragon = (EnderDragon)entity;
        this.dropEgg(dragon);
    }

    @SubscribeEvent
    public void onExpDrop(LivingExperienceDropEvent event) {
        if (!this.isEnabled()) {
            return;
        }
        Entity entity = event.getEntity();
        if (!(entity instanceof EnderDragon)) {
            return;
        }
        EnderDragon dragon = (EnderDragon)entity;
        if (this.bonusExperience == 0.0) {
            return;
        }
        CompoundTag dragonTags = dragon.getPersistentData();
        float difficulty = dragonTags.m_128457_("progressivebosses:difficulty");
        if ((double)difficulty == 0.0) {
            return;
        }
        event.setDroppedExperience((int)((double)event.getDroppedExperience() * this.bonusExperience * (double)difficulty));
    }

    private void dropEgg(EnderDragon dragon) {
        if (!this.dragonEggPerPlayer) {
            return;
        }
        if (dragon.f_31084_ != 100) {
            return;
        }
        CompoundTag tags = dragon.getPersistentData();
        int eggsToDrop = tags.m_128451_("progressivebosses:eggs_to_drop");
        if (dragon.m_31158_() != null && !dragon.m_31158_().m_64099_()) {
            --eggsToDrop;
        }
        for (int i = 0; i < eggsToDrop; ++i) {
            dragon.f_19853_.m_46597_(new BlockPos(0, 255 - i, 0), Blocks.f_50260_.m_49966_());
        }
    }

    @SubscribeEvent
    public void onDeath(LivingDeathEvent event) {
        if (!this.isEnabled()) {
            return;
        }
        if (this.dropsList.isEmpty()) {
            return;
        }
        LivingEntity livingEntity = event.getEntityLiving();
        if (!(livingEntity instanceof EnderDragon)) {
            return;
        }
        EnderDragon dragon = (EnderDragon)livingEntity;
        CompoundTag tags = dragon.getPersistentData();
        float difficulty = tags.m_128457_("progressivebosses:difficulty");
        for (Drop drop : this.dropsList) {
            drop.drop(dragon.f_19853_, dragon.m_20182_(), difficulty);
        }
    }
}

