/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.progressivebosses.module.elderguardian.feature;

import insane96mcp.insanelib.base.Feature;
import insane96mcp.insanelib.base.Label;
import insane96mcp.insanelib.base.Module;
import insane96mcp.insanelib.utils.MCUtils;
import insane96mcp.progressivebosses.module.elderguardian.ai.ElderMinionNearestAttackableTargetGoal;
import insane96mcp.progressivebosses.module.elderguardian.feature.BaseFeature;
import insane96mcp.progressivebosses.setup.Config;
import insane96mcp.progressivebosses.setup.Strings;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.GoalSelector;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.ElderGuardian;
import net.minecraft.world.entity.monster.Guardian;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@Label(name="Minions", description="Elder Guardians will spawn Elder Minions.")
public class MinionFeature
extends Feature {
    private final ForgeConfigSpec.ConfigValue<Integer> baseCooldownConfig;
    private final ForgeConfigSpec.ConfigValue<Integer> cooldownReductionPerMissingGuardianConfig;
    public int baseCooldown = 200;
    public int cooldownReductionPerMissingGuardian = 60;

    public MinionFeature(Module module) {
        super(Config.builder, module);
        this.pushConfig(Config.builder);
        this.baseCooldownConfig = Config.builder.comment("Elder Guardians will spawn Elder Minions every this tick value (20 ticks = 1 sec).").defineInRange("Base Cooldown", this.baseCooldown, 0, Integer.MAX_VALUE);
        this.cooldownReductionPerMissingGuardianConfig = Config.builder.comment("The base cooldown is reduced by this value for each missing Elder Guardian.").defineInRange("Cooldown Reduction per Missing Elder", this.cooldownReductionPerMissingGuardian, 0, Integer.MAX_VALUE);
        Config.builder.pop();
    }

    public void loadConfig() {
        super.loadConfig();
        this.baseCooldown = (Integer)this.baseCooldownConfig.get();
        this.cooldownReductionPerMissingGuardian = (Integer)this.cooldownReductionPerMissingGuardianConfig.get();
    }

    @SubscribeEvent
    public void onElderGuardianSpawn(EntityJoinWorldEvent event) {
        if (event.getWorld().f_46443_) {
            return;
        }
        if (!this.isEnabled()) {
            return;
        }
        if (!(event.getEntity() instanceof ElderGuardian)) {
            return;
        }
        ElderGuardian elderGuardian = (ElderGuardian)event.getEntity();
        CompoundTag witherTags = elderGuardian.getPersistentData();
        witherTags.m_128405_("progressivebosses:elder_minion_cooldown", this.baseCooldown);
    }

    @SubscribeEvent
    public void update(LivingEvent.LivingUpdateEvent event) {
        if (event.getEntity().f_19853_.f_46443_) {
            return;
        }
        if (!this.isEnabled()) {
            return;
        }
        if (!(event.getEntity() instanceof ElderGuardian)) {
            return;
        }
        Level world = event.getEntity().f_19853_;
        ElderGuardian elderGuardian = (ElderGuardian)event.getEntity();
        CompoundTag elderGuardianTags = elderGuardian.getPersistentData();
        if (elderGuardian.m_21223_() <= 0.0f) {
            return;
        }
        int cooldown = elderGuardianTags.m_128451_("progressivebosses:elder_minion_cooldown");
        if (cooldown > 0) {
            elderGuardianTags.m_128405_("progressivebosses:elder_minion_cooldown", cooldown - 1);
            return;
        }
        elderGuardianTags.m_128405_("progressivebosses:elder_minion_cooldown", this.baseCooldown - this.cooldownReductionPerMissingGuardian * BaseFeature.getDeadElderGuardians(elderGuardian));
        int radius = 24;
        BlockPos pos1 = elderGuardian.m_142538_().m_142082_(-radius, -radius, -radius);
        BlockPos pos2 = elderGuardian.m_142538_().m_142082_(radius, radius, radius);
        AABB bb = new AABB(pos1, pos2);
        List players = world.m_45976_(ServerPlayer.class, bb);
        if (players.isEmpty()) {
            return;
        }
        List minionsInAABB = world.m_6443_(Guardian.class, elderGuardian.m_142469_().m_82400_(12.0), entity -> entity.getPersistentData().m_128441_("progressivebosses:elder_minion"));
        int minionsCountInAABB = minionsInAABB.size();
        if (minionsCountInAABB >= 5) {
            return;
        }
        this.summonMinion(world, new Vec3(elderGuardian.m_20185_(), elderGuardian.m_20186_(), elderGuardian.m_20189_()));
    }

    public Guardian summonMinion(Level world, Vec3 pos) {
        Guardian elderMinion = new Guardian(EntityType.f_20455_, world);
        CompoundTag minionTags = elderMinion.getPersistentData();
        minionTags.m_128379_("mobspropertiesrandomness:processed", true);
        minionTags.m_128379_("progressivebosses:elder_minion", true);
        elderMinion.m_6034_(pos.f_82479_, pos.f_82480_, pos.f_82481_);
        elderMinion.m_6593_((Component)new TranslatableComponent("progressivebosses:elder_minion"));
        elderMinion.f_21355_ = BuiltInLootTables.f_78712_;
        MCUtils.applyModifier((LivingEntity)elderMinion, (Attribute)((Attribute)ForgeMod.SWIM_SPEED.get()), (UUID)Strings.AttributeModifiers.SWIM_SPEED_BONUS_UUID, (String)"progressivebosses:swim_speed_bonus", (double)2.0, (AttributeModifier.Operation)AttributeModifier.Operation.MULTIPLY_BASE);
        ArrayList<Goal> goalsToRemove = new ArrayList<Goal>();
        for (WrappedGoal prioritizedGoal : elderMinion.f_21346_.f_25345_) {
            if (!(prioritizedGoal.m_26015_() instanceof NearestAttackableTargetGoal)) continue;
            goalsToRemove.add(prioritizedGoal.m_26015_());
        }
        goalsToRemove.forEach(arg_0 -> ((GoalSelector)elderMinion.f_21345_).m_25363_(arg_0));
        elderMinion.f_21346_.m_25352_(1, new ElderMinionNearestAttackableTargetGoal<Player>((Mob)elderMinion, Player.class, true));
        world.m_7967_((Entity)elderMinion);
        return elderMinion;
    }
}

