/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.progressivebosses.module.wither.feature;

import insane96mcp.insanelib.base.Feature;
import insane96mcp.insanelib.base.Label;
import insane96mcp.insanelib.base.Module;
import insane96mcp.insanelib.utils.MCUtils;
import insane96mcp.progressivebosses.setup.Config;
import insane96mcp.progressivebosses.setup.Strings;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.boss.wither.WitherBoss;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@Label(name="Health", description="Bonus Health and Bonus regeneration. The feature even fixes the Wither health bar not updating on spawn.")
public class HealthFeature
extends Feature {
    private final ForgeConfigSpec.ConfigValue<Double> bonusPerDifficultyConfig;
    private final ForgeConfigSpec.ConfigValue<Double> maximumBonusRegenConfig;
    private final ForgeConfigSpec.ConfigValue<Double> bonusRegenPerDifficultyConfig;
    public double bonusPerDifficulty = 90.0;
    public double maxBonusRegen = 2.0;
    public double bonusRegenPerDifficulty = 0.3;

    public HealthFeature(Module module) {
        super(Config.builder, module);
        this.pushConfig(Config.builder);
        this.bonusPerDifficultyConfig = Config.builder.comment("Increase Wither's Health by this value per difficulty").defineInRange("Health Bonus per Difficulty", this.bonusPerDifficulty, 0.0, Double.MAX_VALUE);
        this.maximumBonusRegenConfig = Config.builder.comment("Maximum bonus regeneration per second given by \"Bonus Regeneration per Difficulty\". Set to 0 to disable bonus health regeneration. This doesn't affect the natural regeneration of the Wither (1 Health per Second).").defineInRange("Maximum Bonus Regeneration", this.maxBonusRegen, 0.0, Double.MAX_VALUE);
        this.bonusRegenPerDifficultyConfig = Config.builder.comment("How many half hearts will the Wither regen more per difficulty. This doesn't affect the natural regeneration of the Wither (1 Health per Second). (E.g. By default, with 6 Withers spawned, the Wither will heal 1.3 health per second).").defineInRange("Bonus Regeneration per Difficulty", this.bonusRegenPerDifficulty, 0.0, Double.MAX_VALUE);
        Config.builder.pop();
    }

    public void loadConfig() {
        super.loadConfig();
        this.bonusPerDifficulty = (Double)this.bonusPerDifficultyConfig.get();
        this.maxBonusRegen = (Double)this.maximumBonusRegenConfig.get();
        this.bonusRegenPerDifficulty = (Double)this.bonusRegenPerDifficultyConfig.get();
    }

    @SubscribeEvent
    public void onSpawn(EntityJoinWorldEvent event) {
        boolean hasInvulTicks;
        if (event.getWorld().f_46443_) {
            return;
        }
        if (!this.isEnabled()) {
            return;
        }
        if (this.bonusPerDifficulty == 0.0) {
            return;
        }
        Entity entity = event.getEntity();
        if (!(entity instanceof WitherBoss)) {
            return;
        }
        WitherBoss wither = (WitherBoss)entity;
        if (wither.m_21051_(Attributes.f_22276_).m_22111_(Strings.AttributeModifiers.BONUS_HEALTH_UUID) != null) {
            return;
        }
        CompoundTag witherTags = wither.getPersistentData();
        double difficulty = witherTags.m_128457_("progressivebosses:difficulty");
        MCUtils.applyModifier((LivingEntity)wither, (Attribute)Attributes.f_22276_, (UUID)Strings.AttributeModifiers.BONUS_HEALTH_UUID, (String)"progressivebosses:bonus_health", (double)(difficulty * this.bonusPerDifficulty), (AttributeModifier.Operation)AttributeModifier.Operation.ADDITION);
        boolean bl = hasInvulTicks = wither.m_31502_() > 0;
        if (hasInvulTicks) {
            wither.m_21153_(Math.max(1.0f, wither.m_21233_() - 200.0f));
        }
    }

    @SubscribeEvent
    public void onUpdate(LivingEvent.LivingUpdateEvent event) {
        if (event.getEntity().f_19853_.f_46443_) {
            return;
        }
        if (!this.isEnabled()) {
            return;
        }
        Entity entity = event.getEntity();
        if (!(entity instanceof WitherBoss)) {
            return;
        }
        WitherBoss wither = (WitherBoss)entity;
        if (this.bonusRegenPerDifficulty == 0.0 || this.maxBonusRegen == 0.0) {
            return;
        }
        if (wither.m_31502_() > 0) {
            return;
        }
        CompoundTag tags = wither.getPersistentData();
        float difficulty = tags.m_128457_("progressivebosses:difficulty");
        if (difficulty <= 0.0f) {
            return;
        }
        if (wither.m_21223_() <= 0.0f) {
            return;
        }
        float heal = (float)Math.min((double)difficulty * this.bonusRegenPerDifficulty, this.maxBonusRegen);
        wither.m_5634_(heal /= 20.0f);
    }

    private void fixInvulBossBar(WitherBoss wither) {
        if (wither.m_31502_() == 0) {
            return;
        }
        wither.f_31430_.m_142711_(wither.m_21223_() / wither.m_21233_());
    }
}

