/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.progressivebosses.module.dragon.feature;

import insane96mcp.insanelib.base.Feature;
import insane96mcp.insanelib.base.Label;
import insane96mcp.insanelib.base.Module;
import insane96mcp.progressivebosses.setup.Config;
import insane96mcp.progressivebosses.utils.DifficultyHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootTableReference;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingExperienceDropEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@Label(name="Rewards", description="Bonus Experience and Dragon Egg per player")
public class RewardFeature
extends Feature {
    private final ForgeConfigSpec.ConfigValue<Double> bonusExperienceConfig;
    private final ForgeConfigSpec.ConfigValue<Boolean> dragonEggPerPlayerConfig;
    private final ForgeConfigSpec.ConfigValue<Boolean> injectDefaultRewardsConfig;
    public double bonusExperience = 36.0;
    public boolean dragonEggPerPlayer = true;
    public boolean injectDefaultRewards = true;

    public RewardFeature(Module module) {
        super(Config.builder, module);
        this.pushConfig(Config.builder);
        this.bonusExperienceConfig = Config.builder.comment("How much more experience (percentage, 36 means +3600%) will Dragon drop at max Difficulty.").defineInRange("Bonus Experience", this.bonusExperience, 0.0, Double.MAX_VALUE);
        this.dragonEggPerPlayerConfig = Config.builder.comment("If true whenever a player, that has never killed the dragon, kills the dragon a Dragon Egg \u00c3\u00ac\u00c3\u00ac will drop. E.g. If 2 players kill the Dragon for the first time, she will drop 2 Dragon Eggs").define("Dragon Egg per Player", this.dragonEggPerPlayer);
        this.injectDefaultRewardsConfig = Config.builder.comment("If true default mod drops are added to the Ender Dragon.\nNote that replacing the Ender Dragon loot table (e.g. via DataPack) will automatically remove the Injected loot.").define("Inject Default Loot", this.injectDefaultRewards);
        Config.builder.pop();
    }

    public void loadConfig() {
        super.loadConfig();
        this.bonusExperience = (Double)this.bonusExperienceConfig.get();
        this.dragonEggPerPlayer = (Boolean)this.dragonEggPerPlayerConfig.get();
        this.injectDefaultRewards = (Boolean)this.injectDefaultRewardsConfig.get();
    }

    @SubscribeEvent
    public void onUpdate(LivingEvent.LivingUpdateEvent event) {
        Entity entity;
        if (!this.isEnabled() || !((entity = event.getEntity()) instanceof EnderDragon)) {
            return;
        }
        EnderDragon dragon = (EnderDragon)entity;
        this.dropEgg(dragon);
    }

    @SubscribeEvent
    public void onExpDrop(LivingExperienceDropEvent event) {
        EnderDragon dragon;
        block3: {
            block2: {
                Entity entity;
                if (!this.isEnabled() || !((entity = event.getEntity()) instanceof EnderDragon)) break block2;
                dragon = (EnderDragon)entity;
                if (this.bonusExperience != 0.0) break block3;
            }
            return;
        }
        event.setDroppedExperience((int)((double)event.getDroppedExperience() * this.bonusExperience * (double)DifficultyHelper.getScalingDifficulty((LivingEntity)dragon)));
    }

    private void dropEgg(EnderDragon dragon) {
        if (!this.dragonEggPerPlayer || dragon.f_31084_ != 100) {
            return;
        }
        CompoundTag tags = dragon.getPersistentData();
        int eggsToDrop = tags.m_128451_("progressivebosses:eggs_to_drop");
        if (dragon.m_31158_() != null && !dragon.m_31158_().m_64099_()) {
            --eggsToDrop;
        }
        for (int i = 0; i < eggsToDrop; ++i) {
            dragon.f_19853_.m_46597_(new BlockPos(0, 255 - i, 0), Blocks.f_50260_.m_49966_());
        }
    }

    @SubscribeEvent
    public void onLootTableLoad(LootTableLoadEvent event) {
        if (!this.isEnabled() || !this.injectDefaultRewards) {
            return;
        }
        ResourceLocation name = event.getName();
        if (!"minecraft".equals(name.m_135827_()) || !"entities/ender_dragon".equals(name.m_135815_())) {
            return;
        }
        LootPool pool = new LootPool.Builder().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootTableReference.m_79776_((ResourceLocation)new ResourceLocation("progressivebosses", "entities/ender_dragon"))).m_79082_();
        event.getTable().addPool(pool);
    }
}

