/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.progressivebosses.module.elderguardian.feature;

import insane96mcp.insanelib.base.Feature;
import insane96mcp.insanelib.base.Label;
import insane96mcp.insanelib.base.Module;
import insane96mcp.progressivebosses.setup.Config;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.monster.ElderGuardian;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootTableReference;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingExperienceDropEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@Label(name="Rewards", description="Bonus Experience and Dragon Egg per player")
public class RewardFeature
extends Feature {
    private final ForgeConfigSpec.ConfigValue<Integer> baseExperienceConfig;
    private final ForgeConfigSpec.ConfigValue<Double> bonusExperienceConfig;
    private final ForgeConfigSpec.ConfigValue<Boolean> injectDefaultRewardsConfig;
    public int baseExperience = 40;
    public double bonusExperience = 1.0;
    public boolean injectDefaultRewards = true;

    public RewardFeature(Module module) {
        super(Config.builder, module);
        this.pushConfig(Config.builder);
        this.baseExperienceConfig = Config.builder.comment("How much experience will an Elder Guardian drop. -1 will make the Elder Guardian drop vanilla experience.").defineInRange("Base Experience", this.baseExperience, -1, 1024);
        this.bonusExperienceConfig = Config.builder.comment("How much more experience (percentage) will Elder Guardian drop per killed Elder Guardian. The percentage is additive (e.g. with this set to 100%, the last Elder will drop 200% more experience)").defineInRange("Bonus Experience", this.bonusExperience, 0.0, Double.MAX_VALUE);
        this.injectDefaultRewardsConfig = Config.builder.comment("If true default mod drops are added to the Elder Guardian.\nNote that replacing the Elder Guardian loot table (e.g. via DataPack) will automatically remove the Injected loot.").define("Inject Default Loot", this.injectDefaultRewards);
        Config.builder.pop();
    }

    public void loadConfig() {
        super.loadConfig();
        this.baseExperience = (Integer)this.baseExperienceConfig.get();
        this.bonusExperience = (Double)this.bonusExperienceConfig.get();
        this.injectDefaultRewards = (Boolean)this.injectDefaultRewardsConfig.get();
    }

    @SubscribeEvent
    public void onSpawn(EntityJoinWorldEvent event) {
        if (event.getWorld().f_46443_) {
            return;
        }
        if (!this.isEnabled()) {
            return;
        }
        if ((double)this.baseExperience == -1.0) {
            return;
        }
        Entity entity = event.getEntity();
        if (!(entity instanceof ElderGuardian)) {
            return;
        }
        ElderGuardian elderGuardian = (ElderGuardian)entity;
        elderGuardian.f_21364_ = this.baseExperience;
    }

    @SubscribeEvent
    public void onExperienceDrop(LivingExperienceDropEvent event) {
        if (!this.isEnabled()) {
            return;
        }
        if (this.bonusExperience == 0.0) {
            return;
        }
        if (!(event.getEntity() instanceof ElderGuardian)) {
            return;
        }
        int bonusExperience = (int)((double)event.getOriginalExperience() * this.bonusExperience);
        event.setDroppedExperience(event.getOriginalExperience() + bonusExperience);
    }

    @SubscribeEvent
    public void onLootTableLoad(LootTableLoadEvent event) {
        if (!this.isEnabled() || !this.injectDefaultRewards) {
            return;
        }
        ResourceLocation name = event.getName();
        if (!"minecraft".equals(name.m_135827_()) || !"entities/elder_guardian".equals(name.m_135815_())) {
            return;
        }
        LootPool pool = new LootPool.Builder().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootTableReference.m_79776_((ResourceLocation)new ResourceLocation("progressivebosses", "entities/elder_guardian"))).m_79082_();
        event.getTable().addPool(pool);
    }
}

