/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.progressivebosses.module.wither.feature;

import insane96mcp.insanelib.base.Feature;
import insane96mcp.insanelib.base.Label;
import insane96mcp.insanelib.base.Module;
import insane96mcp.insanelib.util.MCUtils;
import insane96mcp.insanelib.util.MathHelper;
import insane96mcp.progressivebosses.module.wither.entity.WitherMinion;
import insane96mcp.progressivebosses.setup.Config;
import insane96mcp.progressivebosses.setup.PBEntities;
import insane96mcp.progressivebosses.setup.Strings;
import insane96mcp.progressivebosses.utils.DifficultyHelper;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.boss.wither.WitherBoss;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.AbstractSkeleton;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@Label(name="Minions", description="Wither will spawn deadly Minions")
public class MinionFeature
extends Feature {
    private final ForgeConfigSpec.ConfigValue<Integer> minionAtDifficultyConfig;
    private final ForgeConfigSpec.ConfigValue<Integer> bonusMinionEveryDifficultyConfig;
    private final ForgeConfigSpec.ConfigValue<Integer> maxSpawnedConfig;
    private final ForgeConfigSpec.ConfigValue<Integer> maxAroundConfig;
    private final ForgeConfigSpec.ConfigValue<Integer> minCooldownConfig;
    private final ForgeConfigSpec.ConfigValue<Integer> maxCooldownConfig;
    private final ForgeConfigSpec.ConfigValue<Double> cooldownMultiplierBelowHalfHealthConfig;
    private final ForgeConfigSpec.ConfigValue<Double> bonusSpeedConfig;
    private final ForgeConfigSpec.ConfigValue<Double> magicDamageMultiplierConfig;
    private final ForgeConfigSpec.ConfigValue<Boolean> killMinionOnWitherDeathConfig;
    private final ForgeConfigSpec.ConfigValue<Double> aboveHalfHealthBowChanceConfig;
    private final ForgeConfigSpec.ConfigValue<Double> belowHalfHealthBowChanceConfig;
    private final ForgeConfigSpec.DoubleValue sharpnessChanceConfig;
    private final ForgeConfigSpec.DoubleValue powerChanceConfig;
    private final ForgeConfigSpec.DoubleValue knockbackChanceConfig;
    private final ForgeConfigSpec.DoubleValue punchChanceConfig;
    public int minionAtDifficulty = 1;
    public int bonusMinionEveryDifficulty = 1;
    public int maxSpawned = 6;
    public int maxAround = 18;
    public int minCooldown = 400;
    public int maxCooldown = 800;
    public double cooldownMultiplierBelowHalfHealth = 0.5;
    public double bonusSpeed = 0.25;
    public double magicDamageMultiplier = 3.0;
    public boolean killMinionOnWitherDeath = true;
    public double aboveHalfHealthBowChance = 0.6;
    public double belowHalfHealthBowChance = 0.08;
    public double sharpnessChance = 2.4;
    public double powerChance = 3.2;
    public double knockbackChance = 2.4;
    public double punchChance = 1.5;

    public MinionFeature(Module module) {
        super(Config.builder, module);
        this.pushConfig(Config.builder);
        this.minionAtDifficultyConfig = Config.builder.comment("At which difficulty the Wither starts spawning Minions").defineInRange("Minion at Difficulty", this.minionAtDifficulty, 0, Integer.MAX_VALUE);
        this.bonusMinionEveryDifficultyConfig = Config.builder.comment("As the Wither starts spawning Minions, every how much difficulty the Wither will spawn one more Minion").defineInRange("Bonus Minion Every Difficulty", this.bonusMinionEveryDifficulty, 0, Integer.MAX_VALUE);
        this.maxSpawnedConfig = Config.builder.comment("Maximum Minions spawned by the Wither").defineInRange("Max Minions Spawned", this.maxSpawned, 0, Integer.MAX_VALUE);
        this.maxAroundConfig = Config.builder.comment("Maximum amount of Minions that can be around the Wither in a 16 block radius. After this number is reached the Wither will stop spawning minions. Set to 0 to disable this check").defineInRange("Max Minions Around", this.maxAround, 0, Integer.MAX_VALUE);
        this.minCooldownConfig = Config.builder.comment("Minimum ticks (20 ticks = 1 seconds) after Minions can spwan.").defineInRange("Minimum Cooldown", this.minCooldown, 0, Integer.MAX_VALUE);
        this.maxCooldownConfig = Config.builder.comment("Maximum ticks (20 ticks = 1 seconds) after Minions can spwan.").defineInRange("Maximum Cooldown", this.maxCooldown, 0, Integer.MAX_VALUE);
        this.cooldownMultiplierBelowHalfHealthConfig = Config.builder.comment("Min and Max cooldowns are multiplied by this value when the Wither drops below half health. Set to 1 to not change the cooldown when the wither's health drops below half.").defineInRange("Cooldown Multiplier Below Half Health", this.cooldownMultiplierBelowHalfHealth, 0.0, Double.MAX_VALUE);
        this.bonusSpeedConfig = Config.builder.comment("Percentage bonus speed at max difficulty.").defineInRange("Bonus Movement Speed Per Difficulty", this.bonusSpeed, 0.0, Double.MAX_VALUE);
        this.magicDamageMultiplierConfig = Config.builder.comment("Wither Minions will take magic damage multiplied by this value.").defineInRange("Magic Damage Multiplier", this.magicDamageMultiplier, 0.0, Double.MAX_VALUE);
        this.killMinionOnWitherDeathConfig = Config.builder.comment("Wither Minions will die when the Wither that spawned them dies.").define("Kill Minions on Wither Death", this.killMinionOnWitherDeath);
        Config.builder.push("Equipment");
        this.aboveHalfHealthBowChanceConfig = Config.builder.comment("Chance for the Wither Minion to spawn with a bow instead of a Stone Sword when Wither's above Half Health").defineInRange("Bow Chance Above Half Health", this.aboveHalfHealthBowChance, 0.0, 1.0);
        this.belowHalfHealthBowChanceConfig = Config.builder.comment("Chance for the Wither Minion to spawn with a bow instead of a Stone Sword when Wither's below Half Health").defineInRange("Bow Chance Below Half Health", this.belowHalfHealthBowChance, 0.0, 1.0);
        Config.builder.push("Enchantments");
        this.sharpnessChanceConfig = Config.builder.comment("Chance (at max difficulty) for the Wither Minion's Sword to be enchanted with Sharpness. Note that every 100% chance adds one guaranteed level of the enchantment, while the remaining dictates the chance to add on more level.").defineInRange("Sharpness Chance", this.sharpnessChance, 0.0, 255.0);
        this.knockbackChanceConfig = Config.builder.comment("Chance (at max difficulty) for the Wither Minion's Sword to be enchanted with Knockback. Note that every 100% chance adds one guaranteed level of the enchantment, while the remaining dictates the chance to add on more level.").defineInRange("Knockback Chance", this.knockbackChance, 0.0, 255.0);
        this.powerChanceConfig = Config.builder.comment("Chance (at max difficulty) for the Wither Minion's Bow to be enchanted with Power. Note that every 100% chance adds one guaranteed level of the enchantment, while the remaining dictates the chance to add on more level.").defineInRange("Power Chance", this.powerChance, 0.0, 255.0);
        this.punchChanceConfig = Config.builder.comment("Chance (at max difficulty) for the Wither Minion's Bow to be enchanted with Punch. Note that every 100% chance adds one guaranteed level of the enchantment, while the remaining dictates the chance to add on more level.").defineInRange("Punch Chance", this.punchChance, 0.0, 255.0);
        Config.builder.pop(2);
        Config.builder.pop();
    }

    public void loadConfig() {
        super.loadConfig();
        this.minionAtDifficulty = (Integer)this.minionAtDifficultyConfig.get();
        this.bonusMinionEveryDifficulty = (Integer)this.bonusMinionEveryDifficultyConfig.get();
        this.maxSpawned = (Integer)this.maxSpawnedConfig.get();
        this.maxAround = (Integer)this.maxAroundConfig.get();
        this.minCooldown = (Integer)this.minCooldownConfig.get();
        this.maxCooldown = (Integer)this.maxCooldownConfig.get();
        if (this.minCooldown > this.maxCooldown) {
            this.minCooldown = this.maxCooldown;
        }
        this.cooldownMultiplierBelowHalfHealth = (Double)this.cooldownMultiplierBelowHalfHealthConfig.get();
        this.bonusSpeed = (Double)this.bonusSpeedConfig.get();
        this.magicDamageMultiplier = (Double)this.magicDamageMultiplierConfig.get();
        this.killMinionOnWitherDeath = (Boolean)this.killMinionOnWitherDeathConfig.get();
        this.aboveHalfHealthBowChance = (Double)this.aboveHalfHealthBowChanceConfig.get();
        this.belowHalfHealthBowChance = (Double)this.belowHalfHealthBowChanceConfig.get();
        this.sharpnessChance = (Double)this.sharpnessChanceConfig.get();
        this.knockbackChance = (Double)this.knockbackChanceConfig.get();
        this.powerChance = (Double)this.powerChanceConfig.get();
        this.punchChance = (Double)this.punchChanceConfig.get();
    }

    @SubscribeEvent
    public void onWitherSpawn(EntityJoinWorldEvent event) {
        if (event.getWorld().f_46443_) {
            return;
        }
        if (!this.isEnabled()) {
            return;
        }
        Entity entity = event.getEntity();
        if (!(entity instanceof WitherBoss)) {
            return;
        }
        WitherBoss wither = (WitherBoss)entity;
        CompoundTag witherTags = wither.getPersistentData();
        int cooldown = (int)((double)Mth.m_14072_((Random)wither.f_19853_.f_46441_, (int)this.minCooldown, (int)this.maxCooldown) * this.cooldownMultiplierBelowHalfHealth);
        witherTags.m_128405_("progressivebosses:wither_minion_cooldown", cooldown);
    }

    @SubscribeEvent
    public void update(LivingEvent.LivingUpdateEvent event) {
        BlockPos pos2;
        if (event.getEntity().f_19853_.f_46443_) {
            return;
        }
        if (!this.isEnabled()) {
            return;
        }
        Entity entity = event.getEntity();
        if (!(entity instanceof WitherBoss)) {
            return;
        }
        WitherBoss wither = (WitherBoss)entity;
        Level world = event.getEntity().f_19853_;
        CompoundTag witherTags = wither.getPersistentData();
        float difficulty = witherTags.m_128457_("progressivebosses:difficulty");
        if (difficulty < (float)this.minionAtDifficulty) {
            return;
        }
        if (wither.m_21223_() <= 0.0f) {
            return;
        }
        if (wither.m_31502_() > 0) {
            return;
        }
        int cooldown = witherTags.m_128451_("progressivebosses:wither_minion_cooldown");
        if (cooldown > 0) {
            witherTags.m_128405_("progressivebosses:wither_minion_cooldown", cooldown - 1);
            return;
        }
        int radius = 32;
        BlockPos pos1 = wither.m_142538_().m_142082_(-radius, -radius, -radius);
        AABB bb = new AABB(pos1, pos2 = wither.m_142538_().m_142082_(radius, radius, radius));
        List players = world.m_45976_(ServerPlayer.class, bb);
        if (players.isEmpty()) {
            return;
        }
        List minionsInAABB = world.m_45976_(WitherMinion.class, wither.m_142469_().m_82400_(16.0));
        int minionsCountInAABB = minionsInAABB.size();
        if (minionsCountInAABB >= this.maxAround) {
            return;
        }
        int minCooldown = this.minCooldown;
        int maxCooldown = this.maxCooldown;
        cooldown = Mth.m_14072_((Random)world.f_46441_, (int)minCooldown, (int)maxCooldown);
        if (wither.m_7090_()) {
            cooldown = (int)((double)cooldown * this.cooldownMultiplierBelowHalfHealth);
        }
        witherTags.m_128405_("progressivebosses:wither_minion_cooldown", cooldown - 1);
        int minionSpawnedCount = 0;
        int i = this.minionAtDifficulty;
        while ((float)i <= difficulty) {
            int x = 0;
            int y = 0;
            int z = 0;
            for (int t = 0; t < 5; ++t) {
                x = (int)(wither.m_20185_() + (double)Mth.m_14072_((Random)world.f_46441_, (int)-3, (int)3));
                y = (int)(wither.m_20186_() + 3.0);
                z = (int)(wither.m_20189_() + (double)Mth.m_14072_((Random)world.f_46441_, (int)-3, (int)3));
                y = MCUtils.getFittingY((EntityType)((EntityType)PBEntities.WITHER_MINION.get()), (BlockPos)new BlockPos(x, y, z), (Level)world, (int)8);
                if (y != -1) break;
            }
            if (y > wither.f_19853_.m_141937_()) {
                WitherMinion witherMinion = this.summonMinion(world, new Vec3((double)x + 0.5, (double)y + 0.5, (double)z + 0.5), DifficultyHelper.getScalingDifficulty((LivingEntity)wither), wither.m_7090_());
                ListTag minionsList = witherTags.m_128437_("progressivebosses:minions", 10);
                CompoundTag uuid = new CompoundTag();
                uuid.m_128362_("uuid", witherMinion.m_142081_());
                minionsList.add((Object)uuid);
                witherTags.m_128365_("progressivebosses:minions", (Tag)minionsList);
                if (++minionSpawnedCount >= this.maxSpawned || ++minionsCountInAABB >= this.maxAround) break;
            }
            i += this.bonusMinionEveryDifficulty;
        }
    }

    @SubscribeEvent
    public void onMinionDamage(LivingDamageEvent event) {
        if (!this.isEnabled()) {
            return;
        }
        if (this.magicDamageMultiplier == 0.0) {
            return;
        }
        if (!(event.getEntity() instanceof WitherMinion)) {
            return;
        }
        if (event.getSource().m_19387_()) {
            event.setAmount((float)((double)event.getAmount() * this.magicDamageMultiplier));
        }
    }

    @SubscribeEvent
    public void onDeath(LivingDeathEvent event) {
        if (event.getEntity().f_19853_.f_46443_ || !this.isEnabled() || !this.killMinionOnWitherDeath) {
            return;
        }
        Entity entity = event.getEntity();
        if (!(entity instanceof WitherBoss)) {
            return;
        }
        WitherBoss wither = (WitherBoss)entity;
        ServerLevel world = (ServerLevel)wither.f_19853_;
        CompoundTag tags = wither.getPersistentData();
        ListTag minionsList = tags.m_128437_("progressivebosses:minions", 10);
        for (int i = 0; i < minionsList.size(); ++i) {
            UUID uuid = minionsList.m_128728_(i).m_128342_("uuid");
            WitherMinion witherMinion = (WitherMinion)world.m_8791_(uuid);
            if (witherMinion == null) continue;
            witherMinion.m_7292_(new MobEffectInstance(MobEffects.f_19601_, 10000, 0, false, false));
        }
    }

    @SubscribeEvent
    public void onEntityDeath(LivingDeathEvent event) {
        Entity entity;
        if (event.getEntity().f_19853_.f_46443_ || !this.isEnabled() || !((entity = event.getSource().m_7639_()) instanceof WitherMinion)) {
            return;
        }
        WitherMinion witherMinion = (WitherMinion)entity;
        LivingEntity livingEntity = event.getEntityLiving();
        boolean hasPlantedRose = false;
        if (ForgeEventFactory.getMobGriefingEvent((Level)witherMinion.f_19853_, (Entity)witherMinion)) {
            BlockPos blockpos = livingEntity.m_142538_();
            BlockState blockstate = Blocks.f_50070_.m_49966_();
            if (livingEntity.f_19853_.m_46859_(blockpos) && blockstate.m_60710_((LevelReader)livingEntity.f_19853_, blockpos)) {
                livingEntity.f_19853_.m_7731_(blockpos, blockstate, 3);
                hasPlantedRose = true;
            }
        }
        if (!hasPlantedRose) {
            ItemEntity itementity = new ItemEntity(livingEntity.f_19853_, livingEntity.m_20185_(), livingEntity.m_20186_(), livingEntity.m_20189_(), new ItemStack((ItemLike)Items.f_41951_));
            livingEntity.f_19853_.m_7967_((Entity)itementity);
        }
    }

    private void setEquipment(WitherMinion witherMinion, float scalingDifficulty, boolean isCharged) {
        ItemStack item;
        double bowChance;
        witherMinion.m_21409_(EquipmentSlot.MAINHAND, Float.MIN_VALUE);
        double d = bowChance = isCharged ? this.belowHalfHealthBowChance : this.aboveHalfHealthBowChance;
        if (Mth.m_14064_((Random)witherMinion.f_19853_.m_5822_(), (double)0.0, (double)1.0) < bowChance) {
            int punchLevel;
            item = new ItemStack((ItemLike)Items.f_42411_);
            int powerLevel = MathHelper.getAmountWithDecimalChance((Random)witherMinion.m_21187_(), (double)(this.powerChance * (double)scalingDifficulty));
            if (powerLevel > 0) {
                item.m_41663_(Enchantments.f_44988_, powerLevel);
            }
            if ((punchLevel = MathHelper.getAmountWithDecimalChance((Random)witherMinion.m_21187_(), (double)(this.punchChance * (double)scalingDifficulty))) > 0) {
                item.m_41663_(Enchantments.f_44989_, punchLevel);
            }
        } else {
            int knockbackLevel;
            item = new ItemStack((ItemLike)Items.f_42425_);
            int sharpnessLevel = MathHelper.getAmountWithDecimalChance((Random)witherMinion.m_21187_(), (double)(this.sharpnessChance * (double)scalingDifficulty));
            if (sharpnessLevel > 0) {
                item.m_41663_(Enchantments.f_44977_, sharpnessLevel);
            }
            if ((knockbackLevel = MathHelper.getAmountWithDecimalChance((Random)witherMinion.m_21187_(), (double)(this.knockbackChance * (double)scalingDifficulty))) > 0) {
                item.m_41663_(Enchantments.f_44980_, knockbackLevel);
            }
        }
        witherMinion.m_8061_(EquipmentSlot.MAINHAND, item);
    }

    public WitherMinion summonMinion(Level world, Vec3 pos, float scalingDifficulty, boolean isCharged) {
        WitherMinion witherMinion = new WitherMinion((EntityType<? extends AbstractSkeleton>)((EntityType)PBEntities.WITHER_MINION.get()), world);
        CompoundTag minionTags = witherMinion.getPersistentData();
        minionTags.m_128379_("mobspropertiesrandomness:processed", true);
        witherMinion.m_6034_(pos.f_82479_, pos.f_82480_, pos.f_82481_);
        this.setEquipment(witherMinion, scalingDifficulty, isCharged);
        witherMinion.m_21409_(EquipmentSlot.MAINHAND, -0.1f);
        witherMinion.m_21553_(false);
        witherMinion.m_21530_();
        double speedBonus = this.bonusSpeed * (double)scalingDifficulty;
        MCUtils.applyModifier((LivingEntity)witherMinion, (Attribute)Attributes.f_22279_, (UUID)Strings.AttributeModifiers.MOVEMENT_SPEED_BONUS_UUID, (String)"progressivebosses:movement_speed_bonus", (double)speedBonus, (AttributeModifier.Operation)AttributeModifier.Operation.MULTIPLY_BASE);
        world.m_7967_((Entity)witherMinion);
        return witherMinion;
    }
}

