/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.insanelib.base;

import insane96mcp.insanelib.base.Label;
import insane96mcp.insanelib.base.Module;
import insane96mcp.insanelib.util.LogHelper;
import java.lang.reflect.Method;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class Feature {
    private final String name;
    private final String description;
    private final ForgeConfigSpec.ConfigValue<Boolean> enabledConfig;
    private final Module module;
    private final boolean canBeDisabled;
    private boolean enabled;

    public Feature(ForgeConfigSpec.Builder builder, Module module, boolean enabledByDefault, boolean canBeDisabled) {
        if (!this.getClass().isAnnotationPresent(Label.class)) {
            LogHelper.error(String.format("%s is missing the Label Annotation.", this.getClass().getName()), new Object[0]);
        }
        this.name = this.getClass().getAnnotation(Label.class).name();
        this.description = this.getClass().getAnnotation(Label.class).description();
        this.module = module;
        this.canBeDisabled = canBeDisabled;
        this.enabledConfig = canBeDisabled ? (!this.description.equals("") ? builder.comment(this.getDescription()).define("Enable " + this.getName(), enabledByDefault) : builder.define("Enable " + this.getName(), enabledByDefault)) : null;
        this.registerEvents();
    }

    public Feature(ForgeConfigSpec.Builder builder, Module module, boolean enabledByDefault) {
        this(builder, module, enabledByDefault, true);
    }

    public Feature(ForgeConfigSpec.Builder builder, Module module) {
        this(builder, module, true);
    }

    public boolean isEnabled() {
        return this.enabled && this.isModuleEnabled();
    }

    public boolean isModuleEnabled() {
        return this.module.isEnabled();
    }

    public Module getModule() {
        return this.module;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public void loadConfig() {
        this.enabled = this.canBeDisabled ? (Boolean)this.enabledConfig.get() : true;
    }

    public void pushConfig(ForgeConfigSpec.Builder builder) {
        if (!this.description.equals("")) {
            builder.comment(this.getDescription()).push(this.getName());
        } else {
            builder.push(this.getName());
        }
    }

    public void registerEvents() {
        for (Method method : this.getClass().getDeclaredMethods()) {
            if (!method.isAnnotationPresent(SubscribeEvent.class)) continue;
            MinecraftForge.EVENT_BUS.register((Object)this);
        }
    }
}

