/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.progressivebosses.module.dragon.feature;

import insane96mcp.insanelib.base.Feature;
import insane96mcp.insanelib.base.Label;
import insane96mcp.insanelib.base.Module;
import insane96mcp.insanelib.base.config.Config;
import insane96mcp.insanelib.base.config.LoadFeature;
import insane96mcp.insanelib.util.LogHelper;
import insane96mcp.insanelib.util.MathHelper;
import insane96mcp.progressivebosses.module.dragon.phase.CrystalRespawnPhase;
import insane96mcp.progressivebosses.utils.DifficultyHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.boss.enderdragon.EndCrystal;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.boss.enderdragon.phases.DragonPhaseInstance;
import net.minecraft.world.entity.boss.enderdragon.phases.EnderDragonPhase;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.IronBarsBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.EndPodiumFeature;
import net.minecraft.world.level.levelgen.feature.SpikeFeature;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.registries.ForgeRegistries;

@Label(name="Crystals", description="Makes more Crystal spawn and with more cages.")
@LoadFeature(module="progressivebosses:ender_dragon")
public class CrystalFeature
extends Feature {
    @Config(min=-1.0)
    @Label(name="More Cages at Difficulty", description="At this difficulty cages will start to appear around other crystals too. -1 will disable this feature.")
    public static Integer moreCagesAtDifficulty = 1;
    @Config(min=0.0, max=8.0)
    @Label(name="Max Bonus Cages", description="Max number of bonus cages that can spawn around the crystals. (Vanilla already has 2 cages)")
    public static Integer maxBonusCages = 6;
    @Config(min=-1.0)
    @Label(name="More Crystals at Difficulty", description="At this difficulty one crystal will start to appear inside obsidian towers. -1 will disable this feature.")
    public static Integer moreCrystalsAtDifficulty = 2;
    @Config(min=-1.0)
    @Label(name="More Crystals Step", description="Every how much difficulty one more crystal will be spawned inside towers")
    public static Integer moreCrystalsStep = 3;
    @Config(min=0.0, max=10.0)
    @Label(name="More Crystals Max", description="Max number of bonus crystals that can spawn inside the towers.")
    public static Integer moreCrystalsMax = 3;
    @Config
    @Label(name="Enable crystal respawn", description="Everytime the dragon is hit (when below 50% of health) there's a chance to to trigger a Crystal respawn Phase. The chance is 0% when health >=50% and 100% when health <=30%, the health threshold decreases by 20% every time the dragon respawns crystals.")
    public static Boolean enableCrystalRespawn = true;
    @Config(min=0.0, max=10.0)
    @Label(name="Crystal Respawn Per Difficulty", description="At max Difficulty how many crystals will the dragon respawn.")
    public static Double crystalsRespawned = 3.0;
    @Config
    @Label(name="Explosion Immune", description="Crystals can no longer be destroyed by other explosions.")
    public static Boolean explosionImmune = true;
    private static final List<EnderDragonPhase<? extends DragonPhaseInstance>> VALID_CRYSTAL_RESPAWN_PHASES = Arrays.asList(EnderDragonPhase.f_31383_, EnderDragonPhase.f_31384_, EnderDragonPhase.f_31382_, EnderDragonPhase.f_31377_, EnderDragonPhase.f_31381_, EnderDragonPhase.f_31385_, EnderDragonPhase.f_31378_);
    private static final ResourceLocation ENDERGETIC_CRYSTAL_HOLDER_RL = new ResourceLocation("endergetic:crystal_holder");

    public CrystalFeature(Module module, boolean enabledByDefault, boolean canBeDisabled) {
        super(module, enabledByDefault, canBeDisabled);
    }

    @SubscribeEvent
    public void onDragonDamage(LivingDamageEvent event) {
        if (!this.isEnabled()) {
            return;
        }
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof EnderDragon)) {
            return;
        }
        EnderDragon dragon = (EnderDragon)livingEntity;
        if (!enableCrystalRespawn.booleanValue()) {
            return;
        }
        CompoundTag dragonTags = dragon.getPersistentData();
        if (!VALID_CRYSTAL_RESPAWN_PHASES.contains(dragon.m_31157_().m_31415_().m_7309_())) {
            return;
        }
        float healthRatio = dragon.m_21223_() / dragon.m_21233_();
        if ((double)healthRatio >= 0.8) {
            return;
        }
        byte crystalRespawn = dragonTags.m_128445_("progressivebosses:crystal_respawn");
        float chance = this.getChanceAtValue(healthRatio, 0.8f - (float)crystalRespawn * 0.35f, 0.2f - (float)crystalRespawn * 0.35f);
        if (dragon.m_217043_().m_188501_() > chance) {
            return;
        }
        dragonTags.m_128344_("progressivebosses:crystal_respawn", (byte)(crystalRespawn + 1));
        double crystalsToRespawn = Mth.m_14008_((double)(crystalsRespawned * (double)DifficultyHelper.getScalingDifficulty((LivingEntity)dragon)), (double)0.0, (double)10.0);
        crystalsToRespawn = MathHelper.getAmountWithDecimalChance((RandomSource)dragon.m_217043_(), (double)crystalsToRespawn);
        if (crystalsToRespawn == 0.0) {
            return;
        }
        dragon.m_31157_().m_31416_(CrystalRespawnPhase.getPhaseType());
        CrystalRespawnPhase phase = (CrystalRespawnPhase)dragon.m_31157_().m_31415_();
        ArrayList<SpikeFeature.EndSpike> spikes = new ArrayList<SpikeFeature.EndSpike>(SpikeFeature.m_66858_((WorldGenLevel)((ServerLevel)dragon.f_19853_)));
        spikes.sort(Comparator.comparingInt(SpikeFeature.EndSpike::m_66896_).reversed());
        int i = 0;
        while ((double)i < crystalsToRespawn) {
            SpikeFeature.EndSpike targetSpike = (SpikeFeature.EndSpike)spikes.get(i);
            phase.addCrystalRespawn(targetSpike);
            ++i;
        }
    }

    private float getChanceAtValue(float value, float max, float min) {
        return Mth.m_14036_((float)((max - min - (value - min)) / (max - min)), (float)0.0f, (float)1.0f);
    }

    @SubscribeEvent
    public void onSpawn(EntityJoinLevelEvent event) {
        Entity entity;
        if (event.getLevel().f_46443_ || !this.isEnabled() || !((entity = event.getEntity()) instanceof EnderDragon)) {
            return;
        }
        EnderDragon dragon = (EnderDragon)entity;
        CompoundTag dragonTags = dragon.getPersistentData();
        float difficulty = dragonTags.m_128457_("progressivebosses:difficulty");
        CrystalFeature.crystalCages(dragon, difficulty);
        CrystalFeature.moreCrystals(dragon, difficulty);
    }

    private static void crystalCages(EnderDragon dragon, float difficulty) {
        if (moreCagesAtDifficulty == -1 || maxBonusCages == 0 || difficulty < (float)moreCagesAtDifficulty.intValue()) {
            return;
        }
        CompoundTag dragonTags = dragon.getPersistentData();
        if (dragonTags.m_128441_("progressivebosses:crystal_cages")) {
            return;
        }
        dragonTags.m_128379_("progressivebosses:crystal_cages", true);
        ArrayList<EndCrystal> crystals = new ArrayList<EndCrystal>();
        ArrayList<SpikeFeature.EndSpike> spikes = new ArrayList<SpikeFeature.EndSpike>(SpikeFeature.m_66858_((WorldGenLevel)((ServerLevel)dragon.f_19853_)));
        spikes.sort(Comparator.comparingInt(SpikeFeature.EndSpike::m_66896_));
        for (SpikeFeature.EndSpike spike : spikes) {
            crystals.addAll(dragon.f_19853_.m_45976_(EndCrystal.class, spike.m_66905_()));
        }
        crystals.removeIf(c -> c.f_19853_.m_8055_(c.m_20183_().m_6630_(2)).m_60734_() == Blocks.f_50183_);
        int crystalsInvolved = Math.round(difficulty - (float)moreCagesAtDifficulty.intValue() + 1.0f);
        int cagesGenerated = 0;
        for (EndCrystal crystal : crystals) {
            CrystalFeature.generateCage(crystal.f_19853_, crystal.m_20183_());
            if (++cagesGenerated != crystalsInvolved && cagesGenerated != maxBonusCages) continue;
            break;
        }
    }

    private static void moreCrystals(EnderDragon dragon, float difficulty) {
        if (moreCrystalsAtDifficulty == -1 || moreCrystalsMax == 0 || difficulty < (float)moreCrystalsAtDifficulty.intValue()) {
            return;
        }
        CompoundTag dragonTags = dragon.getPersistentData();
        if (dragonTags.m_128441_("progressivebosses:more_crystals")) {
            return;
        }
        dragonTags.m_128379_("progressivebosses:more_crystals", true);
        ArrayList crystals = new ArrayList();
        ArrayList<SpikeFeature.EndSpike> spikes = new ArrayList<SpikeFeature.EndSpike>(SpikeFeature.m_66858_((WorldGenLevel)((ServerLevel)dragon.f_19853_)));
        spikes.sort(Comparator.comparingInt(SpikeFeature.EndSpike::m_66896_));
        for (SpikeFeature.EndSpike spike : spikes) {
            crystals.addAll(dragon.f_19853_.m_6443_(EndCrystal.class, spike.m_66905_(), EndCrystal::m_31065_));
        }
        int crystalsMax = (int)Math.ceil((difficulty + 1.0f - (float)moreCrystalsAtDifficulty.intValue()) / (float)moreCrystalsStep.intValue());
        if (crystalsMax <= 0) {
            return;
        }
        int crystalSpawned = 0;
        for (EndCrystal crystal : crystals) {
            CrystalFeature.generateCrystalInTower(dragon.f_19853_, crystal.m_20185_(), crystal.m_20186_(), crystal.m_20189_());
            if (++crystalSpawned != crystalsMax && crystalSpawned != moreCrystalsMax) continue;
            break;
        }
    }

    public static boolean onDamageFromExplosion(DamageSource source) {
        if (!CrystalFeature.isEnabled(CrystalFeature.class) || !explosionImmune.booleanValue()) {
            return false;
        }
        return source.m_19372_();
    }

    public static void generateCrystalInTower(Level world, double x, double y, double z) {
        Vec3 centerPodium = Vec3.m_82539_((Vec3i)world.m_5452_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, EndPodiumFeature.f_65714_));
        int spawnY = (int)(y - (double)Mth.m_216271_((RandomSource)world.m_213780_(), (int)12, (int)24));
        if ((double)spawnY < centerPodium.m_7098_()) {
            spawnY = (int)centerPodium.m_7098_();
        }
        BlockPos crystalPos = new BlockPos(x, (double)spawnY, z);
        Stream blocks = BlockPos.m_121990_((BlockPos)crystalPos.m_7918_(-1, -1, -1), (BlockPos)crystalPos.m_7918_(1, 1, 1));
        blocks.forEach(pos -> world.m_46597_(pos, Blocks.f_50016_.m_49966_()));
        BlockState baseBlockState = Blocks.f_50752_.m_49966_();
        if (ModList.get().isLoaded("endergetic")) {
            if (ForgeRegistries.BLOCKS.containsKey(ENDERGETIC_CRYSTAL_HOLDER_RL)) {
                baseBlockState = ((Block)ForgeRegistries.BLOCKS.getValue(ENDERGETIC_CRYSTAL_HOLDER_RL)).m_49966_();
            } else {
                LogHelper.warn((String)"The Endergetic Expansion is loaded but the %s block was not registered", (Object[])new Object[]{ENDERGETIC_CRYSTAL_HOLDER_RL});
            }
        }
        world.m_46597_(crystalPos.m_7918_(0, -1, 0), baseBlockState);
        world.m_254849_(null, (double)((float)crystalPos.m_123341_() + 0.5f), (double)crystalPos.m_123342_(), (double)crystalPos.m_123343_() + 0.5, 5.0f, Level.ExplosionInteraction.BLOCK);
        EndCrystal crystal = new EndCrystal(world, (double)crystalPos.m_123341_() + 0.5, (double)crystalPos.m_123342_(), (double)crystalPos.m_123343_() + 0.5);
        world.m_7967_((Entity)crystal);
    }

    public static void generateCage(Level world, BlockPos pos) {
        BlockPos.MutableBlockPos blockpos$mutable = new BlockPos.MutableBlockPos();
        for (int k = -2; k <= 2; ++k) {
            for (int l = -2; l <= 2; ++l) {
                for (int i1 = 0; i1 <= 3; ++i1) {
                    boolean flag2;
                    boolean flag = Mth.m_14040_((int)k) == 2;
                    boolean flag1 = Mth.m_14040_((int)l) == 2;
                    boolean bl = flag2 = i1 == 3;
                    if (!flag && !flag1 && !flag2) continue;
                    boolean flag3 = k == -2 || k == 2 || flag2;
                    boolean flag4 = l == -2 || l == 2 || flag2;
                    BlockState blockstate = (BlockState)((BlockState)((BlockState)((BlockState)Blocks.f_50183_.m_49966_().m_61124_((Property)IronBarsBlock.f_52309_, (Comparable)Boolean.valueOf(flag3 && l != -2))).m_61124_((Property)IronBarsBlock.f_52311_, (Comparable)Boolean.valueOf(flag3 && l != 2))).m_61124_((Property)IronBarsBlock.f_52312_, (Comparable)Boolean.valueOf(flag4 && k != -2))).m_61124_((Property)IronBarsBlock.f_52310_, (Comparable)Boolean.valueOf(flag4 && k != 2));
                    world.m_46597_((BlockPos)blockpos$mutable.m_122178_(pos.m_123341_() + k, pos.m_123342_() - 1 + i1, pos.m_123343_() + l), blockstate);
                }
            }
        }
    }
}

