/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.progressivebosses.module.dragon.feature;

import insane96mcp.insanelib.base.Feature;
import insane96mcp.insanelib.base.Label;
import insane96mcp.insanelib.base.Module;
import insane96mcp.insanelib.base.config.Config;
import insane96mcp.insanelib.base.config.LoadFeature;
import insane96mcp.insanelib.util.MCUtils;
import insane96mcp.progressivebosses.module.dragon.entity.Larva;
import insane96mcp.progressivebosses.setup.PBEntities;
import insane96mcp.progressivebosses.setup.Strings;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.EndPodiumFeature;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.event.config.ModConfigEvent;

@Label(name="Larva", description="Mini things that are just annoying.")
@LoadFeature(module="progressivebosses:ender_dragon")
public class LarvaFeature
extends Feature {
    @Config(min=0.0)
    @Label(name="Larva at Difficulty", description="At which difficulty the Ender Dragon starts spawning Larvae")
    public static Integer larvaAtDifficulty = 1;
    @Config(min=0.0)
    @Label(name="Bonus Larva Every Difficulty", description="As the Ender Dragon starts spawning Minions, every how much difficulty she will spawn one more Minions")
    public static Integer bonusLarvaEveryDifficulty = 1;
    @Config(min=0.0)
    @Label(name="Max Larvae Spawned", description="Maximum Larva spawned by the Ender Dragon")
    public static Integer maxSpawned = 7;
    @Config(min=0.0)
    @Label(name="Minimum Cooldown", description="Minimum ticks (20 ticks = 1 seconds) after Minions can spawn.")
    public static Integer minCooldown = 800;
    @Config(min=0.0)
    @Label(name="Maximum Cooldown", description="Maximum ticks (20 ticks = 1 seconds) after Minions can spawn.")
    public static Integer maxCooldown = 1400;
    @Config
    @Label(name="Reduced Dragon Damage", description="If true, Larvae will take only 10% damage from the Ender Dragon.")
    public static Boolean reducedDragonDamage = true;

    public LarvaFeature(Module module, boolean enabledByDefault, boolean canBeDisabled) {
        super(module, enabledByDefault, canBeDisabled);
    }

    public void readConfig(ModConfigEvent event) {
        super.readConfig(event);
        if (minCooldown > maxCooldown) {
            minCooldown = maxCooldown;
        }
    }

    @SubscribeEvent
    public void onDragonSpawn(EntityJoinLevelEvent event) {
        Entity entity;
        if (event.getLevel().f_46443_ || !this.isEnabled() || !((entity = event.getEntity()) instanceof EnderDragon)) {
            return;
        }
        EnderDragon dragon = (EnderDragon)entity;
        CompoundTag dragonTags = dragon.getPersistentData();
        int cooldown = (int)((double)Mth.m_216271_((RandomSource)dragon.m_217043_(), (int)minCooldown, (int)maxCooldown) * 0.5);
        dragonTags.m_128405_("progressivebosses:dragon_larva_cooldown", cooldown);
    }

    @SubscribeEvent
    public void update(LivingEvent.LivingTickEvent event) {
        LivingEntity livingEntity;
        if (event.getEntity().f_19853_.f_46443_ || !this.isEnabled() || !((livingEntity = event.getEntity()) instanceof EnderDragon)) {
            return;
        }
        EnderDragon dragon = (EnderDragon)livingEntity;
        Level world = event.getEntity().f_19853_;
        CompoundTag dragonTags = dragon.getPersistentData();
        float difficulty = dragonTags.m_128457_("progressivebosses:difficulty");
        if (difficulty < (float)larvaAtDifficulty.intValue()) {
            return;
        }
        if (dragon.m_21223_() <= 0.0f) {
            return;
        }
        int cooldown = dragonTags.m_128451_("progressivebosses:dragon_larva_cooldown");
        if (cooldown > 0) {
            dragonTags.m_128405_("progressivebosses:dragon_larva_cooldown", cooldown - 1);
            return;
        }
        BlockPos centerPodium = dragon.f_19853_.m_5452_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, EndPodiumFeature.f_65714_);
        AABB bb = new AABB(centerPodium).m_82400_(64.0);
        List players = world.m_45976_(ServerPlayer.class, bb);
        if (players.isEmpty()) {
            return;
        }
        cooldown = Mth.m_216271_((RandomSource)world.f_46441_, (int)minCooldown, (int)maxCooldown);
        dragonTags.m_128405_("progressivebosses:dragon_larva_cooldown", cooldown - 1);
        int larvaSpawnedCount = 0;
        int i = larvaAtDifficulty;
        while ((float)i <= difficulty) {
            float angle = world.f_46441_.m_188501_() * (float)Math.PI * 2.0f;
            float x = (float)Math.floor(Math.cos(angle) * (double)3.33f);
            float z = (float)Math.floor(Math.sin(angle) * (double)3.33f);
            int y = world.m_5452_(Heightmap.Types.MOTION_BLOCKING, new BlockPos((double)x, 255.0, (double)z)).m_123342_();
            LarvaFeature.summonLarva(world, new Vec3((double)x + 0.5, (double)y, (double)z + 0.5), difficulty);
            if (++larvaSpawnedCount >= maxSpawned) break;
            i += bonusLarvaEveryDifficulty.intValue();
        }
    }

    public static void summonLarva(Level world, Vec3 pos, float difficulty) {
        Larva larva = new Larva((EntityType<? extends Larva>)((EntityType)PBEntities.LARVA.get()), world);
        CompoundTag minionTags = larva.getPersistentData();
        minionTags.m_128379_("mobspropertiesrandomness:processed", true);
        larva.m_6034_(pos.f_82479_, pos.f_82480_, pos.f_82481_);
        larva.m_21530_();
        MCUtils.applyModifier((LivingEntity)larva, (Attribute)Attributes.f_22281_, (UUID)Strings.AttributeModifiers.ATTACK_DAMAGE_BONUS_UUID, (String)"progressivebosses:attack_damage_bonus", (double)(0.35 * (double)difficulty), (AttributeModifier.Operation)AttributeModifier.Operation.ADDITION);
        MCUtils.applyModifier((LivingEntity)larva, (Attribute)((Attribute)ForgeMod.SWIM_SPEED.get()), (UUID)Strings.AttributeModifiers.SWIM_SPEED_BONUS_UUID, (String)"progressivebosses:swim_speed_bonus", (double)2.5, (AttributeModifier.Operation)AttributeModifier.Operation.MULTIPLY_BASE);
        world.m_7967_((Entity)larva);
    }

    public static boolean shouldTakeReducedDamage(DamageSource damageSource) {
        return damageSource.m_7639_() instanceof EnderDragon && LarvaFeature.isEnabled(LarvaFeature.class) && reducedDragonDamage != false;
    }
}

