/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.progressivebosses.module.wither.feature;

import insane96mcp.insanelib.base.Feature;
import insane96mcp.insanelib.base.Label;
import insane96mcp.insanelib.base.Module;
import insane96mcp.insanelib.base.config.Config;
import insane96mcp.insanelib.base.config.LoadFeature;
import insane96mcp.insanelib.util.MCUtils;
import insane96mcp.progressivebosses.setup.Strings;
import insane96mcp.progressivebosses.utils.DifficultyHelper;
import java.util.UUID;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.boss.wither.WitherBoss;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@Label(name="Health", description="Bonus Health and Bonus regeneration. The feature even fixes the Wither health bar not updating on spawn.")
@LoadFeature(module="progressivebosses:wither")
public class HealthFeature
extends Feature {
    @Config(min=0.0)
    @Label(name="Health Bonus per Difficulty", description="Increase Wither's Health by this value at max difficulty (scales accordingly at lower difficulties)")
    public static Double bonusHealth = 720.0;
    @Config(min=0.0)
    @Label(name="Maximum Bonus Regeneration", description="Maximum bonus regeneration per second given by \"Bonus Regeneration\".\nSet to 0 to disable bonus health regeneration. This doesn't affect the natural regeneration of the Wither (1 Health per Second).\nNote that this bonus health regen is disabled when Wither's health is between 49% and 50% to prevent making it impossible to approach when reaches half health.")
    public static Double maxBonusRegen = 2.0;
    @Config(min=0.0)
    @Label(name="Bonus Regeneration", description="How many half hearts will the Wither regen at max difficulty. This is added to the natural regeneration of the Wither (1 Health per Second).")
    public static Double bonusRegen = 2.4;
    @Config(min=0.0, max=2.0)
    @Label(name="Bonus Regeneration Ratio When Hit", description="Bonus regeneration will be multiplied by this ratio when the Wither has been hit in the last 3 seconds.")
    public static Double bonusRegenRatioWhenHit = 0.6;

    public HealthFeature(Module module, boolean enabledByDefault, boolean canBeDisabled) {
        super(module, enabledByDefault, canBeDisabled);
    }

    @SubscribeEvent
    public void onSpawn(EntityJoinLevelEvent event) {
        WitherBoss wither;
        Entity entity;
        if (event.getLevel().f_46443_ || !this.isEnabled() || bonusHealth == 0.0 || !((entity = event.getEntity()) instanceof WitherBoss) || (wither = (WitherBoss)entity).m_21051_(Attributes.f_22276_).m_22111_(Strings.AttributeModifiers.BONUS_HEALTH_UUID) != null) {
            return;
        }
        MCUtils.applyModifier((LivingEntity)wither, (Attribute)Attributes.f_22276_, (UUID)Strings.AttributeModifiers.BONUS_HEALTH_UUID, (String)"progressivebosses:bonus_health", (double)(bonusHealth * (double)DifficultyHelper.getScalingDifficulty((LivingEntity)wither)), (AttributeModifier.Operation)AttributeModifier.Operation.ADDITION);
    }

    @SubscribeEvent
    public void onUpdate(LivingEvent.LivingTickEvent event) {
        WitherBoss wither;
        block7: {
            block6: {
                LivingEntity livingEntity;
                if (event.getEntity().f_19853_.f_46443_ || !this.isEnabled() || !((livingEntity = event.getEntity()) instanceof WitherBoss)) break block6;
                wither = (WitherBoss)livingEntity;
                if (bonusRegen != 0.0 && maxBonusRegen != 0.0 && wither.m_31502_() <= 0 && wither.m_6084_()) break block7;
            }
            return;
        }
        if (wither.m_21223_() / wither.m_21233_() > 0.49f && wither.m_21223_() / wither.m_21233_() < 0.5f) {
            return;
        }
        float heal = (float)Math.min(bonusRegen * (double)DifficultyHelper.getScalingDifficulty((LivingEntity)wither), maxBonusRegen);
        heal /= 20.0f;
        if (wither.f_19797_ - wither.m_21213_() <= 60) {
            heal = (float)((double)heal * bonusRegenRatioWhenHit);
        }
        if (heal > 0.0f) {
            wither.m_5634_(heal);
        }
    }
}

