/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.progressivebosses.module.wither.ai;

import com.mojang.datafixers.util.Pair;
import insane96mcp.progressivebosses.module.wither.feature.AttackFeature;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.EnumSet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.boss.wither.WitherBoss;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;

public class WitherChargeAttackGoal
extends Goal {
    static ResourceKey<DamageType> WITHER_CHARGE_DAMAGE_TYPE = ResourceKey.m_135785_((ResourceKey)Registries.f_268580_, (ResourceLocation)new ResourceLocation("progressivebosses", "wither_charge"));
    private final WitherBoss wither;
    private LivingEntity target;
    private Vec3 targetPos;
    private double lastDistanceFromTarget = 0.0;
    ObjectArrayList<Pair<ItemStack, BlockPos>> blocksToDrop = new ObjectArrayList();

    public WitherChargeAttackGoal(WitherBoss wither) {
        this.wither = wither;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP, Goal.Flag.LOOK, Goal.Flag.TARGET));
    }

    public boolean m_8036_() {
        byte chargeTick = this.wither.getPersistentData().m_128445_("progressivebosses:charge_attack");
        return chargeTick > 0;
    }

    public void m_8056_() {
        this.wither.m_21573_().m_26573_();
        for (int h = 0; h < 3; ++h) {
            this.wither.m_31454_(h, 0);
        }
        this.wither.f_19853_.m_5594_(null, this.wither.m_20183_(), SoundEvents.f_12556_, SoundSource.HOSTILE, 5.0f, 2.0f);
        this.blocksToDrop.clear();
    }

    public boolean m_8045_() {
        return this.wither.getPersistentData().m_128445_("progressivebosses:charge_attack") > 0;
    }

    public void m_8041_() {
        this.target = null;
        this.wither.m_20256_(this.wither.m_20184_().m_82542_(0.02, 0.02, 0.02));
        this.lastDistanceFromTarget = 0.0;
        this.targetPos = null;
        for (Pair pair : this.blocksToDrop) {
            Block.m_49840_((Level)this.wither.f_19853_, (BlockPos)((BlockPos)pair.getSecond()), (ItemStack)((ItemStack)pair.getFirst()));
        }
    }

    public void m_8037_() {
        byte chargeTick = this.wither.getPersistentData().m_128445_("progressivebosses:charge_attack");
        if (chargeTick <= 0) {
            this.m_8041_();
            return;
        }
        if (chargeTick > 30) {
            this.wither.m_20256_(Vec3.f_82478_);
        }
        if (chargeTick == 30) {
            this.target = this.wither.f_19853_.m_45924_(this.wither.m_20185_(), this.wither.m_20186_(), this.wither.m_20189_(), 64.0, true);
            if (this.target != null) {
                this.targetPos = this.target.m_20182_().m_82520_(0.0, -1.5, 0.0);
                Vec3 forward = this.targetPos.m_82546_(this.wither.m_20182_()).m_82541_();
                this.targetPos = this.targetPos.m_82549_(forward.m_82542_(4.0, 4.0, 4.0));
                this.lastDistanceFromTarget = this.targetPos.m_82557_(this.wither.m_20182_());
                this.wither.f_19853_.m_5594_(null, BlockPos.m_274446_((Position)this.targetPos), SoundEvents.f_12563_, SoundSource.HOSTILE, 4.0f, 2.0f);
            } else {
                AttackFeature.stopCharging(this.wither);
            }
        } else if (chargeTick < 30) {
            if (this.targetPos == null) {
                AttackFeature.stopCharging(this.wither);
                return;
            }
            double mult = 60.0 / (double)chargeTick;
            Vec3 diff = this.targetPos.m_82546_(this.wither.m_20182_()).m_82541_().m_82542_(mult, mult, mult);
            this.wither.m_20334_(diff.f_82479_, diff.f_82480_ * 0.5, diff.f_82481_);
            this.wither.m_21563_().m_24964_(this.targetPos);
            AABB axisAlignedBB = new AABB(this.wither.m_20185_() - 2.0, this.wither.m_20186_() - 2.0, this.wither.m_20189_() - 2.0, this.wither.m_20185_() + 2.0, this.wither.m_20186_() + 6.0, this.wither.m_20189_() + 2.0);
            Stream blocks = BlockPos.m_121921_((AABB)axisAlignedBB);
            AtomicBoolean hasBrokenBlocks = new AtomicBoolean(false);
            if (ForgeEventFactory.getMobGriefingEvent((Level)this.wither.f_19853_, (Entity)this.wither)) {
                blocks.forEach(blockPos -> {
                    BlockState state = this.wither.f_19853_.m_8055_(blockPos);
                    if (state.canEntityDestroy((BlockGetter)this.wither.f_19853_, blockPos, (Entity)this.wither) && ForgeEventFactory.onEntityDestroyBlock((LivingEntity)this.wither, (BlockPos)blockPos, (BlockState)state) && !state.m_60734_().equals(Blocks.f_50016_)) {
                        BlockEntity tileentity = state.m_155947_() ? this.wither.f_19853_.m_7702_(blockPos) : null;
                        LootContext.Builder lootcontext$builder = new LootContext.Builder((ServerLevel)this.wither.f_19853_).m_230911_(this.wither.f_19853_.f_46441_).m_78972_(LootContextParams.f_81460_, (Object)Vec3.m_82512_((Vec3i)blockPos)).m_78972_(LootContextParams.f_81463_, (Object)ItemStack.f_41583_).m_78984_(LootContextParams.f_81462_, (Object)tileentity);
                        state.m_60724_(lootcontext$builder).forEach(itemStack -> WitherChargeAttackGoal.addBlockDrops(this.blocksToDrop, itemStack, blockPos));
                        this.wither.f_19853_.m_46597_(blockPos, Blocks.f_50016_.m_49966_());
                        hasBrokenBlocks.set(true);
                    }
                });
            }
            if (hasBrokenBlocks.get() && this.wither.f_19797_ % 2 == 0) {
                this.wither.f_19853_.m_5594_(null, BlockPos.m_274446_((Position)this.targetPos), SoundEvents.f_12555_, SoundSource.HOSTILE, 1.0f, 0.75f);
            }
            axisAlignedBB = axisAlignedBB.m_82400_(1.0);
            this.wither.f_19853_.m_45976_(LivingEntity.class, axisAlignedBB).forEach(entity -> {
                if (entity == this.wither) {
                    return;
                }
                entity.m_6469_(entity.m_269291_().m_269298_(WITHER_CHARGE_DAMAGE_TYPE, (Entity)this.wither), AttackFeature.chargeAttackBaseDamage.floatValue());
                double d2 = entity.m_20185_() - this.wither.m_20185_();
                double d3 = entity.m_20189_() - this.wither.m_20189_();
                double d4 = Math.max(d2 * d2 + d3 * d3, 0.1);
                entity.m_5997_(d2 / d4 * 20.0, 0.7, d3 / d4 * 20.0);
            });
        }
        if (chargeTick < 30 && (this.targetPos.m_82557_(this.wither.m_20182_()) - this.lastDistanceFromTarget > 16.0 || this.targetPos.m_82557_(this.wither.m_20182_()) < 4.0) || chargeTick == 1) {
            AttackFeature.stopCharging(this.wither);
        }
        if (this.targetPos != null) {
            this.lastDistanceFromTarget = this.targetPos.m_82557_(this.wither.m_20182_());
        }
    }

    public boolean m_183429_() {
        return true;
    }

    private static void addBlockDrops(ObjectArrayList<Pair<ItemStack, BlockPos>> p_46068_, ItemStack p_46069_, BlockPos p_46070_) {
        int i = p_46068_.size();
        for (int j = 0; j < i; ++j) {
            Pair pair = (Pair)p_46068_.get(j);
            ItemStack itemstack = (ItemStack)pair.getFirst();
            if (!ItemEntity.m_32026_((ItemStack)itemstack, (ItemStack)p_46069_)) continue;
            ItemStack itemstack1 = ItemEntity.m_32029_((ItemStack)itemstack, (ItemStack)p_46069_, (int)16);
            p_46068_.set(j, (Object)Pair.of((Object)itemstack1, (Object)((BlockPos)pair.getSecond())));
            if (!p_46069_.m_41619_()) continue;
            return;
        }
        p_46068_.add((Object)Pair.of((Object)p_46069_, (Object)p_46070_));
    }
}

