/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.insanelib.network;

import insane96mcp.insanelib.network.ClientNetworkHandler;
import insane96mcp.insanelib.network.NetworkHandler;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;

public class MessageCreeperDataSync {
    int id;
    short fuse;
    byte explosionRadius;

    public MessageCreeperDataSync(int id, short fuse, byte explosionRadius) {
        this.id = id;
        this.fuse = fuse;
        this.explosionRadius = explosionRadius;
    }

    public static void encode(MessageCreeperDataSync pkt, FriendlyByteBuf buf) {
        buf.writeInt(pkt.id);
        buf.writeShort((int)pkt.fuse);
        buf.writeByte((int)pkt.explosionRadius);
    }

    public static MessageCreeperDataSync decode(FriendlyByteBuf buf) {
        return new MessageCreeperDataSync(buf.readInt(), buf.readShort(), buf.readByte());
    }

    public static void handle(MessageCreeperDataSync message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> ClientNetworkHandler.handleCreeperDataSyncMessage(message.id, message.fuse, message.explosionRadius));
        ctx.get().setPacketHandled(true);
    }

    public static void syncCreeperToPlayers(Creeper creeper) {
        CompoundTag compound = new CompoundTag();
        creeper.m_7380_(compound);
        MessageCreeperDataSync msg = new MessageCreeperDataSync(creeper.m_19879_(), compound.m_128448_("Fuse"), compound.m_128445_("ExplosionRadius"));
        for (Player player : creeper.f_19853_.m_6907_()) {
            NetworkHandler.CHANNEL.sendTo((Object)msg, ((ServerPlayer)player).f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
        }
    }
}

