/*
 * Decompiled with CFR 0.152.
 */
package de.impelon.disenchanter;

import de.impelon.disenchanter.DisenchanterConfig;
import de.impelon.disenchanter.DisenchantingProperties;
import de.impelon.disenchanter.block.TableVariant;
import de.impelon.disenchanter.inventory.IDisenchantmentItemHandler;
import de.impelon.disenchanter.item.ItemExperienceJar;
import de.impelon.disenchanter.proxy.CommonProxy;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.init.Items;
import net.minecraft.item.ItemEnchantedBook;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;

public class DisenchantingUtils {
    public static ItemStack disenchantInInventory(IDisenchantmentItemHandler inventory, World world, BlockPos position, Random random) {
        return DisenchantingUtils.disenchantInInventory(inventory, DisenchantingProperties.getPropertiesFromStateAt(world, position), 0, world, position, random);
    }

    public static ItemStack disenchantInInventory(IDisenchantmentItemHandler inventory, int startIndex, World world, BlockPos position, Random random) {
        return DisenchantingUtils.disenchantInInventory(inventory, DisenchantingProperties.getPropertiesFromStateAt(world, position), startIndex, world, position, random);
    }

    public static ItemStack disenchantInInventory(IDisenchantmentItemHandler inventory, DisenchantingProperties properties, int startIndex, World world, BlockPos position, Random random) {
        ItemStack result = DisenchantingUtils.simulateDisenchantingInInventory(inventory, properties, false, startIndex, world, position, random);
        if (!result.func_190926_b() && !world.field_72995_K) {
            world.func_184133_a(null, position, CommonProxy.disenchantmentTableUse, SoundCategory.BLOCKS, properties.is(TableVariant.AUTOMATIC) ? 0.5f : 1.0f, random.nextFloat() * 0.1f + 0.9f);
        }
        return result;
    }

    public static ItemStack simulateDisenchantingInInventory(IDisenchantmentItemHandler inventory, boolean ignoreEnchantmentLoss, World world, BlockPos position, Random random) {
        return DisenchantingUtils.simulateDisenchantingInInventory(inventory, DisenchantingProperties.getPropertiesFromStateAt(world, position), ignoreEnchantmentLoss, 0, world, position, random);
    }

    public static ItemStack simulateDisenchantingInInventory(IDisenchantmentItemHandler inventory, boolean ignoreEnchantmentLoss, int startIndex, World world, BlockPos position, Random random) {
        return DisenchantingUtils.simulateDisenchantingInInventory(inventory, DisenchantingProperties.getPropertiesFromStateAt(world, position), ignoreEnchantmentLoss, startIndex, world, position, random);
    }

    public static ItemStack simulateDisenchantingInInventory(IDisenchantmentItemHandler inventory, DisenchantingProperties properties, boolean ignoreEnchantmentLoss, int startIndex, World world, BlockPos position, Random random) {
        if (properties.hasPersistantInventory() && !inventory.getOutputStack().func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        ItemStack source = inventory.getSourceStack();
        ItemStack receiver = inventory.getReceiverStack();
        ItemStack target = DisenchantingUtils.getAppropriateResultTarget(receiver);
        if (target.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        if (DisenchantingUtils.disenchant(source, target, properties, ignoreEnchantmentLoss, startIndex, world, position, random)) {
            if (receiver.func_190916_E() > 1) {
                receiver.func_190920_e(receiver.func_190916_E() - 1);
            } else {
                receiver = ItemStack.field_190927_a;
            }
            inventory.setReceiverStack(receiver);
            if (DisenchantingUtils.isItemStackBroken(source)) {
                source = ItemStack.field_190927_a;
            }
            if (!source.func_190926_b()) {
                if (source.func_77973_b().equals(Items.field_151134_bR) && DisenchantingUtils.getEnchantmentList(source) == null) {
                    source = new ItemStack(Items.field_151122_aG);
                }
                if (properties.is(TableVariant.VOIDING) && DisenchantingUtils.getAvailableEnchantmentIndices(source).isEmpty()) {
                    source = ItemStack.field_190927_a;
                }
            }
            inventory.setSourceStack(source);
            if (target.func_77973_b().equals(Items.field_151134_bR) && DisenchantingUtils.getEnchantmentList(target) == null) {
                target = new ItemStack(Items.field_151122_aG);
            }
            if (properties.hasPersistantInventory()) {
                inventory.setOutputStack(target);
            }
            return target;
        }
        return ItemStack.field_190927_a;
    }

    public static boolean disenchant(ItemStack source, ItemStack target, boolean ignoreEnchantmentLoss, int startIndex, World world, BlockPos position, Random random) {
        return DisenchantingUtils.disenchant(source, target, DisenchantingProperties.getPropertiesFromStateAt(world, position), ignoreEnchantmentLoss, startIndex, world, position, random);
    }

    public static boolean disenchant(ItemStack source, ItemStack target, DisenchantingProperties properties, boolean ignoreEnchantmentLoss, int startIndex, World world, BlockPos position, Random random) {
        int index;
        List<Integer> indices;
        float power = DisenchantingUtils.getEnchantingPower(world, position);
        int flatDmg = DisenchanterConfig.disenchanting.flatDamage;
        double durabilityDmg = DisenchanterConfig.disenchanting.maxDurabilityDamage;
        double reducibleDmg = DisenchanterConfig.disenchanting.maxDurabilityDamageReducible;
        double dmgMultiplier = properties.is(TableVariant.AUTOMATIC) ? DisenchanterConfig.disenchanting.machineDamageMultiplier : 1.0;
        boolean hasTransferredEnchantments = false;
        while (!(indices = DisenchantingUtils.getAvailableEnchantmentIndices(source)).isEmpty() && DisenchantingUtils.transferEnchantment(source, target, index = Math.abs(indices.get(startIndex % indices.size())), ignoreEnchantmentLoss, random)) {
            hasTransferredEnchantments = true;
            source.func_96631_a((int)(dmgMultiplier * ((double)flatDmg + (double)source.func_77958_k() * durabilityDmg + (double)source.func_77958_k() * (reducibleDmg / (double)power))), random, null);
            if (!DisenchantingUtils.isItemStackBroken(source) && properties.is(TableVariant.BULKDISENCHANTING)) continue;
            break;
        }
        return hasTransferredEnchantments;
    }

    public static boolean transferEnchantment(ItemStack source, ItemStack target, int index, boolean ignoreEnchantmentLoss, Random random) {
        if (!source.func_190926_b() && !target.func_190926_b() && source.func_77978_p() != null) {
            NBTTagList enchants = DisenchantingUtils.getEnchantmentList(source);
            if (enchants == null) {
                return false;
            }
            if (enchants.func_74745_c() > 0) {
                index = Math.min(Math.abs(index), enchants.func_74745_c() - 1);
                NBTTagCompound enchant = enchants.func_150305_b(index);
                int id = enchant.func_74762_e("id");
                int lvl = enchant.func_74762_e("lvl");
                EnchantmentData enchantment = new EnchantmentData(Enchantment.func_185262_c((int)id), lvl);
                double enchantmentLoss = DisenchanterConfig.disenchanting.enchantmentLossChance;
                if (ignoreEnchantmentLoss || (double)random.nextFloat() > enchantmentLoss) {
                    if (target.func_77973_b().equals(Items.field_151134_bR)) {
                        ItemEnchantedBook.func_92115_a((ItemStack)target, (EnchantmentData)enchantment);
                    } else if (target.func_77973_b().equals((Object)CommonProxy.itemExperienceJar)) {
                        ItemExperienceJar.ensureValidTag(target);
                        ItemExperienceJar.setStoredExperienceClamped(target, ItemExperienceJar.getStoredExperience(target) + DisenchantingUtils.getExperienceForEnchantment(enchantment.field_76302_b, enchantment.field_76303_c));
                    }
                }
                enchants.func_74744_a(index);
                double repairCostMultiplier = DisenchanterConfig.disenchanting.repairCostMultiplier;
                source.func_82841_c((int)((double)source.func_82838_A() * repairCostMultiplier));
            }
            if (enchants.func_74745_c() <= 0) {
                if (DisenchantingUtils.isEnchantmentStorage(source)) {
                    source.func_77978_p().func_82580_o("StoredEnchantments");
                } else {
                    source.func_77978_p().func_82580_o("ench");
                }
            }
            return true;
        }
        return false;
    }

    public static List<Integer> getAvailableEnchantmentIndices(ItemStack itemstack) {
        String[] disabledItems;
        ArrayList<Integer> available = new ArrayList<Integer>();
        for (String disabeledName : disabledItems = DisenchanterConfig.disenchanting.disabledItems) {
            String[] splitted = disabeledName.split("\\[r\\]", 2);
            if (!(splitted.length > 1 ? itemstack.func_77973_b().getRegistryName().toString().matches(splitted[1]) : itemstack.func_77973_b().getRegistryName().toString().equalsIgnoreCase(splitted[0]))) continue;
            return available;
        }
        NBTTagList enchants = DisenchantingUtils.getEnchantmentList(itemstack);
        if (enchants == null) {
            return available;
        }
        String[] disabledEnchantments = DisenchanterConfig.disenchanting.disabledEnchantments;
        for (int index = 0; index < enchants.func_74745_c(); ++index) {
            NBTTagCompound enchant = enchants.func_150305_b(index);
            Enchantment enchantment = Enchantment.func_185262_c((int)enchant.func_74762_e("id"));
            boolean valid = DisenchanterConfig.disenchanting.disableCurses ? enchantment.func_190936_d() : true;
            for (String disabeledName : disabledEnchantments) {
                if (!valid) break;
                String[] splitted = disabeledName.split("\\[r\\]", 2);
                if (splitted.length > 1) {
                    if (!enchantment.getRegistryName().toString().matches(splitted[1])) continue;
                    valid = false;
                    continue;
                }
                if (!enchantment.getRegistryName().toString().equalsIgnoreCase(splitted[0])) continue;
                valid = false;
            }
            if (!valid) continue;
            available.add(index);
        }
        return available;
    }

    public static NBTTagList getEnchantmentList(ItemStack itemstack) {
        if (itemstack.func_190926_b() || itemstack.func_77978_p() == null) {
            return null;
        }
        if (itemstack.func_77978_p().func_74781_a("InfiTool") != null && DisenchanterConfig.disenchanting.enableTCBehaviour) {
            return null;
        }
        if (itemstack.func_77978_p().func_74781_a("TinkerData") != null && DisenchanterConfig.disenchanting.enableTCBehaviour) {
            return null;
        }
        if (itemstack.func_77978_p().func_74781_a("ench") != null) {
            return (NBTTagList)itemstack.func_77978_p().func_74781_a("ench");
        }
        if (itemstack.func_77978_p().func_74781_a("StoredEnchantments") != null) {
            return (NBTTagList)itemstack.func_77978_p().func_74781_a("StoredEnchantments");
        }
        return null;
    }

    public static int getExperienceForEnchantment(Enchantment enchantment, int level) {
        int min = enchantment.func_77321_a(level);
        int max = enchantment.func_77317_b(level);
        int flatXp = DisenchanterConfig.disenchanting.flatExperience;
        double minEnchantabilityXp = DisenchanterConfig.disenchanting.minEnchantabilityExperience;
        double maxEnchantabilityXp = DisenchanterConfig.disenchanting.maxEnchantabilityExperience;
        return flatXp + (int)((double)min * minEnchantabilityXp + (double)max * maxEnchantabilityXp);
    }

    public static ItemStack getAppropriateResultTarget(ItemStack receiver) {
        if (!receiver.func_190926_b()) {
            if (receiver.func_77973_b().equals(Items.field_151122_aG)) {
                return new ItemStack(Items.field_151134_bR);
            }
            if (receiver.func_77973_b().equals((Object)CommonProxy.itemExperienceJar) && (ItemExperienceJar.hasAvailableExperienceCapacity(receiver) || ItemExperienceJar.isOverloadActive(receiver))) {
                return receiver.func_77946_l();
            }
        }
        return ItemStack.field_190927_a;
    }

    public static boolean isEnchantmentStorage(ItemStack itemstack) {
        return itemstack.func_77978_p().func_74781_a("StoredEnchantments") != null;
    }

    public static boolean isItemStackBroken(ItemStack itemstack) {
        return itemstack.func_77984_f() && itemstack.func_77952_i() > itemstack.func_77958_k();
    }

    public static float getEnchantingPower(World w, BlockPos pos) {
        int power = 1;
        for (int blockZ = -1; blockZ <= 1; ++blockZ) {
            for (int blockX = -1; blockX <= 1; ++blockX) {
                if (blockZ == 0 && blockX == 0 || !w.func_175623_d(pos.func_177982_a(blockX, 0, blockZ)) || !w.func_175623_d(pos.func_177982_a(blockX, 1, blockZ))) continue;
                power = (int)((float)power + ForgeHooks.getEnchantPower((World)w, (BlockPos)pos.func_177982_a(blockX * 2, 0, blockZ * 2)));
                power = (int)((float)power + ForgeHooks.getEnchantPower((World)w, (BlockPos)pos.func_177982_a(blockX * 2, 1, blockZ * 2)));
                if (blockX == 0 || blockZ == 0) continue;
                power = (int)((float)power + ForgeHooks.getEnchantPower((World)w, (BlockPos)pos.func_177982_a(blockX * 2, 0, blockZ)));
                power = (int)((float)power + ForgeHooks.getEnchantPower((World)w, (BlockPos)pos.func_177982_a(blockX * 2, 1, blockZ)));
                power = (int)((float)power + ForgeHooks.getEnchantPower((World)w, (BlockPos)pos.func_177982_a(blockX, 0, blockZ * 2)));
                power = (int)((float)power + ForgeHooks.getEnchantPower((World)w, (BlockPos)pos.func_177982_a(blockX, 1, blockZ * 2)));
            }
            if (power < 15) continue;
            power = 15;
            break;
        }
        return power;
    }
}

