/*
 * Decompiled with CFR 0.152.
 */
package de.impelon.disenchanter.block;

import de.impelon.disenchanter.DisenchanterMain;
import de.impelon.disenchanter.inventory.InventoryUtils;
import de.impelon.disenchanter.tileentity.TileEntityDisenchantmentTable;
import de.impelon.disenchanter.tileentity.TileEntityDisenchantmentTableAutomatic;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockDisenchantmentTable
extends BlockContainer {
    protected static final AxisAlignedBB AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.75, 1.0);
    public static final PropertyBool AUTOMATIC = PropertyBool.func_177716_a((String)"automatic");
    public static final PropertyBool BULKDISENCHANTING = PropertyBool.func_177716_a((String)"bulkdisenchanting");
    public static final PropertyBool CYCLING = PropertyBool.func_177716_a((String)"cycling");
    public static final PropertyBool VOIDING = PropertyBool.func_177716_a((String)"voiding");
    protected static final String SHOULD_DROP_KEY = "ShouldDropOnHarvest";

    public BlockDisenchantmentTable() {
        super(Material.field_151576_e, MapColor.field_151673_t);
        this.func_149647_a(CreativeTabs.field_78031_c);
        this.setRegistryName("disenchanter", "disenchantmentTable");
        this.func_149663_c(this.getRegistryName().toString().toLowerCase());
        this.func_149713_g(0);
        this.func_149711_c(5.0f);
        this.func_149752_b(2000.0f);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)AUTOMATIC, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)BULKDISENCHANTING, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)VOIDING, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)CYCLING, (Comparable)Boolean.valueOf(false)));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState state, World w, BlockPos pos, Random random) {
        super.func_180655_c(state, w, pos, random);
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        for (int blockX = x - 2; blockX <= x + 2; ++blockX) {
            block1: for (int blockZ = z - 2; blockZ <= z + 2; ++blockZ) {
                if (blockX >= x - 1 && blockX <= x + 1 && blockZ == z - 1) {
                    blockZ = z + 2;
                }
                if (random.nextInt(16) != 0) continue;
                for (int blockY = y; blockY <= y + 1; ++blockY) {
                    BlockPos blockPos = new BlockPos(blockX, blockY, blockZ);
                    if (!(ForgeHooks.getEnchantPower((World)w, (BlockPos)blockPos) > 0.0f)) continue;
                    if (!w.func_175623_d(new BlockPos((blockX - x) / 2 + x, blockY, (blockZ - z) / 2 + z))) continue block1;
                    w.func_175688_a(EnumParticleTypes.ENCHANTMENT_TABLE, (double)blockX + 0.25, (double)blockY + 0.55, (double)blockZ + 0.25, (double)(x - blockX) + 0.5, (double)((float)(y - blockY) + random.nextFloat() / 2.0f) + 0.15, (double)(z - blockZ) + 0.5, new int[0]);
                }
            }
        }
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return AABB;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{AUTOMATIC, BULKDISENCHANTING, VOIDING, CYCLING});
    }

    public IBlockState func_176203_a(int metadata) {
        IBlockState state = this.func_176223_P();
        if (metadata < 8) {
            state = state.func_177226_a((IProperty)AUTOMATIC, (Comparable)Boolean.valueOf(metadata % 2 == 1));
            state = state.func_177226_a((IProperty)BULKDISENCHANTING, (Comparable)Boolean.valueOf(metadata / 2 % 2 == 1));
            state = state.func_177226_a((IProperty)VOIDING, (Comparable)Boolean.valueOf(metadata / 4 % 2 == 1));
        } else {
            state = state.func_177226_a((IProperty)CYCLING, (Comparable)Boolean.valueOf(true));
            state = state.func_177226_a((IProperty)VOIDING, (Comparable)Boolean.valueOf(metadata % 2 == 1));
        }
        return state;
    }

    public int func_176201_c(IBlockState state) {
        int metadata = 0;
        if (!((Boolean)state.func_177229_b((IProperty)CYCLING)).booleanValue()) {
            metadata += (Boolean)state.func_177229_b((IProperty)AUTOMATIC) != false ? 1 : 0;
            metadata += (Boolean)state.func_177229_b((IProperty)BULKDISENCHANTING) != false ? 2 : 0;
            metadata += (Boolean)state.func_177229_b((IProperty)VOIDING) != false ? 4 : 0;
        } else {
            metadata += 8;
            metadata += (Boolean)state.func_177229_b((IProperty)VOIDING) != false ? 1 : 0;
        }
        return metadata;
    }

    public int func_180651_a(IBlockState state) {
        return this.func_176201_c(state);
    }

    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> subItems) {
        for (int meta = 0; meta < 10; meta = (int)((byte)(meta + 1))) {
            subItems.add((Object)new ItemStack((Block)this, 1, meta));
        }
    }

    public boolean func_149740_M(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)AUTOMATIC);
    }

    public int func_180641_l(IBlockState state, World w, BlockPos pos) {
        TileEntity te = w.func_175625_s(pos);
        if (te instanceof TileEntityDisenchantmentTableAutomatic) {
            return InventoryUtils.calcRedstoneFromInventory(te);
        }
        return 0;
    }

    public boolean func_180639_a(World w, BlockPos pos, IBlockState state, EntityPlayer p, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (!w.field_72995_K) {
            p.openGui((Object)DisenchanterMain.instance, 0, w, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        }
        return true;
    }

    public void func_180633_a(World w, BlockPos pos, IBlockState state, EntityLivingBase entity, ItemStack stack) {
        TileEntity te;
        super.func_180633_a(w, pos, state, entity, stack);
        if (stack.func_82837_s() && (te = w.func_175625_s(pos)) instanceof TileEntityDisenchantmentTable) {
            ((TileEntityDisenchantmentTable)te).func_145920_a(stack.func_82833_r());
        }
    }

    public void func_176208_a(World w, BlockPos pos, IBlockState state, EntityPlayer player) {
        TileEntity te = w.func_175625_s(pos);
        if (te instanceof TileEntityDisenchantmentTable) {
            te.getTileData().func_74757_a(SHOULD_DROP_KEY, !player.func_184812_l_() && this.canHarvestBlock((IBlockAccess)w, pos, player));
        }
        super.func_176208_a(w, pos, state, player);
    }

    public void func_180663_b(World w, BlockPos pos, IBlockState state) {
        TileEntity te = w.func_175625_s(pos);
        if (te instanceof TileEntityDisenchantmentTableAutomatic) {
            InventoryUtils.dropInventory(w, pos, te);
        }
        if (te instanceof TileEntityDisenchantmentTable) {
            TileEntityDisenchantmentTable table = (TileEntityDisenchantmentTable)te;
            if (!table.getTileData().func_74764_b(SHOULD_DROP_KEY) || table.getTileData().func_74767_n(SHOULD_DROP_KEY)) {
                ItemStack stack = new ItemStack(Item.func_150898_a((Block)this), 1, this.func_180651_a(state));
                if (table.func_145818_k_()) {
                    stack.func_151001_c(table.func_70005_c_());
                    table.func_145920_a("");
                }
                BlockDisenchantmentTable.func_180635_a((World)w, (BlockPos)pos, (ItemStack)stack);
            }
            w.func_175666_e(pos, state.func_177230_c());
        }
        super.func_180663_b(w, pos, state);
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return ItemStack.field_190927_a.func_77973_b();
    }

    protected ItemStack func_180643_i(IBlockState state) {
        return ItemStack.field_190927_a;
    }

    public TileEntity func_149915_a(World w, int metadata) {
        if (((Boolean)this.func_176203_a(metadata).func_177229_b((IProperty)AUTOMATIC)).booleanValue()) {
            return new TileEntityDisenchantmentTableAutomatic();
        }
        return new TileEntityDisenchantmentTable();
    }
}

