/*
 * Decompiled with CFR 0.152.
 */
package de.impelon.disenchanter.blocks;

import de.impelon.disenchanter.DisenchanterMain;
import de.impelon.disenchanter.blocks.TileEntityDisenchantmentTable;
import de.impelon.disenchanter.blocks.TileEntityDisenchantmentTableAutomatic;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockState;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockDisenchantmentTable
extends BlockContainer {
    public static final PropertyBool AUTOMATIC = PropertyBool.func_177716_a((String)"automatic");
    public static final PropertyBool BULKDISENCHANTING = PropertyBool.func_177716_a((String)"bulkdisenchanting");
    public static final PropertyBool VOIDING = PropertyBool.func_177716_a((String)"voiding");

    public BlockDisenchantmentTable() {
        super(Material.field_151576_e);
        this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 0.75f, 1.0f);
        this.func_149713_g(0);
        this.func_149647_a(CreativeTabs.field_78031_c);
        this.setRegistryName("disenchanter", "disenchantmentTable");
        this.func_149663_c(this.getRegistryName().toLowerCase());
        this.func_149711_c(5.0f);
        this.func_149752_b(2000.0f);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)AUTOMATIC, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)BULKDISENCHANTING, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)VOIDING, (Comparable)Boolean.valueOf(false)));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(World w, BlockPos pos, IBlockState state, Random random) {
        super.func_180655_c(w, pos, state, random);
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        for (int blockX = x - 2; blockX <= x + 2; ++blockX) {
            block1: for (int blockZ = z - 2; blockZ <= z + 2; ++blockZ) {
                if (blockX > x - 2 && blockX < x + 2 && blockZ == z - 1) {
                    blockZ = z + 2;
                }
                if (random.nextInt(16) != 0) continue;
                for (int blockY = y; blockY <= y + 1; ++blockY) {
                    if (!w.func_180495_p(new BlockPos(blockX, blockY, blockZ)).func_177230_c().equals(Blocks.field_150342_X)) continue;
                    if (!w.func_175623_d(new BlockPos((blockX - x) / 2 + x, blockY, (blockZ - z) / 2 + z))) continue block1;
                    w.func_175688_a(EnumParticleTypes.ENCHANTMENT_TABLE, (double)blockX + 0.25, (double)blockY + 0.55, (double)blockZ + 0.25, (double)(x - blockX) + 0.5, (double)(y - blockY) + (double)(random.nextFloat() / 2.0f) + 0.15, (double)(z - blockZ) + 0.5, new int[0]);
                }
            }
        }
    }

    public boolean func_149686_d() {
        return false;
    }

    public boolean func_149662_c() {
        return false;
    }

    public int func_149645_b() {
        return 3;
    }

    protected BlockState func_180661_e() {
        return new BlockState((Block)this, new IProperty[]{AUTOMATIC, BULKDISENCHANTING, VOIDING});
    }

    public IBlockState func_176203_a(int metadata) {
        IBlockState state = this.func_176223_P();
        state = state.func_177226_a((IProperty)AUTOMATIC, (Comparable)Boolean.valueOf(metadata % 2 == 1));
        state = state.func_177226_a((IProperty)BULKDISENCHANTING, (Comparable)Boolean.valueOf(metadata / 2 % 2 == 1));
        state = state.func_177226_a((IProperty)VOIDING, (Comparable)Boolean.valueOf(metadata / 4 % 2 == 1));
        return state;
    }

    public int func_176201_c(IBlockState state) {
        int metadata = 0;
        metadata += (Boolean)state.func_177229_b((IProperty)AUTOMATIC) != false ? 1 : 0;
        metadata += (Boolean)state.func_177229_b((IProperty)BULKDISENCHANTING) != false ? 2 : 0;
        return metadata += (Boolean)state.func_177229_b((IProperty)VOIDING) != false ? 4 : 0;
    }

    public int func_180651_a(IBlockState state) {
        return this.func_176201_c(state);
    }

    public void func_149666_a(Item itemIn, CreativeTabs tab, List<ItemStack> subItems) {
        for (int meta = 0; meta < 8; meta = (int)((byte)(meta + 1))) {
            subItems.add(new ItemStack(itemIn, 1, meta));
        }
    }

    public boolean func_149740_M() {
        return true;
    }

    public int func_180641_l(World w, BlockPos pos) {
        TileEntity te = w.func_175625_s(pos);
        if (te instanceof TileEntityDisenchantmentTableAutomatic) {
            return Container.func_178144_a((TileEntity)te);
        }
        return 0;
    }

    public boolean func_180639_a(World w, BlockPos pos, IBlockState state, EntityPlayer p, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (!w.field_72995_K) {
            p.openGui((Object)DisenchanterMain.instance, 0, w, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        }
        return true;
    }

    public void func_180633_a(World w, BlockPos pos, IBlockState state, EntityLivingBase entity, ItemStack stack) {
        super.func_180633_a(w, pos, state, entity, stack);
        if (stack.func_82837_s()) {
            ((TileEntityDisenchantmentTable)w.func_175625_s(pos)).setCustomName(stack.func_82833_r());
        }
    }

    public void func_180663_b(World w, BlockPos pos, IBlockState state) {
        TileEntity te = w.func_175625_s(pos);
        if (te instanceof TileEntityDisenchantmentTableAutomatic) {
            InventoryHelper.func_180175_a((World)w, (BlockPos)pos, (IInventory)((IInventory)te));
        }
        super.func_180663_b(w, pos, state);
    }

    public TileEntity func_149915_a(World w, int metadata) {
        if (((Boolean)this.func_176203_a(metadata).func_177229_b((IProperty)AUTOMATIC)).booleanValue()) {
            return new TileEntityDisenchantmentTableAutomatic();
        }
        return new TileEntityDisenchantmentTable();
    }

    public float getEnchantingPower(World w, BlockPos pos) {
        int power = 1;
        for (int blockZ = -1; blockZ <= 1; ++blockZ) {
            for (int blockX = -1; blockX <= 1; ++blockX) {
                if (blockZ == 0 && blockX == 0 || !w.func_175623_d(new BlockPos(pos.func_177958_n() + blockX, pos.func_177956_o(), pos.func_177952_p() + blockZ)) || !w.func_175623_d(new BlockPos(pos.func_177958_n() + blockX, pos.func_177956_o() + 1, pos.func_177952_p() + blockZ))) continue;
                power = (int)((float)power + ForgeHooks.getEnchantPower((World)w, (BlockPos)new BlockPos(pos.func_177958_n() + blockX * 2, pos.func_177956_o(), pos.func_177952_p() + blockZ * 2)));
                power = (int)((float)power + ForgeHooks.getEnchantPower((World)w, (BlockPos)new BlockPos(pos.func_177958_n() + blockX * 2, pos.func_177956_o() + 1, pos.func_177952_p() + blockZ * 2)));
                if (blockX == 0 || blockZ == 0) continue;
                power = (int)((float)power + ForgeHooks.getEnchantPower((World)w, (BlockPos)new BlockPos(pos.func_177958_n() + blockX * 2, pos.func_177956_o(), pos.func_177952_p() + blockZ)));
                power = (int)((float)power + ForgeHooks.getEnchantPower((World)w, (BlockPos)new BlockPos(pos.func_177958_n() + blockX * 2, pos.func_177956_o() + 1, pos.func_177952_p() + blockZ)));
                power = (int)((float)power + ForgeHooks.getEnchantPower((World)w, (BlockPos)new BlockPos(pos.func_177958_n() + blockX, pos.func_177956_o(), pos.func_177952_p() + blockZ * 2)));
                power = (int)((float)power + ForgeHooks.getEnchantPower((World)w, (BlockPos)new BlockPos(pos.func_177958_n() + blockX, pos.func_177956_o() + 1, pos.func_177952_p() + blockZ * 2)));
            }
        }
        if (power > 15) {
            power = 15;
        }
        return power;
    }

    public void transferEnchantment(ItemStack input, ItemStack output, int index, Random random) {
        if (input != null && output != null && input.func_77978_p() != null) {
            double enchantmentLoss = DisenchanterMain.config.get("disenchanting", "EnchantmentLossChance", 0.0).getDouble();
            NBTTagList enchants = this.getEnchantmentList(input);
            if (enchants == null) {
                return;
            }
            if (enchants.func_74745_c() > 0) {
                index = Math.min(Math.abs(index), enchants.func_74745_c() - 1);
                NBTTagCompound enchant = enchants.func_150305_b(index);
                int id = enchant.func_74762_e("id");
                int lvl = enchant.func_74762_e("lvl");
                if ((double)random.nextFloat() > enchantmentLoss) {
                    Items.field_151134_bR.func_92115_a(output, new EnchantmentData(Enchantment.func_180306_c((int)id), lvl));
                }
                enchants.func_74744_a(index);
            }
            if (enchants.func_74745_c() <= 0) {
                if (this.isEnchantmentStorage(input)) {
                    input.func_77978_p().func_82580_o("StoredEnchantments");
                } else {
                    input.func_77978_p().func_82580_o("ench");
                }
            }
        }
    }

    public NBTTagList getEnchantmentList(ItemStack itemstack) {
        if (itemstack.func_77978_p() == null) {
            return null;
        }
        if (itemstack.func_77978_p().func_74781_a("ench") != null) {
            return (NBTTagList)itemstack.func_77978_p().func_74781_a("ench");
        }
        if (itemstack.func_77978_p().func_74781_a("StoredEnchantments") != null) {
            return (NBTTagList)itemstack.func_77978_p().func_74781_a("StoredEnchantments");
        }
        return null;
    }

    public boolean isEnchantmentStorage(ItemStack itemstack) {
        return itemstack.func_77978_p().func_74781_a("StoredEnchantments") != null;
    }
}

