/*
 * Decompiled with CFR 0.152.
 */
package de.impelon.disenchanter.blocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import de.impelon.disenchanter.DisenchanterMain;
import de.impelon.disenchanter.blocks.TileEntityDisenchantmentTable;
import de.impelon.disenchanter.blocks.TileEntityDisenchantmentTableAutomatic;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;

public class BlockDisenchantmentTable
extends BlockContainer {
    @SideOnly(value=Side.CLIENT)
    private IIcon[] top = new IIcon[2];
    @SideOnly(value=Side.CLIENT)
    private IIcon[] bottom = new IIcon[2];
    @SideOnly(value=Side.CLIENT)
    private IIcon[] side = new IIcon[2];

    public BlockDisenchantmentTable() {
        super(Material.field_151576_e);
        this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 0.75f, 1.0f);
        this.func_149713_g(0);
        this.func_149647_a(CreativeTabs.field_78031_c);
        this.func_149663_c("blockDisenchantmentTable");
        this.func_149711_c(5.0f);
        this.func_149752_b(2000.0f);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149734_b(World w, int x, int y, int z, Random random) {
        super.func_149734_b(w, x, y, z, random);
        for (int blockX = x - 2; blockX <= x + 2; ++blockX) {
            block1: for (int blockZ = z - 2; blockZ <= z + 2; ++blockZ) {
                if (blockX > x - 2 && blockX < x + 2 && blockZ == z - 1) {
                    blockZ = z + 2;
                }
                if (random.nextInt(16) != 0) continue;
                for (int blockY = y; blockY <= y + 1; ++blockY) {
                    if (!(ForgeHooks.getEnchantPower((World)w, (int)blockX, (int)blockY, (int)blockZ) > 0.0f)) continue;
                    if (!w.func_147437_c((blockX - x) / 2 + x, blockY, (blockZ - z) / 2 + z)) continue block1;
                    w.func_72869_a("enchantmenttable", (double)blockX + 0.25, (double)blockY + 0.55, (double)blockZ + 0.25, (double)(x - blockX) + 0.5, (double)(y - blockY) + (double)(random.nextFloat() / 2.0f) + 0.15, (double)(z - blockZ) + 0.5);
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void getSubBlocks(int unknown, CreativeTabs tab, List subItems) {
        for (int n = 0; n < 8; n = (int)((byte)(n + 1))) {
            subItems.add(new ItemStack((Block)this, 1, n));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        return side == 0 ? this.bottom[meta / 4 % 2] : (side == 1 ? this.top[meta / 2 % 2] : this.side[meta % 2]);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister i) {
        this.side[0] = i.func_94245_a("Disenchanter:disenchantmenttable_side");
        this.side[1] = i.func_94245_a("Disenchanter:disenchantmenttable_side_automatic");
        this.top[0] = i.func_94245_a("Disenchanter:disenchantmenttable_top");
        this.top[1] = i.func_94245_a("Disenchanter:disenchantmenttable_top_bulk");
        this.bottom[0] = i.func_94245_a("Disenchanter:disenchantmenttable_bottom");
        this.bottom[1] = i.func_94245_a("Disenchanter:disenchantmenttable_bottom_voiding");
        this.field_149761_L = this.side[0];
    }

    public boolean func_149686_d() {
        return false;
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean isAutomatic(int meta) {
        return meta % 2 == 1;
    }

    public boolean isBulkDisenchanting(int meta) {
        return meta / 2 % 2 == 1;
    }

    public boolean isVoiding(int meta) {
        return meta / 4 % 2 == 1;
    }

    public int func_149692_a(int metadata) {
        return metadata;
    }

    public boolean func_149740_M() {
        return true;
    }

    public int func_149736_g(World w, int x, int y, int z, int side) {
        TileEntity te = w.func_147438_o(x, y, z);
        if (te instanceof TileEntityDisenchantmentTableAutomatic) {
            return Container.func_94526_b((IInventory)((IInventory)te));
        }
        return 0;
    }

    public boolean func_149727_a(World w, int x, int y, int z, EntityPlayer p, int metadata, float sideX, float sideY, float sideZ) {
        if (!w.field_72995_K) {
            p.openGui((Object)DisenchanterMain.instance, 0, w, x, y, z);
        }
        return true;
    }

    public void func_149689_a(World w, int x, int y, int z, EntityLivingBase entity, ItemStack stack) {
        super.func_149689_a(w, x, y, z, entity, stack);
        if (stack.func_82837_s()) {
            ((TileEntityDisenchantmentTable)w.func_147438_o(x, y, z)).setCustomName(stack.func_82833_r());
        }
    }

    public void func_149749_a(World w, int x, int y, int z, Block b, int meta) {
        TileEntity te = w.func_147438_o(x, y, z);
        if (te instanceof TileEntityDisenchantmentTableAutomatic) {
            TileEntityDisenchantmentTableAutomatic ta = (TileEntityDisenchantmentTableAutomatic)te;
            for (int i = 0; i < ta.func_70302_i_(); ++i) {
                ItemStack itemstack = ta.func_70301_a(i);
                if (itemstack == null) continue;
                float offsetX = (float)(Math.random() * (double)0.8f + (double)0.1f);
                float offsetY = (float)(Math.random() * (double)0.8f + (double)0.1f);
                float offsetZ = (float)(Math.random() * (double)0.8f + (double)0.1f);
                while (itemstack.field_77994_a > 0) {
                    int size = (int)(Math.random() * 21.0 + 10.0);
                    if (size > itemstack.field_77994_a) {
                        size = itemstack.field_77994_a;
                    }
                    itemstack.field_77994_a -= size;
                    EntityItem entityitem = new EntityItem(w, (double)((float)x + offsetX), (double)((float)y + offsetY), (double)((float)z + offsetZ), new ItemStack(itemstack.func_77973_b(), size, itemstack.func_77960_j()));
                    entityitem.field_70159_w = Math.random() * (double)0.05f;
                    entityitem.field_70181_x = Math.random() * (double)0.05f + (double)0.2f;
                    entityitem.field_70179_y = Math.random() * (double)0.05f;
                    if (itemstack.func_77942_o()) {
                        entityitem.func_92059_d().func_77982_d((NBTTagCompound)itemstack.func_77978_p().func_74737_b());
                    }
                    w.func_72838_d((Entity)entityitem);
                }
            }
        }
        super.func_149749_a(w, x, y, z, b, meta);
    }

    public TileEntity func_149915_a(World w, int metadata) {
        if (this.isAutomatic(metadata)) {
            return new TileEntityDisenchantmentTableAutomatic();
        }
        return new TileEntityDisenchantmentTable();
    }

    public float getEnchantingPower(World w, int x, int y, int z) {
        float power = 1.0f;
        for (int blockZ = -1; blockZ <= 1; ++blockZ) {
            for (int blockX = -1; blockX <= 1; ++blockX) {
                if (blockZ == 0 && blockX == 0 || !w.func_147437_c(x + blockX, y, z + blockZ) || !w.func_147437_c(x + blockX, y + 1, z + blockZ)) continue;
                power += ForgeHooks.getEnchantPower((World)w, (int)(x + blockX * 2), (int)y, (int)(z + blockZ * 2));
                power += ForgeHooks.getEnchantPower((World)w, (int)(x + blockX * 2), (int)(y + 1), (int)(z + blockZ * 2));
                if (blockX == 0 || blockZ == 0) continue;
                power += ForgeHooks.getEnchantPower((World)w, (int)(x + blockX * 2), (int)y, (int)(z + blockZ));
                power += ForgeHooks.getEnchantPower((World)w, (int)(x + blockX * 2), (int)(y + 1), (int)(z + blockZ));
                power += ForgeHooks.getEnchantPower((World)w, (int)(x + blockX), (int)y, (int)(z + blockZ * 2));
                power += ForgeHooks.getEnchantPower((World)w, (int)(x + blockX), (int)(y + 1), (int)(z + blockZ * 2));
            }
        }
        if (power > 15.0f) {
            power = 15.0f;
        }
        return power;
    }

    public void transferEnchantment(ItemStack input, ItemStack output, int index, Random random) {
        if (input != null && output != null && input.field_77990_d != null) {
            double enchantmentLoss = DisenchanterMain.config.get("disenchanting", "EnchantmentLossChance", 0.0).getDouble();
            NBTTagList enchants = this.getEnchantmentList(input);
            if (enchants == null) {
                return;
            }
            if (enchants.func_74745_c() > 0) {
                index = Math.min(Math.abs(index), enchants.func_74745_c() - 1);
                NBTTagCompound enchant = enchants.func_150305_b(index);
                int id = enchant.func_74762_e("id");
                int lvl = enchant.func_74762_e("lvl");
                if ((double)random.nextFloat() > enchantmentLoss) {
                    Items.field_151134_bR.func_92115_a(output, new EnchantmentData(id, lvl));
                }
                enchants.func_74744_a(index);
            }
            if (enchants.func_74745_c() <= 0) {
                if (this.isEnchantmentStorage(input)) {
                    input.field_77990_d.func_82580_o("StoredEnchantments");
                } else {
                    input.field_77990_d.func_82580_o("ench");
                }
            }
        }
    }

    public NBTTagList getEnchantmentList(ItemStack itemstack) {
        if (itemstack.field_77990_d == null) {
            return null;
        }
        if (itemstack.field_77990_d.func_74781_a("ench") != null) {
            return (NBTTagList)itemstack.field_77990_d.func_74781_a("ench");
        }
        if (itemstack.field_77990_d.func_74781_a("StoredEnchantments") != null) {
            return (NBTTagList)itemstack.field_77990_d.func_74781_a("StoredEnchantments");
        }
        return null;
    }

    public boolean isEnchantmentStorage(ItemStack itemstack) {
        return itemstack.field_77990_d.func_74781_a("StoredEnchantments") != null;
    }
}

