/*
 * Decompiled with CFR 0.152.
 */
package de.impelon.disenchanter.proxies;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import de.impelon.disenchanter.DisenchanterMain;
import de.impelon.disenchanter.blocks.BlockDisenchantmentTable;
import de.impelon.disenchanter.blocks.ItemBlockDisenchantment;
import de.impelon.disenchanter.blocks.TileEntityDisenchantmentTable;
import de.impelon.disenchanter.blocks.TileEntityDisenchantmentTableAutomatic;
import de.impelon.disenchanter.blocks.UpgradeTableRecipe;
import de.impelon.disenchanter.gui.GUIHandler;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.oredict.ShapedOreRecipe;

public class CommonProxy {
    public static final BlockDisenchantmentTable disenchantmentTable = new BlockDisenchantmentTable();

    public void preInit(FMLPreInitializationEvent ev) {
        Configuration config;
        DisenchanterMain.config = config = new Configuration(ev.getSuggestedConfigurationFile());
        config.load();
        config.get("general", "CheckVersion", true, "Should Disenchanter check for new versions on startup?");
        config.get("general", "EnableAutomaticRecipe", true, "Should the recipe for the automatic-upgrade be avalible?");
        config.get("general", "EnableVoidingRecipe", true, "Should the recipe for the voiding-upgrade be avalible?");
        config.get("general", "EnableBulkDisenchantingRecipe", true, "Should the recipe for the bulk-disenchanting-upgrade be avalible?");
        config.get("general", "EnableClearRecipe", true, "Should the recipe for clearing all upgrades be avalible?");
        config.get("disenchanting", "FlatDamage", 10, "How much flat damage should be dealt to Items when disenchanting?");
        config.get("disenchanting", "MaxDurabilityDamage", 0.025, "How much of the Item's maximal durability should be dealt as damage to Items when disenchanting?");
        config.get("disenchanting", "MaxDurabilityDamageReduceable", 0.2, "How much of the Item's maximal durability should be dealt as reduceable damage to Items when disenchanting?");
        config.get("disenchanting", "MachineDamageMultiplier", 2.5, "By how much should the dammage on the item be multiplied when using an automaic Disenchantment Table?");
        config.get("disenchanting", "EnchantmentLossChance", 0.0, "What should the probability be of additional enchantments being lost from Items when disenchanting?");
        config.get("disenchanting", "EnableTCBehaviour", true, "Should Items from Tinkers Construct be handeled differently? (banned / modifiers removed [in TC2])");
        config.get("disenchanting", "AutomaticDisenchantmentProcessTicks", 100, "How many ticks should a disenchantment process last when using an automaic Disenchantment Table?");
        config.save();
        GameRegistry.registerTileEntity(TileEntityDisenchantmentTable.class, (String)"TileDisentchantmentTable");
        GameRegistry.registerTileEntity(TileEntityDisenchantmentTableAutomatic.class, (String)"TileDisentchantmentTableAutomatic");
        GameRegistry.registerBlock((Block)disenchantmentTable, ItemBlockDisenchantment.class, (String)"BlockDisenchantmentTable");
    }

    public void load(FMLInitializationEvent ev) {
        if (DisenchanterMain.config.get("general", "CheckVersion", true).getBoolean()) {
            FMLCommonHandler.instance().bus().register((Object)DisenchanterMain.versionChecker);
        }
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)DisenchanterMain.instance, (IGuiHandler)new GUIHandler());
        ItemStack table = new ItemStack(Item.func_150898_a((Block)disenchantmentTable), 1, Short.MAX_VALUE);
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(Item.func_150898_a((Block)disenchantmentTable), 1, 0), new Object[]{"   ", "YEY", "ETE", Character.valueOf('T'), Blocks.field_150381_bn, Character.valueOf('E'), "gemEmerald", Character.valueOf('Y'), "dyeYellow"}));
        if (DisenchanterMain.config.get("general", "EnableAutomaticRecipe", true).getBoolean()) {
            GameRegistry.addRecipe((IRecipe)new UpgradeTableRecipe(1, new ItemStack(Item.func_150898_a((Block)disenchantmentTable), 1, 1), "IMI", "BCB", "ITI", Character.valueOf('T'), table, Character.valueOf('I'), "ingotIron", Character.valueOf('C'), Blocks.field_150486_ae, Character.valueOf('B'), "dyeBlack", Character.valueOf('M'), Items.field_151132_bS));
        }
        if (DisenchanterMain.config.get("general", "EnableBulkDisenchantingRecipe", true).getBoolean()) {
            GameRegistry.addRecipe((IRecipe)new UpgradeTableRecipe(2, new ItemStack(Item.func_150898_a((Block)disenchantmentTable), 1, 2), "QGQ", "GDG", "QTQ", Character.valueOf('T'), table, Character.valueOf('D'), "gemDiamond", Character.valueOf('Q'), "gemQuartz", Character.valueOf('G'), "ingotGold"));
        }
        if (DisenchanterMain.config.get("general", "EnableVoidingRecipe", true).getBoolean()) {
            GameRegistry.addRecipe((IRecipe)new UpgradeTableRecipe(4, new ItemStack(Item.func_150898_a((Block)disenchantmentTable), 1, 4), "POP", "EHE", "PTP", Character.valueOf('T'), table, Character.valueOf('E'), Items.field_151079_bi, Character.valueOf('H'), Blocks.field_150438_bZ, Character.valueOf('P'), "dyePurple", Character.valueOf('O'), Blocks.field_150343_Z));
        }
        if (DisenchanterMain.config.get("general", "EnableClearRecipe", true).getBoolean()) {
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(Item.func_150898_a((Block)disenchantmentTable), 1, 0), new Object[]{"PPP", "PTP", "PPP", Character.valueOf('T'), table, Character.valueOf('P'), Items.field_151121_aF}));
        }
    }

    public void postInit(FMLPostInitializationEvent ev) {
    }
}

