/*
 * Decompiled with CFR 0.152.
 */
package tech.alexnijjar.endermanoverhaul.common.entities.base;

import java.util.EnumSet;
import java.util.function.Predicate;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1361;
import net.minecraft.class_1366;
import net.minecraft.class_1376;
import net.minecraft.class_1394;
import net.minecraft.class_1399;
import net.minecraft.class_1400;
import net.minecraft.class_1559;
import net.minecraft.class_1560;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1928;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3481;
import net.minecraft.class_3486;
import net.minecraft.class_3532;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_4051;
import net.minecraft.class_4538;
import net.minecraft.class_5398;
import net.minecraft.class_5712;
import net.minecraft.class_5819;
import net.minecraft.class_6862;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;
import software.bernie.geckolib3.util.GeckoLibUtil;
import tech.alexnijjar.endermanoverhaul.common.constants.ConstantAnimations;
import tech.alexnijjar.endermanoverhaul.common.items.HoodItem;

public abstract class BaseEnderman
extends class_1560
implements IAnimatable {
    private final AnimationFactory factory = GeckoLibUtil.createFactory((IAnimatable)this);
    private int lastStareSound = Integer.MIN_VALUE;

    public BaseEnderman(class_1299<? extends class_1560> entityType, class_1937 level) {
        super(entityType, level);
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 5.0f, state -> {
            if (state.isMoving()) {
                state.getController().setAnimation(this.method_7028() && this.playRunAnimWhenAngry() ? ConstantAnimations.RUN : ConstantAnimations.WALK);
            } else {
                state.getController().setAnimation(ConstantAnimations.IDLE);
            }
            return PlayState.CONTINUE;
        }));
        data.addAnimationController(new AnimationController((IAnimatable)this, "creepy_controller", 5.0f, state -> {
            if (!this.canOpenMouth()) {
                return PlayState.STOP;
            }
            if (!this.method_7028()) {
                return PlayState.STOP;
            }
            state.getController().setAnimation(ConstantAnimations.ANGRY);
            return PlayState.CONTINUE;
        }));
        data.addAnimationController(new AnimationController((IAnimatable)this, "hold_controller", 5.0f, state -> {
            if (!this.canPickupBlocks()) {
                return PlayState.STOP;
            }
            if (this.method_7027() == null) {
                return PlayState.STOP;
            }
            state.getController().setAnimation(ConstantAnimations.HOLDING);
            return PlayState.CONTINUE;
        }));
        data.addAnimationController(new AnimationController((IAnimatable)this, "attack_controller", 5.0f, state -> {
            if (!this.playArmSwingAnimWhenAttacking()) {
                return PlayState.STOP;
            }
            if (this.method_6055(state.getPartialTick()) == 0.0f) {
                return PlayState.STOP;
            }
            state.getController().setAnimation(ConstantAnimations.ATTACK);
            return PlayState.CONTINUE;
        }));
    }

    public boolean canOpenMouth() {
        return true;
    }

    public boolean playRunAnimWhenAngry() {
        return true;
    }

    public boolean canShake() {
        return true;
    }

    public boolean playArmSwingAnimWhenAttacking() {
        return true;
    }

    public boolean isProvokedByEyeContact() {
        return true;
    }

    public boolean hasParticles() {
        return true;
    }

    @Nullable
    public class_2394 getCustomParticles() {
        return null;
    }

    public int getParticleCount() {
        return 2;
    }

    public int getParticleRate() {
        return 1;
    }

    public boolean canPickupBlocks() {
        return true;
    }

    public class_243 getHeldBlockOffset() {
        return class_243.field_1353;
    }

    public boolean isAlwaysHostile() {
        return false;
    }

    public boolean canTeleport() {
        return true;
    }

    public double getVisionRange() {
        return 256.0;
    }

    @Nullable
    public class_1293 getHitEffect() {
        return null;
    }

    public class_6862<class_2248> getCarriableBlockTag() {
        return class_3481.field_15460;
    }

    @Nullable
    public class_1293 getAreaEffect() {
        return null;
    }

    @Nullable
    public class_3414 getAreaEffectSound() {
        return null;
    }

    public int getAreaEffectRange() {
        return 0;
    }

    public boolean hasLargeCreepyHitbox() {
        return false;
    }

    public class_3414 getStareSound() {
        return class_3417.field_14967;
    }

    public boolean speedUpWhenAngry() {
        return true;
    }

    public boolean canFloat() {
        return true;
    }

    public void method_5773() {
        super.method_5773();
        this.tickAreaEffect();
    }

    protected void tickAreaEffect() {
        if (this.field_6002.method_8608()) {
            return;
        }
        if (this.field_6002.method_8510() % 20L != 0L) {
            return;
        }
        class_1293 areaEffect = this.getAreaEffect();
        if (areaEffect == null || this.getAreaEffectRange() == 0) {
            return;
        }
        class_1309 target = this.method_5968();
        if (target == null) {
            return;
        }
        if (this.method_5858((class_1297)target) <= (double)(this.getAreaEffectRange() * this.getAreaEffectRange())) {
            if (this.getAreaEffectSound() != null && !target.method_6059(areaEffect.method_5579())) {
                this.field_6002.method_8396(null, target.method_24515(), this.getAreaEffectSound(), class_3419.field_15251, 1.0f, 1.0f);
            }
            target.method_6092(areaEffect);
        }
    }

    public void method_7030() {
        if (this.field_6012 >= this.lastStareSound + 400) {
            this.lastStareSound = this.field_6012;
            if (!this.method_5701()) {
                this.field_6002.method_8486(this.method_23317(), this.method_23320(), this.method_23321(), this.getStareSound(), this.method_5634(), 2.5f, 1.0f, false);
            }
        }
    }

    public void method_6007() {
        class_2394 customParticleType = this.getCustomParticles();
        if (this.hasParticles() && this.field_6002.method_8608() && customParticleType != null && this.field_6002.method_8510() % (long)this.getParticleRate() == 0L) {
            for (int i = 0; i < this.getParticleCount(); ++i) {
                this.field_6002.method_8406(customParticleType, this.method_23322(0.5), this.method_23319() - 0.25, this.method_23325(0.5), (this.field_5974.method_43058() - 0.5) * 2.0, -this.field_5974.method_43058(), (this.field_5974.method_43058() - 0.5) * 2.0);
            }
        }
        super.method_6007();
    }

    public boolean method_6121(@NotNull class_1297 target) {
        if (super.method_6121(target)) {
            class_1293 effect = this.getHitEffect();
            if (effect != null && target instanceof class_1309) {
                class_1309 entity = (class_1309)target;
                entity.method_6092(effect);
            }
            return true;
        }
        return false;
    }

    @NotNull
    public class_4048 method_18377(@NotNull class_4050 pose) {
        if (!this.hasLargeCreepyHitbox() || !this.method_7028()) {
            return super.method_18377(pose);
        }
        return super.method_18377(pose).method_19539(1.0f, 1.15f);
    }

    protected void method_5959() {
        if (this.canFloat()) {
            this.field_6201.method_6277(0, (class_1352)new class_1347((class_1308)this));
        }
        this.field_6201.method_6277(1, (class_1352)new EndermanFreezeWhenLookedAt());
        if (this.isAlwaysHostile()) {
            this.field_6185.method_6277(2, (class_1352)new class_1400((class_1308)this, class_1657.class, true));
        }
        this.field_6201.method_6277(2, (class_1352)new class_1366((class_1314)this, 1.0, false));
        this.field_6201.method_6277(7, (class_1352)new class_1394((class_1314)this, 1.0, 0.0f));
        this.field_6201.method_6277(8, (class_1352)new class_1361((class_1308)this, class_1657.class, 8.0f));
        this.field_6201.method_6277(8, (class_1352)new class_1376((class_1308)this));
        this.field_6201.method_6277(10, (class_1352)new EndermanLeaveBlockGoal());
        this.field_6201.method_6277(11, (class_1352)new EndermanTakeBlockGoal());
        this.field_6185.method_6277(1, (class_1352)new EndermanLookForPlayerGoal(arg_0 -> ((BaseEnderman)this).method_29515(arg_0)));
        this.field_6185.method_6277(2, (class_1352)new class_1399((class_1314)this, new Class[0]));
        this.field_6185.method_6277(3, (class_1352)new class_1400((class_1308)this, class_1559.class, true, false));
        this.field_6185.method_6277(4, (class_1352)new class_5398((class_1308)this, false));
    }

    public boolean method_7026(class_1657 player) {
        if (!this.isProvokedByEyeContact()) {
            return false;
        }
        if (player.method_6118(class_1304.field_6174).method_7909() instanceof HoodItem) {
            return false;
        }
        class_1799 itemStack = (class_1799)player.method_31548().field_7548.get(3);
        if (itemStack.method_31574(class_2246.field_10147.method_8389())) {
            return false;
        }
        class_243 vec3 = player.method_5828(1.0f).method_1029();
        class_243 vec32 = new class_243(this.method_23317() - player.method_23317(), this.method_23320() - player.method_23320(), this.method_23321() - player.method_23321());
        double d = vec32.method_1033();
        double e = vec3.method_1026(vec32 = vec32.method_1029());
        return e > 1.0 - 0.025 / d && player.method_6057((class_1297)this);
    }

    protected float method_18394(@NotNull class_4050 pose, @NotNull class_4048 dimensions) {
        return 2.55f + (dimensions.field_18068 - 2.9f);
    }

    public void method_5980(@Nullable class_1309 target) {
        super.method_5980(target);
        this.method_18382();
    }

    protected boolean method_7029() {
        if (!this.canTeleport()) {
            return false;
        }
        return super.method_7029();
    }

    public boolean method_7025(class_1297 target) {
        if (!this.canTeleport()) {
            return false;
        }
        class_243 vec3 = new class_243(this.method_23317() - target.method_23317(), this.method_23323(0.5) - target.method_23320(), this.method_23321() - target.method_23321());
        vec3 = vec3.method_1029();
        double e = this.method_23317() + (this.field_5974.method_43058() - 0.5) * 8.0 - vec3.field_1352 * 16.0;
        double f = this.method_23318() + (double)(this.field_5974.method_43048(16) - 8) - vec3.field_1351 * 16.0;
        double g = this.method_23321() + (this.field_5974.method_43058() - 0.5) * 8.0 - vec3.field_1350 * 16.0;
        return this.teleport(e, f, g);
    }

    public boolean teleport(double x, double y, double z) {
        if (!this.canTeleport()) {
            return false;
        }
        class_2338.class_2339 mutableBlockPos = new class_2338.class_2339(x, y, z);
        while (mutableBlockPos.method_10264() > this.field_6002.method_31607() && !this.field_6002.method_8320((class_2338)mutableBlockPos).method_26207().method_15801()) {
            mutableBlockPos.method_10098(class_2350.field_11033);
        }
        class_2680 blockState = this.field_6002.method_8320((class_2338)mutableBlockPos);
        boolean bl = blockState.method_26207().method_15801();
        boolean bl2 = blockState.method_26227().method_15767(class_3486.field_15517);
        if (bl && !bl2) {
            class_243 vec3 = this.method_19538();
            boolean bl3 = this.method_6082(x, y, z, true);
            if (bl3) {
                this.field_6002.method_32888(class_5712.field_39446, vec3, class_5712.class_7397.method_43285((class_1297)this));
                if (!this.method_5701()) {
                    this.field_6002.method_43128(null, this.field_6014, this.field_6036, this.field_5969, class_3417.field_14879, this.method_5634(), 1.0f, 1.0f);
                    this.method_5783(class_3417.field_14879, 1.0f, 1.0f);
                }
            }
            return bl3;
        }
        return false;
    }

    public class EndermanFreezeWhenLookedAt
    extends class_1352 {
        @Nullable
        private class_1309 target;

        public EndermanFreezeWhenLookedAt() {
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18407, class_1352.class_4134.field_18405));
        }

        public boolean method_6264() {
            this.target = BaseEnderman.this.method_5968();
            if (!(this.target instanceof class_1657)) {
                return false;
            }
            double d = this.target.method_5858((class_1297)BaseEnderman.this);
            return !(d > BaseEnderman.this.getVisionRange()) && BaseEnderman.this.method_7026((class_1657)this.target);
        }

        public void method_6269() {
            BaseEnderman.this.method_5942().method_6340();
        }

        public void method_6268() {
            if (this.target == null) {
                return;
            }
            BaseEnderman.this.method_5988().method_20248(this.target.method_23317(), this.target.method_23320(), this.target.method_23321());
        }
    }

    public class EndermanLeaveBlockGoal
    extends class_1352 {
        public boolean method_6264() {
            if (BaseEnderman.this.method_7027() == null) {
                return false;
            }
            if (!BaseEnderman.this.field_6002.method_8450().method_8355(class_1928.field_19388)) {
                return false;
            }
            return BaseEnderman.this.method_6051().method_43048(EndermanLeaveBlockGoal.method_38848((int)2000)) == 0;
        }

        public void method_6268() {
            class_5819 randomSource = BaseEnderman.this.method_6051();
            class_1937 level = BaseEnderman.this.field_6002;
            int i = class_3532.method_15357((double)(BaseEnderman.this.method_23317() - 1.0 + randomSource.method_43058() * 2.0));
            int j = class_3532.method_15357((double)(BaseEnderman.this.method_23318() + randomSource.method_43058() * 2.0));
            int k = class_3532.method_15357((double)(BaseEnderman.this.method_23321() - 1.0 + randomSource.method_43058() * 2.0));
            class_2338 blockPos = new class_2338(i, j, k);
            class_2680 blockState = level.method_8320(blockPos);
            class_2338 blockPos2 = blockPos.method_10074();
            class_2680 blockState2 = level.method_8320(blockPos2);
            class_2680 blockState3 = BaseEnderman.this.method_7027();
            if (blockState3 != null && this.canPlaceBlock(level, blockPos, blockState3 = class_2248.method_9510((class_2680)blockState3, (class_1936)BaseEnderman.this.field_6002, (class_2338)blockPos), blockState, blockState2, blockPos2)) {
                level.method_8652(blockPos, blockState3, 3);
                level.method_43276(class_5712.field_28164, blockPos, class_5712.class_7397.method_43286((class_1297)BaseEnderman.this, (class_2680)blockState3));
                BaseEnderman.this.method_7032(null);
            }
        }

        private boolean canPlaceBlock(class_1937 level, class_2338 destinationPos, class_2680 carriedState, class_2680 destinationState, class_2680 belowDestinationState, class_2338 belowDestinationPos) {
            return destinationState.method_26215() && !belowDestinationState.method_26215() && !belowDestinationState.method_27852(class_2246.field_9987) && belowDestinationState.method_26234((class_1922)level, belowDestinationPos) && carriedState.method_26184((class_4538)level, destinationPos) && level.method_8335((class_1297)BaseEnderman.this, class_238.method_29968((class_243)class_243.method_24954((class_2382)destinationPos))).isEmpty();
        }
    }

    public class EndermanTakeBlockGoal
    extends class_1352 {
        public boolean method_6264() {
            if (!BaseEnderman.this.canPickupBlocks()) {
                return false;
            }
            if (BaseEnderman.this.method_7027() != null) {
                return false;
            }
            if (!BaseEnderman.this.field_6002.method_8450().method_8355(class_1928.field_19388)) {
                return false;
            }
            return BaseEnderman.this.method_6051().method_43048(EndermanTakeBlockGoal.method_38848((int)20)) == 0;
        }

        public void method_6268() {
            class_5819 randomSource = BaseEnderman.this.method_6051();
            class_1937 level = BaseEnderman.this.field_6002;
            int i = class_3532.method_15357((double)(BaseEnderman.this.method_23317() - 2.0 + randomSource.method_43058() * 4.0));
            int j = class_3532.method_15357((double)(BaseEnderman.this.method_23318() + randomSource.method_43058() * 3.0));
            int k = class_3532.method_15357((double)(BaseEnderman.this.method_23321() - 2.0 + randomSource.method_43058() * 4.0));
            class_2338 blockPos = new class_2338(i, j, k);
            class_2680 blockState = level.method_8320(blockPos);
            class_243 vec3 = new class_243((double)BaseEnderman.this.method_31477() + 0.5, (double)j + 0.5, (double)BaseEnderman.this.method_31479() + 0.5);
            class_243 vec32 = new class_243((double)i + 0.5, (double)j + 0.5, (double)k + 0.5);
            class_3965 blockHitResult = level.method_17742(new class_3959(vec3, vec32, class_3959.class_3960.field_17559, class_3959.class_242.field_1348, (class_1297)BaseEnderman.this));
            boolean bl = blockHitResult.method_17777().equals((Object)blockPos);
            if (blockState.method_26164(BaseEnderman.this.getCarriableBlockTag()) && bl) {
                level.method_8650(blockPos, false);
                level.method_43276(class_5712.field_28165, blockPos, class_5712.class_7397.method_43286((class_1297)BaseEnderman.this, (class_2680)blockState));
                BaseEnderman.this.method_7032(blockState.method_26204().method_9564());
            }
        }
    }

    public class EndermanLookForPlayerGoal
    extends class_1400<class_1657> {
        @Nullable
        private class_1657 pendingTarget;
        private int aggroTime;
        private int teleportTime;
        private final class_4051 startAggroTargetConditions;
        private final class_4051 continueAggroTargetConditions;
        private final Predicate<class_1309> isAngerInducing;

        public EndermanLookForPlayerGoal(Predicate<class_1309> predicate) {
            super((class_1308)BaseEnderman.this, class_1657.class, 10, false, false, predicate);
            this.continueAggroTargetConditions = class_4051.method_36625().method_36627();
            this.isAngerInducing = livingEntity -> (BaseEnderman.this.method_7026((class_1657)livingEntity) || BaseEnderman.this.method_29515((class_1309)livingEntity)) && !BaseEnderman.this.method_5821((class_1297)livingEntity);
            this.startAggroTargetConditions = class_4051.method_36625().method_18418(this.method_6326()).method_18420(this.isAngerInducing);
        }

        public boolean method_6264() {
            this.pendingTarget = BaseEnderman.this.field_6002.method_18462(this.startAggroTargetConditions, (class_1309)BaseEnderman.this);
            return this.pendingTarget != null;
        }

        public void method_6269() {
            this.aggroTime = this.method_38847(5);
            this.teleportTime = 0;
            BaseEnderman.this.method_22331();
        }

        public void method_6270() {
            this.pendingTarget = null;
            super.method_6270();
        }

        public boolean method_6266() {
            if (this.pendingTarget != null) {
                if (!this.isAngerInducing.test((class_1309)this.pendingTarget)) {
                    return false;
                }
                BaseEnderman.this.method_5951((class_1297)this.pendingTarget, 10.0f, 10.0f);
                return true;
            }
            if (this.field_6644 != null) {
                if (BaseEnderman.this.method_5821((class_1297)this.field_6644)) {
                    return false;
                }
                if (this.continueAggroTargetConditions.method_18419((class_1309)BaseEnderman.this, this.field_6644)) {
                    return true;
                }
            }
            return super.method_6266();
        }

        public void method_6268() {
            if (BaseEnderman.this.method_5968() == null) {
                super.method_24632(null);
            }
            if (this.pendingTarget != null) {
                if (--this.aggroTime <= 0) {
                    this.field_6644 = this.pendingTarget;
                    this.pendingTarget = null;
                    super.method_6269();
                }
            } else {
                if (this.field_6644 != null && !BaseEnderman.this.method_5765()) {
                    if (BaseEnderman.this.method_7026((class_1657)this.field_6644)) {
                        if (this.field_6644.method_5858((class_1297)BaseEnderman.this) < 16.0) {
                            BaseEnderman.this.method_7029();
                        }
                        this.teleportTime = 0;
                    } else if (this.field_6644.method_5858((class_1297)BaseEnderman.this) > BaseEnderman.this.getVisionRange() && this.teleportTime++ >= this.method_38847(30) && BaseEnderman.this.method_7025((class_1297)this.field_6644)) {
                        this.teleportTime = 0;
                    }
                }
                super.method_6268();
            }
        }
    }
}

