/*
 * Decompiled with CFR 0.152.
 */
package tech.alexnijjar.endermanoverhaul.fabric;

import com.teamresourceful.resourcefullib.common.registry.RegistryEntry;
import java.util.function.Predicate;
import net.fabricmc.fabric.api.biome.v1.BiomeModifications;
import net.fabricmc.fabric.api.biome.v1.BiomeSelectionContext;
import net.fabricmc.fabric.api.biome.v1.BiomeSelectors;
import net.fabricmc.fabric.api.biome.v1.ModificationPhase;
import net.fabricmc.fabric.api.object.builder.v1.entity.FabricDefaultAttributeRegistry;
import net.minecraft.class_1299;
import net.minecraft.class_1311;
import net.minecraft.class_1560;
import net.minecraft.class_1959;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5132;
import net.minecraft.class_5483;
import net.minecraft.class_6862;
import tech.alexnijjar.endermanoverhaul.EndermanOverhaul;
import tech.alexnijjar.endermanoverhaul.common.registry.ModEntityTypes;
import tech.alexnijjar.endermanoverhaul.common.tags.ModBiomeTags;

public class EndermanOverhaulFabric {
    public static void init() {
        EndermanOverhaul.init();
        ModEntityTypes.registerAttributes((type, builder) -> FabricDefaultAttributeRegistry.register((class_1299)((class_1299)type.get()), (class_5132.class_5133)((class_5132.class_5133)builder.get())));
        EndermanOverhaulFabric.addCustomSpawns();
        EndermanOverhaulFabric.removeDefaultSpawns();
    }

    private static void addCustomSpawns() {
        EndermanOverhaulFabric.addSpawn(ModEntityTypes.BADLANDS_ENDERMAN, ModBiomeTags.BADLANDS_SPAWNS);
        EndermanOverhaulFabric.addSpawn(ModEntityTypes.CAVE_ENDERMAN, ModBiomeTags.CAVE_SPAWNS);
        EndermanOverhaulFabric.addSpawnWithCost(ModEntityTypes.CRIMSON_FOREST_ENDERMAN, EndermanOverhaulFabric.tag(ModBiomeTags.CRIMSON_FOREST_SPAWNS), 2, 1, 2, 0.5, 0.1);
        EndermanOverhaulFabric.addSpawn(ModEntityTypes.DARK_OAK_ENDERMAN, ModBiomeTags.DARK_OAK_SPAWNS);
        EndermanOverhaulFabric.addSpawn(ModEntityTypes.DESERT_ENDERMAN, ModBiomeTags.DESERT_SPAWNS);
        EndermanOverhaulFabric.addSpawnWithCost(ModEntityTypes.END_ENDERMAN, EndermanOverhaulFabric.tag(ModBiomeTags.END_SPAWNS), 2, 1, 2, 0.6, 0.1);
        EndermanOverhaulFabric.addSpawnWithCost(ModEntityTypes.END_ISLANDS_ENDERMAN, EndermanOverhaulFabric.tag(ModBiomeTags.END_ISLANDS_SPAWNS), 1, 1, 1, 0.5, 0.08);
        EndermanOverhaulFabric.addSpawn(ModEntityTypes.FLOWER_FIELDS_ENDERMAN, ModBiomeTags.FLOWER_FIELDS_SPAWNS);
        EndermanOverhaulFabric.addSpawn(ModEntityTypes.ICE_SPIKES_ENDERMAN, ModBiomeTags.ICE_SPIKES_SPAWNS);
        EndermanOverhaulFabric.addSpawnWithCost(ModEntityTypes.MUSHROOM_FIELDS_ENDERMAN, EndermanOverhaulFabric.tag(ModBiomeTags.MUSHROOM_SPAWNS), 3, 1, 2, 0.7, 0.15);
        EndermanOverhaulFabric.addSpawn(ModEntityTypes.NETHER_WASTES_ENDERMAN, EndermanOverhaulFabric.tag(ModBiomeTags.NETHER_WASTES_SPAWNS), 1, 4, 4);
        EndermanOverhaulFabric.addSpawnWithCost(ModEntityTypes.OCEAN_ENDERMAN, EndermanOverhaulFabric.tag(ModBiomeTags.OCEAN_SPAWNS), 2, 1, 2, 0.7, 0.12);
        EndermanOverhaulFabric.addSpawn(ModEntityTypes.SAVANNA_ENDERMAN, ModBiomeTags.SAVANNA_SPAWNS);
        EndermanOverhaulFabric.addSpawn(ModEntityTypes.SNOWY_ENDERMAN, ModBiomeTags.SNOWY_SPAWNS);
        EndermanOverhaulFabric.addSpawnWithCost(ModEntityTypes.SOULSAND_VALLEY_ENDERMAN, EndermanOverhaulFabric.tag(ModBiomeTags.SOUL_SAND_VALLEY_SPAWNS), 2, 1, 2, 0.7, 0.15);
        EndermanOverhaulFabric.addSpawn(ModEntityTypes.SWAMP_ENDERMAN, ModBiomeTags.SWAMP_SPAWNS);
        EndermanOverhaulFabric.addSpawnWithCost(ModEntityTypes.WARPED_FOREST_ENDERMAN, EndermanOverhaulFabric.tag(ModBiomeTags.WARPED_FOREST_SPAWNS), 1, 4, 4, 1.0, 0.12);
        EndermanOverhaulFabric.addSpawn(ModEntityTypes.WINDSWEPT_HILLS_ENDERMAN, ModBiomeTags.WINDSWEPT_HILLS_SPAWNS);
    }

    public static void removeDefaultSpawns() {
        BiomeModifications.create((class_2960)class_2378.field_11145.method_10221((Object)class_1299.field_6091)).add(ModificationPhase.REMOVALS, EndermanOverhaulFabric.tag(ModBiomeTags.ALL_SPAWNS), context -> {
            context.getSpawnSettings().removeSpawnsOfEntityType(class_1299.field_6091);
            context.getSpawnSettings().clearSpawnCost(class_1299.field_6091);
        });
    }

    private static Predicate<BiomeSelectionContext> tag(class_6862<class_1959> tag) {
        return BiomeSelectors.tag(tag);
    }

    private static <T extends class_1560> void addSpawn(RegistryEntry<class_1299<T>> type, class_6862<class_1959> tag) {
        EndermanOverhaulFabric.addSpawn(type, EndermanOverhaulFabric.tag(tag), 10, 1, 4);
    }

    private static <T extends class_1560> void addSpawn(RegistryEntry<class_1299<T>> type, Predicate<BiomeSelectionContext> biomeSelector, int weight, int min, int max) {
        BiomeModifications.addSpawn(biomeSelector, (class_1311)((class_1299)type.get()).method_5891(), (class_1299)((class_1299)type.get()), (int)weight, (int)min, (int)max);
    }

    public static <T extends class_1560> void addSpawnWithCost(RegistryEntry<class_1299<T>> type, Predicate<BiomeSelectionContext> biomeSelector, int weight, int min, int max, double charge, double energyBudget) {
        BiomeModifications.create((class_2960)type.getId()).add(ModificationPhase.ADDITIONS, biomeSelector, context -> {
            context.getSpawnSettings().addSpawn(((class_1299)type.get()).method_5891(), new class_5483.class_1964((class_1299)type.get(), weight, min, max));
            context.getSpawnSettings().setSpawnCost((class_1299)type.get(), charge, energyBudget);
        });
    }
}

