/*
 * Decompiled with CFR 0.152.
 */
package com.teamresourceful.resourcefullib.common.utils.readers;

import com.google.common.primitives.Ints;
import com.google.common.primitives.Longs;
import com.google.common.primitives.Shorts;

public interface ByteReader {
    public byte peek();

    public void advance();

    public byte readByte();

    default public char readChar() {
        return (char)this.readByte();
    }

    default public boolean readBoolean() {
        return this.readByte() == 1;
    }

    default public short readShort() {
        return Shorts.fromBytes((byte)this.readByte(), (byte)this.readByte());
    }

    default public int readInt() {
        return Ints.fromBytes((byte)this.readByte(), (byte)this.readByte(), (byte)this.readByte(), (byte)this.readByte());
    }

    default public long readLong() {
        return Longs.fromBytes((byte)this.readByte(), (byte)this.readByte(), (byte)this.readByte(), (byte)this.readByte(), (byte)this.readByte(), (byte)this.readByte(), (byte)this.readByte(), (byte)this.readByte());
    }

    default public float readFloat() {
        return Float.intBitsToFloat(this.readInt());
    }

    default public double readDouble() {
        return Double.longBitsToDouble(this.readLong());
    }

    default public String readString() {
        StringBuilder builder = new StringBuilder();
        while (this.peek() != 0) {
            builder.append(this.readChar());
        }
        this.advance();
        return builder.toString();
    }
}

