/*
 * Decompiled with CFR 0.152.
 */
package com.teamresourceful.resourcefullib.common.codecs.recipes;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.teamresourceful.resourcefullib.common.codecs.CodecExtras;
import java.util.Optional;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public final class ItemStackCodec {
    private static final Codec<ItemStack> STRING_EITHER = Registry.f_122827_.m_194605_().xmap(ItemStack::new, ItemStack::m_41720_);
    private static final Codec<ItemStack> STACK_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Registry.f_122827_.m_194605_().fieldOf("id").forGetter(ItemStack::m_41720_), (App)Codec.INT.fieldOf("count").orElse((Object)1).forGetter(ItemStack::m_41613_), (App)CompoundTag.f_128325_.optionalFieldOf("nbt").forGetter(o -> Optional.ofNullable(o.m_41783_()))).apply((Applicative)instance, ItemStackCodec::createItemStack));
    public static final Codec<ItemStack> CODEC = CodecExtras.eitherRight(Codec.either(STRING_EITHER, STACK_CODEC));
    public static final Codec<ItemStack> NETWORK_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)CodecExtras.registerId(Registry.f_122827_).fieldOf("id").forGetter(ItemStack::m_41720_), (App)Codec.INT.fieldOf("count").orElse((Object)1).forGetter(ItemStack::m_41613_), (App)CompoundTag.f_128325_.optionalFieldOf("nbt").forGetter(o -> Optional.ofNullable(o.m_41783_()))).apply((Applicative)instance, ItemStackCodec::createItemStack));

    private static ItemStack createItemStack(ItemLike item, int count, Optional<CompoundTag> tagOptional) {
        ItemStack stack = new ItemStack(item, count);
        tagOptional.ifPresent(arg_0 -> ((ItemStack)stack).m_41751_(arg_0));
        return stack;
    }
}

