/*
 * Decompiled with CFR 0.152.
 */
package tech.alexnijjar.endermanoverhaul.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.geo.render.built.GeoBone;
import software.bernie.geckolib3.renderers.geo.GeoReplacedEntityRenderer;
import software.bernie.geckolib3.util.RenderUtils;
import tech.alexnijjar.endermanoverhaul.client.renderer.base.BaseEndermanEntityRenderer;
import tech.alexnijjar.endermanoverhaul.client.renderer.base.ReplacedEndermanCarriedBlockLayer;
import tech.alexnijjar.endermanoverhaul.client.renderer.base.ReplacedEndermanEnderEyesLayer;
import tech.alexnijjar.endermanoverhaul.client.renderer.base.ReplacedEndermanModel;
import tech.alexnijjar.endermanoverhaul.client.utils.ClientPlatformUtils;
import tech.alexnijjar.endermanoverhaul.common.entities.ReplacedEnderman;

public class ReplacedEndermanRenderer
extends GeoReplacedEntityRenderer<ReplacedEnderman> {
    public static final ResourceLocation MODEL = new ResourceLocation("endermanoverhaul", "geo/entity/default_enderman.geo.json");
    public static final ResourceLocation TEXTURE = new ResourceLocation("endermanoverhaul", "default/default_enderman");
    public static final ResourceLocation GLOW = new ResourceLocation("endermanoverhaul", "textures/entity/default/default_enderman_glow.png");
    protected EnderMan currentEntity;

    public ReplacedEndermanRenderer(EntityRendererProvider.Context renderManager) {
        super(renderManager, new ReplacedEndermanModel(new ResourceLocation("endermanoverhaul", "default_enderman"), true, TEXTURE, BaseEndermanEntityRenderer.ANIMATION), (IAnimatable)new ReplacedEnderman());
        ClientPlatformUtils.registerReplacedRenderer(ReplacedEnderman.class, this);
        ((ReplacedEndermanModel)this.getGeoModelProvider()).setEnderman(() -> this.getCurrentEntity());
        this.addLayer(new ReplacedEndermanEnderEyesLayer(this, GLOW));
        this.addLayer(new ReplacedEndermanCarriedBlockLayer(this, renderManager.m_234597_()));
    }

    private EnderMan getCurrentEntity() {
        return this.currentEntity;
    }

    @NotNull
    public Vec3 m_7860_(@NotNull Entity entity, float partialTicks) {
        this.currentEntity = (EnderMan)entity;
        if (!(entity instanceof EnderMan)) {
            return super.m_7860_(entity, partialTicks);
        }
        EnderMan enderman = (EnderMan)entity;
        if (enderman.m_32531_()) {
            Level level = entity.f_19853_;
            return new Vec3(level.f_46441_.m_188583_() * 0.02, 0.0, level.f_46441_.m_188583_() * 0.02);
        }
        return super.m_7860_(entity, partialTicks);
    }

    public void renderRecursively(GeoBone bone, PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        if (bone.isTrackingXform()) {
            EnderMan entity = this.currentEntity;
            Matrix4f poseState = poseStack.m_85850_().m_85861_().m_27658_();
            Matrix4f localMatrix = RenderUtils.invertAndMultiplyMatrices((Matrix4f)poseState, (Matrix4f)this.dispatchedMat);
            bone.setModelSpaceXform(RenderUtils.invertAndMultiplyMatrices((Matrix4f)poseState, (Matrix4f)this.renderEarlyMat));
            localMatrix.m_27648_(new Vector3f(this.m_7860_((Entity)entity, 1.0f)));
            bone.setLocalSpaceXform(localMatrix);
            Matrix4f worldState = localMatrix.m_27658_();
            worldState.m_27648_(new Vector3f(entity.m_20182_()));
            bone.setWorldSpaceXform(worldState);
        }
        poseStack.m_85836_();
        RenderUtils.prepMatrixForBone((PoseStack)poseStack, (GeoBone)bone);
        this.renderCubesOfBone(bone, poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        this.renderChildBones(bone, poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        poseStack.m_85849_();
    }
}

