/*
 * Decompiled with CFR 0.152.
 */
package tech.alexnijjar.endermanoverhaul.client.renderer.base;

import net.minecraft.resources.ResourceLocation;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.processor.IBone;
import software.bernie.geckolib3.geo.render.built.GeoBone;
import software.bernie.geckolib3.model.AnimatedGeoModel;
import software.bernie.geckolib3.model.provider.data.EntityModelData;

public class BaseEndermanModel<T extends IAnimatable>
extends AnimatedGeoModel<T> {
    private final boolean turnsHead;
    private final ResourceLocation assetSubpath;
    private final ResourceLocation texture;
    private final ResourceLocation animation;

    public BaseEndermanModel(ResourceLocation assetSubpath, boolean turnsHead, ResourceLocation texture, ResourceLocation animation) {
        this.texture = this.buildFormattedTexturePath(texture);
        this.assetSubpath = this.buildFormattedModelPath(assetSubpath);
        this.animation = this.buildFormattedAnimationPath(animation);
        this.turnsHead = turnsHead;
    }

    public ResourceLocation buildFormattedModelPath(ResourceLocation basePath) {
        return new ResourceLocation(basePath.m_135827_(), "geo/entity/" + basePath.m_135815_() + ".geo.json");
    }

    public ResourceLocation buildFormattedAnimationPath(ResourceLocation basePath) {
        return new ResourceLocation(basePath.m_135827_(), "animations/entity/" + basePath.m_135815_() + ".animation.json");
    }

    public ResourceLocation buildFormattedTexturePath(ResourceLocation basePath) {
        return new ResourceLocation(basePath.m_135827_(), "textures/entity/" + basePath.m_135815_() + ".png");
    }

    public void setCustomAnimations(T animatable, int instanceId, AnimationEvent animationState) {
        super.setCustomAnimations(animatable, instanceId, animationState);
        if (!this.turnsHead) {
            return;
        }
        GeoBone head = (GeoBone)this.getAnimationProcessor().getBone("head");
        if (head == null) {
            return;
        }
        if (head.childBones.isEmpty()) {
            return;
        }
        IBone headRotation = (IBone)head.childBones.get(0);
        if (headRotation == null) {
            return;
        }
        EntityModelData entityData = (EntityModelData)animationState.getExtraDataOfType(EntityModelData.class).get(0);
        headRotation.setRotationX(entityData.headPitch * ((float)Math.PI / 180));
        headRotation.setRotationY(entityData.netHeadYaw * ((float)Math.PI / 180));
    }

    public ResourceLocation getModelResource(T object) {
        return this.assetSubpath;
    }

    public ResourceLocation getTextureResource(T object) {
        return this.texture;
    }

    public ResourceLocation getAnimationResource(T animatable) {
        return this.animation;
    }
}

