/*
 * Decompiled with CFR 0.152.
 */
package tech.alexnijjar.endermanoverhaul.common.entities;

import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.item.enchantment.FrostWalkerEnchantment;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tech.alexnijjar.endermanoverhaul.common.config.EndermanOverhaulConfig;
import tech.alexnijjar.endermanoverhaul.common.entities.base.BaseEnderman;
import tech.alexnijjar.endermanoverhaul.common.registry.ModParticleTypes;

public class SnowyEnderman
extends BaseEnderman {
    public SnowyEnderman(EntityType<? extends EnderMan> entityType, Level level) {
        super(entityType, level);
        this.f_21364_ = 8;
    }

    @NotNull
    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 35.0).m_22268_(Attributes.f_22279_, 0.1944).m_22268_(Attributes.f_22281_, 6.0).m_22268_(Attributes.f_22277_, 42.0);
    }

    public static boolean checkMonsterSpawnRules(@NotNull EntityType<? extends Monster> type, ServerLevelAccessor level, @NotNull MobSpawnType spawnType, @NotNull BlockPos pos, @NotNull RandomSource random) {
        if (!EndermanOverhaulConfig.spawnSnowyEnderman || !EndermanOverhaulConfig.allowSpawning) {
            return false;
        }
        return BaseEnderman.m_219013_(type, (ServerLevelAccessor)level, (MobSpawnType)spawnType, (BlockPos)pos, (RandomSource)random);
    }

    @Override
    public boolean canOpenMouth() {
        return false;
    }

    @Override
    @Nullable
    public ParticleOptions getCustomParticles() {
        return (ParticleOptions)ModParticleTypes.SNOW.get();
    }

    @Override
    public double getVisionRange() {
        return 42.0;
    }

    @Override
    @Nullable
    public MobEffectInstance getHitEffect() {
        return new MobEffectInstance(new MobEffectInstance(MobEffects.f_19597_, 100, 3));
    }

    protected void m_5806_(@NotNull BlockPos pos) {
        super.m_5806_(pos);
        FrostWalkerEnchantment.m_45018_((LivingEntity)this, (Level)this.f_19853_, (BlockPos)pos, (int)2);
    }

    @Override
    public boolean m_7327_(@NotNull Entity target) {
        if (super.m_7327_(target)) {
            LivingEntity entity;
            if (target instanceof LivingEntity && !(entity = (LivingEntity)target).m_146890_()) {
                entity.m_146917_(entity.m_146888_() + 100);
            }
            return true;
        }
        return false;
    }
}

