/*
 * Decompiled with CFR 0.152.
 */
package tech.alexnijjar.endermanoverhaul.common.entities;

import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.manager.AnimationData;
import tech.alexnijjar.endermanoverhaul.common.config.EndermanOverhaulConfig;
import tech.alexnijjar.endermanoverhaul.common.constants.ConstantAnimations;
import tech.alexnijjar.endermanoverhaul.common.entities.base.BaseEnderman;
import tech.alexnijjar.endermanoverhaul.common.entities.summons.Spirit;
import tech.alexnijjar.endermanoverhaul.common.registry.ModEntityTypes;
import tech.alexnijjar.endermanoverhaul.common.registry.ModParticleTypes;
import tech.alexnijjar.endermanoverhaul.common.registry.ModSoundEvents;

public class SoulsandValleyEnderman
extends BaseEnderman {
    private static final EntityDataAccessor<Integer> DATA_BITING_TICKS = SynchedEntityData.m_135353_(SoulsandValleyEnderman.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public SoulsandValleyEnderman(EntityType<? extends EnderMan> entityType, Level level) {
        super(entityType, level);
        this.f_21364_ = 8;
    }

    @NotNull
    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 30.0).m_22268_(Attributes.f_22279_, 0.35).m_22268_(Attributes.f_22281_, 10.0).m_22268_(Attributes.f_22277_, 24.0).m_22268_(Attributes.f_22278_, 0.5);
    }

    public static boolean checkMonsterSpawnRules(@NotNull EntityType<? extends Monster> type, ServerLevelAccessor level, @NotNull MobSpawnType spawnType, @NotNull BlockPos pos, @NotNull RandomSource random) {
        if (!EndermanOverhaulConfig.spawnSoulsandValleyEnderman || !EndermanOverhaulConfig.allowSpawning) {
            return false;
        }
        return BaseEnderman.m_219013_(type, (ServerLevelAccessor)level, (MobSpawnType)spawnType, (BlockPos)pos, (RandomSource)random);
    }

    @Override
    public void registerControllers(AnimationData data) {
        super.registerControllers(data);
        data.addAnimationController(new AnimationController((IAnimatable)this, "bite_controller", 5.0f, state -> {
            if ((Integer)this.f_19804_.m_135370_(DATA_BITING_TICKS) <= 0) {
                return PlayState.STOP;
            }
            state.getController().setAnimation(ConstantAnimations.BITE);
            return PlayState.CONTINUE;
        }));
    }

    @Override
    public void m_8119_() {
        if ((Integer)this.f_19804_.m_135370_(DATA_BITING_TICKS) > 0) {
            this.f_19804_.m_135381_(DATA_BITING_TICKS, (Object)((Integer)this.f_19804_.m_135370_(DATA_BITING_TICKS) - 1));
        }
        super.m_8119_();
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_BITING_TICKS, (Object)0);
    }

    @Override
    public boolean canOpenMouth() {
        return false;
    }

    @Override
    public boolean playRunAnimWhenAngry() {
        return false;
    }

    @Override
    public boolean playArmSwingAnimWhenAttacking() {
        return false;
    }

    @Override
    public boolean isProvokedByEyeContact() {
        return false;
    }

    @Override
    @Nullable
    public ParticleOptions getCustomParticles() {
        return (ParticleOptions)ModParticleTypes.SOUL_FIRE_FLAME.get();
    }

    @Override
    public boolean isAlwaysHostile() {
        return true;
    }

    @Override
    public double getVisionRange() {
        return 32.0;
    }

    @Override
    public boolean canPickupBlocks() {
        return false;
    }

    @Override
    public boolean m_7327_(@NotNull Entity target) {
        if (super.m_7327_(target)) {
            this.m_5496_(SoundEvents.f_12228_, 10.0f, 0.95f + this.f_19796_.m_188501_() * 0.1f);
            this.f_19804_.m_135381_(DATA_BITING_TICKS, (Object)7);
            return true;
        }
        return false;
    }

    public void m_6667_(@NotNull DamageSource damageSource) {
        int i;
        super.m_6667_(damageSource);
        for (i = 0; i < 3; ++i) {
            Spirit spirit = (Spirit)((EntityType)ModEntityTypes.SPIRIT.get()).m_20615_(this.f_19853_);
            if (spirit == null) {
                return;
            }
            spirit.m_6034_(this.m_20185_(), this.m_20186_() + 2.0, this.m_20189_());
            spirit.m_20256_(new Vec3(0.0, 0.5, 0.0));
            this.f_19853_.m_7967_((Entity)spirit);
            spirit.m_6710_(this.m_5448_());
        }
        for (i = 0; i < 10; ++i) {
            this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123746_, this.m_20208_(0.5), this.m_20187_() - 1.25, this.m_20262_(0.5), (this.f_19796_.m_188500_() - 0.5) * 0.5, -this.f_19796_.m_188500_(), (this.f_19796_.m_188500_() - 0.5) * 0.5);
        }
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)ModSoundEvents.CAVE_ENDERMAN_AMBIENT.get();
    }

    protected SoundEvent m_7975_(@NotNull DamageSource damageSource) {
        return (SoundEvent)ModSoundEvents.CAVE_ENDERMAN_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)ModSoundEvents.CAVE_ENDERMAN_HURT.get();
    }
}

