/*
 * Decompiled with CFR 0.152.
 */
package tech.alexnijjar.endermanoverhaul.common.entities.projectiles;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;
import software.bernie.geckolib3.util.GeckoLibUtil;
import tech.alexnijjar.endermanoverhaul.common.ModUtils;
import tech.alexnijjar.endermanoverhaul.common.constants.ConstantAnimations;
import tech.alexnijjar.endermanoverhaul.common.entities.EndIslandsEnderman;
import tech.alexnijjar.endermanoverhaul.common.registry.ModEntityTypes;

public class EnderBullet
extends Projectile
implements IAnimatable {
    private final AnimationFactory factory = GeckoLibUtil.createFactory((IAnimatable)this);
    private static final double SPEED = 0.25;
    @Nullable
    private Entity finalTarget;
    @Nullable
    private Direction currentMoveDirection;
    private int flightSteps;
    private double targetDeltaX;
    private double targetDeltaY;
    private double targetDeltaZ;
    @Nullable
    private UUID targetId;

    public EnderBullet(EntityType<? extends EnderBullet> entityType, Level level) {
        super(entityType, level);
        this.f_19794_ = true;
    }

    public EnderBullet(Level level, LivingEntity livingEntity, @Nullable Entity entity, Direction.Axis axis) {
        this((EntityType<? extends EnderBullet>)((EntityType)ModEntityTypes.ENDER_BULLET.get()), level);
        this.m_5602_((Entity)livingEntity);
        BlockPos blockPos = livingEntity.m_20183_();
        double d = (double)blockPos.m_123341_() + 0.5;
        double e = (double)blockPos.m_123342_() + 0.5;
        double f = (double)blockPos.m_123343_() + 0.5;
        this.m_7678_(d, e, f, this.m_146908_(), this.m_146909_());
        this.finalTarget = entity;
        this.currentMoveDirection = Direction.UP;
        this.selectNextMoveDirection(axis);
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 0.0f, state -> {
            state.getController().setAnimation(ConstantAnimations.SPIN);
            return PlayState.CONTINUE;
        }));
    }

    public SoundSource m_5720_() {
        return SoundSource.HOSTILE;
    }

    protected void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        if (this.finalTarget != null) {
            compound.m_128362_("Target", this.finalTarget.m_20148_());
        }
        if (this.currentMoveDirection != null) {
            compound.m_128405_("Dir", this.currentMoveDirection.m_122411_());
        }
        compound.m_128405_("Steps", this.flightSteps);
        compound.m_128347_("TXD", this.targetDeltaX);
        compound.m_128347_("TYD", this.targetDeltaY);
        compound.m_128347_("TZD", this.targetDeltaZ);
    }

    protected void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.flightSteps = compound.m_128451_("Steps");
        this.targetDeltaX = compound.m_128459_("TXD");
        this.targetDeltaY = compound.m_128459_("TYD");
        this.targetDeltaZ = compound.m_128459_("TZD");
        if (compound.m_128425_("Dir", 99)) {
            this.currentMoveDirection = Direction.m_122376_((int)compound.m_128451_("Dir"));
        }
        if (compound.m_128403_("Target")) {
            this.targetId = compound.m_128342_("Target");
        }
    }

    protected void m_8097_() {
    }

    private void setMoveDirection(@Nullable Direction direction) {
        this.currentMoveDirection = direction;
    }

    private void selectNextMoveDirection(@Nullable Direction.Axis axis) {
        BlockPos blockPos;
        double d = 0.5;
        if (this.finalTarget == null) {
            blockPos = this.m_20183_().m_7495_();
        } else {
            d = (double)this.finalTarget.m_20206_() * 0.5;
            blockPos = new BlockPos(this.finalTarget.m_20185_(), this.finalTarget.m_20186_() + d, this.finalTarget.m_20189_());
        }
        double e = (double)blockPos.m_123341_() + 0.5;
        double f = (double)blockPos.m_123342_() + d;
        double g = (double)blockPos.m_123343_() + 0.5;
        Direction direction = null;
        if (!blockPos.m_203195_((Position)this.m_20182_(), 2.0)) {
            BlockPos blockPos2 = this.m_20183_();
            ArrayList list = Lists.newArrayList();
            if (axis != Direction.Axis.X) {
                if (blockPos2.m_123341_() < blockPos.m_123341_() && this.f_19853_.m_46859_(blockPos2.m_122029_())) {
                    list.add(Direction.EAST);
                } else if (blockPos2.m_123341_() > blockPos.m_123341_() && this.f_19853_.m_46859_(blockPos2.m_122024_())) {
                    list.add(Direction.WEST);
                }
            }
            if (axis != Direction.Axis.Y) {
                if (blockPos2.m_123342_() < blockPos.m_123342_() && this.f_19853_.m_46859_(blockPos2.m_7494_())) {
                    list.add(Direction.UP);
                } else if (blockPos2.m_123342_() > blockPos.m_123342_() && this.f_19853_.m_46859_(blockPos2.m_7495_())) {
                    list.add(Direction.DOWN);
                }
            }
            if (axis != Direction.Axis.Z) {
                if (blockPos2.m_123343_() < blockPos.m_123343_() && this.f_19853_.m_46859_(blockPos2.m_122019_())) {
                    list.add(Direction.SOUTH);
                } else if (blockPos2.m_123343_() > blockPos.m_123343_() && this.f_19853_.m_46859_(blockPos2.m_122012_())) {
                    list.add(Direction.NORTH);
                }
            }
            direction = Direction.m_235672_((RandomSource)this.f_19796_);
            if (list.isEmpty()) {
                for (int i = 5; !this.f_19853_.m_46859_(blockPos2.m_121945_(direction)) && i > 0; --i) {
                    direction = Direction.m_235672_((RandomSource)this.f_19796_);
                }
            } else {
                direction = (Direction)list.get(this.f_19796_.m_188503_(list.size()));
            }
            e = this.m_20185_() + (double)direction.m_122429_();
            f = this.m_20186_() + (double)direction.m_122430_();
            g = this.m_20189_() + (double)direction.m_122431_();
        }
        this.setMoveDirection(direction);
        double h = e - this.m_20185_();
        double j = f - this.m_20186_();
        double k = g - this.m_20189_();
        double l = Math.sqrt(h * h + j * j + k * k);
        if (l == 0.0) {
            this.targetDeltaX = 0.0;
            this.targetDeltaY = 0.0;
            this.targetDeltaZ = 0.0;
        } else {
            this.targetDeltaX = h / l * 0.25;
            this.targetDeltaY = j / l * 0.25;
            this.targetDeltaZ = k / l * 0.25;
        }
        this.f_19812_ = true;
        this.flightSteps = 10 + this.f_19796_.m_188503_(5) * 10;
    }

    public void m_6043_() {
        if (this.f_19853_.m_46791_() == Difficulty.PEACEFUL) {
            this.m_146870_();
        }
    }

    public void m_8119_() {
        Vec3 vec3;
        super.m_8119_();
        if (!this.f_19853_.f_46443_) {
            HitResult hitResult;
            if (this.finalTarget == null && this.targetId != null) {
                this.finalTarget = ((ServerLevel)this.f_19853_).m_8791_(this.targetId);
                if (this.finalTarget == null) {
                    this.targetId = null;
                }
            }
            if (this.finalTarget == null || !this.finalTarget.m_6084_() || this.finalTarget instanceof Player && this.finalTarget.m_5833_()) {
                if (!this.m_20068_()) {
                    this.m_20256_(this.m_20184_().m_82520_(0.0, -0.04, 0.0));
                }
            } else {
                this.targetDeltaX = Mth.m_14008_((double)(this.targetDeltaX * 1.025), (double)-1.0, (double)1.0);
                this.targetDeltaY = Mth.m_14008_((double)(this.targetDeltaY * 1.025), (double)-1.0, (double)1.0);
                this.targetDeltaZ = Mth.m_14008_((double)(this.targetDeltaZ * 1.025), (double)-1.0, (double)1.0);
                vec3 = this.m_20184_();
                this.m_20256_(vec3.m_82520_((this.targetDeltaX - vec3.f_82479_) * 0.2, (this.targetDeltaY - vec3.f_82480_) * 0.2, (this.targetDeltaZ - vec3.f_82481_) * 0.2));
            }
            if ((hitResult = ProjectileUtil.m_37294_((Entity)this, this::m_5603_)).m_6662_() != HitResult.Type.MISS) {
                this.m_6532_(hitResult);
            }
        }
        this.m_20101_();
        vec3 = this.m_20184_();
        this.m_6034_(this.m_20185_() + vec3.f_82479_, this.m_20186_() + vec3.f_82480_, this.m_20189_() + vec3.f_82481_);
        ProjectileUtil.m_37284_((Entity)this, (float)0.5f);
        if (this.f_19853_.f_46443_) {
            for (int i = 0; i < 5; ++i) {
                this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123760_, this.m_20208_(0.5), this.m_20187_() - 0.25, this.m_20262_(0.5), (this.f_19796_.m_188500_() - 0.5) * 2.0, -this.f_19796_.m_188500_(), (this.f_19796_.m_188500_() - 0.5) * 2.0);
            }
        } else if (this.finalTarget != null && !this.finalTarget.m_213877_()) {
            if (this.flightSteps > 0) {
                --this.flightSteps;
                if (this.flightSteps == 0) {
                    this.selectNextMoveDirection(this.currentMoveDirection == null ? null : this.currentMoveDirection.m_122434_());
                }
            }
            if (this.currentMoveDirection != null) {
                BlockPos blockPos = this.m_20183_();
                Direction.Axis axis = this.currentMoveDirection.m_122434_();
                if (this.f_19853_.m_46575_(blockPos.m_121945_(this.currentMoveDirection), (Entity)this)) {
                    this.selectNextMoveDirection(axis);
                } else {
                    BlockPos blockPos2 = this.finalTarget.m_20183_();
                    if (axis == Direction.Axis.X && blockPos.m_123341_() == blockPos2.m_123341_() || axis == Direction.Axis.Z && blockPos.m_123343_() == blockPos2.m_123343_() || axis == Direction.Axis.Y && blockPos.m_123342_() == blockPos2.m_123342_()) {
                        this.selectNextMoveDirection(axis);
                    }
                }
            }
        }
    }

    protected boolean m_5603_(@NotNull Entity target) {
        return super.m_5603_(target) && !target.f_19794_;
    }

    public boolean m_6060_() {
        return false;
    }

    public boolean m_6783_(double distance) {
        return distance < 16384.0;
    }

    public float m_213856_() {
        return 1.0f;
    }

    protected void m_5790_(@NotNull EntityHitResult result) {
        LivingEntity e;
        LivingEntity livingEntity;
        if (result.m_82443_() instanceof EndIslandsEnderman) {
            return;
        }
        super.m_5790_(result);
        Entity entity = result.m_82443_();
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity target = (LivingEntity)entity;
        Entity entity2 = this.m_37282_();
        LivingEntity livingEntity2 = livingEntity = entity2 instanceof LivingEntity ? (e = (LivingEntity)entity2) : null;
        if (target.m_6469_(DamageSource.m_19340_((Entity)this, (LivingEntity)livingEntity).m_19366_(), 15.0f)) {
            if (livingEntity != null) {
                this.m_19970_(livingEntity, (Entity)target);
            }
            ModUtils.teleportTarget(this.f_19853_, target, 32);
        }
    }

    protected void m_8060_(@NotNull BlockHitResult result) {
        super.m_8060_(result);
        ((ServerLevel)this.f_19853_).m_8767_((ParticleOptions)ParticleTypes.f_123813_, this.m_20185_(), this.m_20186_(), this.m_20189_(), 2, 0.2, 0.2, 0.2, 0.0);
        this.m_5496_(SoundEvents.f_12410_, 1.0f, 1.0f);
    }

    protected void m_6532_(@NotNull HitResult result) {
        super.m_6532_(result);
        this.m_146870_();
    }

    public boolean m_6087_() {
        return true;
    }

    public boolean m_6469_(@NotNull DamageSource source, float amount) {
        if (!this.f_19853_.f_46443_) {
            this.m_5496_(SoundEvents.f_12411_, 1.0f, 1.0f);
            ((ServerLevel)this.f_19853_).m_8767_((ParticleOptions)ParticleTypes.f_123797_, this.m_20185_(), this.m_20186_(), this.m_20189_(), 15, 0.2, 0.2, 0.2, 0.0);
            this.m_146870_();
        }
        return true;
    }

    public void m_141965_(@NotNull ClientboundAddEntityPacket packet) {
        super.m_141965_(packet);
        double d = packet.m_131503_();
        double e = packet.m_131504_();
        double f = packet.m_131505_();
        this.m_20334_(d, e, f);
    }
}

