/*
 * Decompiled with CFR 0.152.
 */
package tech.alexnijjar.endermanoverhaul.common.entities.projectiles;

import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tech.alexnijjar.endermanoverhaul.common.ModUtils;
import tech.alexnijjar.endermanoverhaul.common.entities.pets.AxolotlPetEnderman;
import tech.alexnijjar.endermanoverhaul.common.entities.pets.BasePetEnderman;
import tech.alexnijjar.endermanoverhaul.common.entities.pets.HammerheadPetEnderman;
import tech.alexnijjar.endermanoverhaul.common.entities.pets.PetEnderman;
import tech.alexnijjar.endermanoverhaul.common.registry.ModEntityTypes;
import tech.alexnijjar.endermanoverhaul.common.registry.ModItems;
import tech.alexnijjar.endermanoverhaul.common.registry.ModSoundEvents;

public class ThrownAncientPearl
extends ThrowableItemProjectile {
    @Nullable
    private Entity existingPet;

    public ThrownAncientPearl(EntityType<? extends ThrownAncientPearl> type, Level level) {
        super(type, level);
    }

    public ThrownAncientPearl(Level level, LivingEntity shooter) {
        this(level, shooter, null);
    }

    public ThrownAncientPearl(Level level, LivingEntity shooter, @Nullable Entity existingPet) {
        super((EntityType)ModEntityTypes.ANCIENT_PEARL.get(), shooter, level);
        this.existingPet = existingPet;
    }

    @NotNull
    protected Item m_7881_() {
        return (Item)ModItems.ANCIENT_PEARL.get();
    }

    protected void m_5790_(@NotNull EntityHitResult result) {
        super.m_5790_(result);
        result.m_82443_().m_6469_(DamageSource.m_19361_((Entity)this, (Entity)this.m_37282_()), 0.0f);
    }

    protected void m_6532_(@NotNull HitResult result) {
        super.m_6532_(result);
        if (this.f_19853_.m_5776_() || this.m_213877_()) {
            return;
        }
        for (int i = 0; i < 32; ++i) {
            ModUtils.sendParticles((ServerLevel)this.f_19853_, ParticleTypes.f_123760_, this.m_20185_(), this.m_20186_() - 1.0 + this.f_19796_.m_188500_() * 2.0, this.m_20189_(), 1, 0.0, 0.0, 0.0, -1.3);
        }
        Entity entity = this.m_37282_();
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity entity2 = (LivingEntity)entity;
        if (entity2 instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity2;
            if (serverPlayer.f_8906_.m_6198_().m_129536_()) {
                Entity pet;
                Entity entity3 = pet = this.existingPet != null ? this.existingPet : this.createPet(serverPlayer);
                if (result instanceof EntityHitResult) {
                    EntityHitResult entityHitResult = (EntityHitResult)result;
                    if (pet instanceof Mob) {
                        Mob hit;
                        Mob mob = (Mob)pet;
                        Entity entity4 = entityHitResult.m_82443_();
                        if (entity4 instanceof Mob && !((hit = (Mob)entity4) instanceof TamableAnimal)) {
                            mob.m_6710_((LivingEntity)hit);
                        }
                    }
                }
                if (pet == null) {
                    return;
                }
                pet.m_6034_(this.m_20185_(), this.m_20186_(), this.m_20189_());
                this.f_19853_.m_7967_(pet);
            }
        }
        this.f_19853_.m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)ModSoundEvents.ANCIENT_PEARL_HIT.get(), this.m_5720_(), 1.0f, this.f_19796_.m_188501_() * 0.4f + 0.8f);
        this.m_146870_();
    }

    private Entity createPet(ServerPlayer player) {
        return ThrownAncientPearl.createPet(this.f_19853_, (Player)player, this.f_19796_.m_188503_(3));
    }

    public void m_8119_() {
        Entity entity = this.m_37282_();
        if (entity instanceof Player && !entity.m_6084_()) {
            this.m_146870_();
        } else {
            super.m_8119_();
        }
    }

    @Nullable
    public Entity m_5489_(@NotNull ServerLevel destination) {
        Entity entity = this.m_37282_();
        if (entity != null && entity.f_19853_.m_46472_() != destination.m_46472_()) {
            this.m_5602_(null);
        }
        return super.m_5489_(destination);
    }

    public static BasePetEnderman createPet(Level level, Player player, int id) {
        return switch (id) {
            case 1 -> new HammerheadPetEnderman(level, player);
            case 2 -> new AxolotlPetEnderman(level, player);
            default -> new PetEnderman(level, player);
        };
    }
}

