/*
 * Decompiled with CFR 0.152.
 */
package com.teamresourceful.resourcefullib.client.components.context;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;

public class ContextMenu
extends AbstractWidget {
    private final List<Pair<Component, Runnable>> options = new ArrayList<Pair<Component, Runnable>>();

    public ContextMenu() {
        super(0, 0, 0, 0, CommonComponents.EMPTY);
        this.visible = false;
        this.active = false;
    }

    protected void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        graphics.fillGradient(this.getX(), this.getY(), this.getX() + this.width, this.getY() + this.height, -1072689136, -804253680);
        int y = this.getY() + 5;
        for (Pair<Component, Runnable> entry : this.options) {
            if (entry == null) {
                graphics.fill(this.getX() + 5, y + 3, this.getX() + this.width - 5, y + 4, -2139062144);
                y += 7;
                continue;
            }
            int x = this.getX() + 5;
            if (mouseX >= x && mouseX <= x + this.width && mouseY >= y) {
                Objects.requireNonNull(Minecraft.getInstance().font);
                if (mouseY <= y + 9) {
                    Objects.requireNonNull(Minecraft.getInstance().font);
                    graphics.fill(x - 5, y, x + this.width - 5, y + 9 + 4, -2139062144);
                }
            }
            graphics.drawString(Minecraft.getInstance().font, (Component)entry.getFirst(), x, y + 2, -1);
            Objects.requireNonNull(Minecraft.getInstance().font);
            y += 9 + 4;
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (button == 0) {
            int y = this.getY() + 5;
            for (Pair<Component, Runnable> entry : this.options) {
                if (entry == null) {
                    y += 7;
                    continue;
                }
                int x = this.getX() + 5;
                int width = Minecraft.getInstance().font.width((FormattedText)entry.getFirst());
                if (mouseX >= (double)x && mouseX <= (double)(x + width) && mouseY >= (double)y) {
                    Objects.requireNonNull(Minecraft.getInstance().font);
                    if (mouseY <= (double)(y + 9 + 4)) {
                        ((Runnable)entry.getSecond()).run();
                        this.visible = false;
                        return true;
                    }
                }
                Objects.requireNonNull(Minecraft.getInstance().font);
                y += 9 + 4;
            }
            this.close();
        }
        return false;
    }

    public boolean isMouseOver(double mouseX, double mouseY) {
        return this.isActive();
    }

    protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
    }

    public ContextMenu start(double x, double y) {
        this.options.clear();
        this.setX((int)x);
        this.setY((int)y);
        return this;
    }

    public ContextMenu addOption(Component component, Runnable runnable) {
        this.options.add((Pair<Component, Runnable>)Pair.of((Object)component, (Object)runnable));
        return this;
    }

    public ContextMenu addDivider() {
        this.options.add(null);
        return this;
    }

    public ContextMenu open() {
        int longest = 0;
        this.height = 10;
        for (Pair<Component, Runnable> entry : this.options) {
            if (entry == null) {
                this.height += 7;
                continue;
            }
            int width = Minecraft.getInstance().font.width((FormattedText)entry.getFirst());
            if (width > longest) {
                longest = width;
            }
            Objects.requireNonNull(Minecraft.getInstance().font);
            this.height += 9 + 4;
        }
        this.width = longest + 10;
        this.visible = true;
        this.active = true;
        return this;
    }

    public ContextMenu close() {
        this.visible = false;
        this.active = false;
        return this;
    }
}

