/*
 * Decompiled with CFR 0.152.
 */
package com.teamresourceful.resourcefullib.client.highlights.base;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.serialization.Codec;
import java.util.List;
import net.minecraft.Util;
import net.minecraft.util.Mth;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public record HighlightLine(Vector3f start, Vector3f end, Vector3f normal) {
    public static final Codec<HighlightLine> CODEC = Codec.FLOAT.listOf().comapFlatMap(floats -> Util.fixedSize((List)floats, (int)6).map(HighlightLine::new), HighlightLine::getAsList);

    public HighlightLine(Vector3f start, Vector3f end) {
        this(start, end, HighlightLine.normal(start, end));
    }

    public HighlightLine(List<Float> list) {
        this(new Vector3f(list.get(0).floatValue(), list.get(1).floatValue(), list.get(2).floatValue()), new Vector3f(list.get(3).floatValue(), list.get(4).floatValue(), list.get(5).floatValue()));
    }

    public List<Float> getAsList() {
        return List.of(Float.valueOf(this.start.x()), Float.valueOf(this.start.y()), Float.valueOf(this.start.z()), Float.valueOf(this.end.x()), Float.valueOf(this.end.y()), Float.valueOf(this.end.z()));
    }

    public HighlightLine copy() {
        return new HighlightLine(new Vector3f((Vector3fc)this.start), new Vector3f((Vector3fc)this.end));
    }

    public void recalculateNormal() {
        Vector3f normal = HighlightLine.normal(this.start, this.end);
        this.normal.set(normal.x(), normal.y(), normal.z());
    }

    public void render(PoseStack poseStack, VertexConsumer consumer, float x, float y, float z) {
        HighlightLine.render(poseStack, consumer, 0.0f, 0.0f, 0.0f, 0.4f, x, y, z, this.start.x(), this.start.y(), this.start.z(), this.end.x(), this.end.y(), this.end.z(), this.normal.x(), this.normal.y(), this.normal.z());
    }

    public static void render(PoseStack stack, VertexConsumer consumer, float r, float g, float b, float a, float x, float y, float z, float x1, float y1, float z1, float x2, float y2, float z2, float normalX, float normalY, float normalZ) {
        PoseStack.Pose last = stack.last();
        consumer.vertex(last.pose(), x + x1, y + y1, z + z1).color(r, g, b, a).normal(last.normal(), normalX, normalY, normalZ).endVertex();
        consumer.vertex(last.pose(), x + x2, y + y2, z + z2).color(r, g, b, a).normal(last.normal(), normalX, normalY, normalZ).endVertex();
    }

    private static Vector3f normal(Vector3f start, Vector3f end) {
        Vector3f diff = new Vector3f(start.x() - end.x(), start.y() - end.y(), start.z() - end.z());
        float sqrt = Mth.sqrt((float)(diff.x() * diff.x() + diff.y() * diff.y() + diff.z() * diff.z()));
        return new Vector3f(diff.x() / sqrt, diff.y() / sqrt, diff.z() / sqrt);
    }
}

