/*
 * Decompiled with CFR 0.152.
 */
package com.teamresourceful.resourcefullib.common.codecs.predicates;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.teamresourceful.resourcefullib.common.codecs.tags.HolderSetCodec;
import java.util.Map;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.item.enchantment.Enchantment;

public record EnchantmentPredicate(HolderSet<Enchantment> enchantments, MinMaxBounds.Ints level) {
    public static final EnchantmentPredicate ANY = new EnchantmentPredicate((HolderSet<Enchantment>)HolderSet.direct((Holder[])new Holder[0]), MinMaxBounds.Ints.ANY);
    public static final Codec<EnchantmentPredicate> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)HolderSetCodec.of(BuiltInRegistries.ENCHANTMENT).fieldOf("enchantments").orElse((Object)HolderSet.direct((Holder[])new Holder[0])).forGetter(EnchantmentPredicate::enchantments), (App)MinMaxBounds.Ints.CODEC.fieldOf("level").orElse((Object)MinMaxBounds.Ints.ANY).forGetter(EnchantmentPredicate::level)).apply((Applicative)instance, EnchantmentPredicate::new));

    public boolean matches(Enchantment enchantment) {
        Holder holder = BuiltInRegistries.ENCHANTMENT.wrapAsHolder((Object)enchantment);
        return this == ANY || this.enchantments != null && this.enchantments.contains(holder);
    }

    public boolean matches(Enchantment enchantment, int level) {
        if (this.enchantments.size() == 0) {
            return this.level.matches(level);
        }
        return this.matches(enchantment) && this.level.matches(level);
    }

    public boolean matches(Map<Enchantment, Integer> enchantments) {
        if (this == ANY) {
            return true;
        }
        for (Map.Entry<Enchantment, Integer> entry : enchantments.entrySet()) {
            if (!this.matches(entry.getKey(), entry.getValue())) continue;
            return true;
        }
        return false;
    }
}

