/*
 * Decompiled with CFR 0.152.
 */
package com.teamresourceful.resourcefullib.common.codecs.predicates;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.teamresourceful.resourcefullib.common.codecs.predicates.properties.BlockStatePredicate;
import java.util.Optional;
import net.minecraft.advancements.critereon.LocationPredicate;
import net.minecraft.advancements.critereon.NbtPredicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public record RestrictedBlockPredicate(@NotNull Block block, Optional<NbtPredicate> nbt, Optional<LocationPredicate> location, @NotNull BlockStatePredicate properties) {
    public static final Codec<RestrictedBlockPredicate> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BuiltInRegistries.BLOCK.byNameCodec().fieldOf("id").forGetter(RestrictedBlockPredicate::block), (App)ExtraCodecs.strictOptionalField((Codec)NbtPredicate.CODEC, (String)"nbt").forGetter(RestrictedBlockPredicate::nbt), (App)ExtraCodecs.strictOptionalField((Codec)LocationPredicate.CODEC, (String)"location").forGetter(RestrictedBlockPredicate::location), (App)BlockStatePredicate.CODEC.fieldOf("properties").orElse((Object)BlockStatePredicate.ANY).forGetter(RestrictedBlockPredicate::properties)).apply((Applicative)instance, RestrictedBlockPredicate::new));

    public Optional<CompoundTag> getTag() {
        return this.nbt().map(NbtPredicate::tag);
    }

    public boolean matches(ServerLevel level, BlockPos pos) {
        BlockState state = level.getBlockState(pos);
        if (!state.is(this.block)) {
            return false;
        }
        if (!this.properties.matches(state)) {
            return false;
        }
        if (this.location.isPresent() && !this.location.get().matches(level, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ())) {
            return false;
        }
        if (this.nbt.isPresent()) {
            BlockEntity blockEntity = level.getBlockEntity(pos);
            return blockEntity != null && this.nbt.get().matches((Tag)blockEntity.saveWithFullMetadata());
        }
        return true;
    }
}

