/*
 * Decompiled with CFR 0.152.
 */
package com.teamresourceful.resourcefullib.common.codecs.predicates;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.teamresourceful.resourcefullib.common.codecs.predicates.NbtPredicate;
import java.util.Optional;
import net.minecraft.advancements.critereon.EntityFlagsPredicate;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.LocationPredicate;
import net.minecraft.advancements.critereon.MobEffectsPredicate;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;

public record RestrictedEntityPredicate(EntityType<?> entityType, Optional<LocationPredicate> location, Optional<MobEffectsPredicate> effects, Optional<NbtPredicate> nbt, Optional<EntityFlagsPredicate> flags, Optional<EntityPredicate> targetedEntity) {
    public static final Codec<RestrictedEntityPredicate> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BuiltInRegistries.ENTITY_TYPE.byNameCodec().fieldOf("type").forGetter(RestrictedEntityPredicate::entityType), (App)ExtraCodecs.strictOptionalField((Codec)LocationPredicate.CODEC, (String)"location").forGetter(RestrictedEntityPredicate::location), (App)ExtraCodecs.strictOptionalField((Codec)MobEffectsPredicate.CODEC, (String)"effects").forGetter(RestrictedEntityPredicate::effects), (App)ExtraCodecs.strictOptionalField(NbtPredicate.CODEC, (String)"nbt").forGetter(RestrictedEntityPredicate::nbt), (App)ExtraCodecs.strictOptionalField((Codec)EntityFlagsPredicate.CODEC, (String)"flags").forGetter(RestrictedEntityPredicate::flags), (App)ExtraCodecs.strictOptionalField((Codec)EntityPredicate.CODEC, (String)"target").forGetter(RestrictedEntityPredicate::targetedEntity)).apply((Applicative)instance, RestrictedEntityPredicate::new));

    public Optional<CompoundTag> getTag() {
        return this.nbt().map(NbtPredicate::tag);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean matches(ServerLevel level, Entity entity) {
        LivingEntity livingEntity;
        if (this.entityType == null) {
            return false;
        }
        if (this.entityType != entity.getType()) {
            return false;
        }
        if (this.location.isPresent() && !this.location.get().matches(level, entity.getX(), entity.getY(), entity.getZ())) {
            return false;
        }
        if (this.effects.isPresent() && !this.effects.get().matches(entity)) {
            return false;
        }
        if (this.nbt.isPresent() && !this.nbt.get().matches(entity)) {
            return false;
        }
        if (this.flags.isPresent() && !this.flags.get().matches(entity)) {
            return false;
        }
        if (this.targetedEntity.isEmpty()) return true;
        if (entity instanceof Mob) {
            Mob mob = (Mob)entity;
            livingEntity = mob.getTarget();
        } else {
            livingEntity = null;
        }
        if (!this.targetedEntity.get().matches(level, null, livingEntity)) return false;
        return true;
    }
}

