/*
 * Decompiled with CFR 0.152.
 */
package com.teamresourceful.resourcefullib.common.nbt.validators.numeric;

import com.mojang.serialization.Codec;
import com.teamresourceful.resourcefullib.common.codecs.CodecExtras;
import com.teamresourceful.resourcefullib.common.nbt.validators.numeric.NumericValidator;
import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.LongTag;
import net.minecraft.nbt.NumericTag;
import net.minecraft.nbt.ShortTag;

public record ExactNumericValidator(Number number) implements NumericValidator
{
    public static final String ID = "number:exact";
    public static final Codec<ExactNumericValidator> CODEC = CodecExtras.NUMBER.xmap(ExactNumericValidator::new, ExactNumericValidator::number);

    @Override
    public String id() {
        return ID;
    }

    @Override
    public boolean test(NumericTag tag) {
        if (tag instanceof ByteTag) {
            ByteTag byteTag = (ByteTag)tag;
            return byteTag.getAsByte() == this.number.byteValue();
        }
        if (tag instanceof ShortTag) {
            ShortTag shortTag = (ShortTag)tag;
            return shortTag.getAsShort() == this.number.shortValue();
        }
        if (tag instanceof IntTag) {
            IntTag intTag = (IntTag)tag;
            return intTag.getAsInt() == this.number.intValue();
        }
        if (tag instanceof LongTag) {
            LongTag longTag = (LongTag)tag;
            return longTag.getAsLong() == this.number.longValue();
        }
        if (tag instanceof FloatTag) {
            FloatTag floatTag = (FloatTag)tag;
            return floatTag.getAsFloat() == this.number.floatValue();
        }
        if (tag instanceof DoubleTag) {
            DoubleTag doubleTag = (DoubleTag)tag;
            return doubleTag.getAsDouble() == this.number.doubleValue();
        }
        return tag.getAsNumber().equals(this.number);
    }
}

