/*
 * Decompiled with CFR 0.152.
 */
package com.teamresourceful.resourcefullib.common.networking;

import com.teamresourceful.resourcefullib.common.networking.PacketChannelHelper;
import com.teamresourceful.resourcefullib.common.networking.base.Packet;
import com.teamresourceful.resourcefullib.common.networking.base.PacketHandler;
import java.util.Collection;
import java.util.function.BooleanSupplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.ChunkSource;
import net.minecraft.world.level.chunk.LevelChunk;
import org.jetbrains.annotations.ApiStatus;

@Deprecated
@ApiStatus.ScheduledForRemoval(inVersion="1.21")
public class NetworkChannel {
    private final ResourceLocation channel;

    public NetworkChannel(String modid, int protocolVersion, String channel) {
        this.channel = new ResourceLocation(modid, channel);
        PacketChannelHelper.registerChannel(this.channel, protocolVersion, () -> false);
    }

    public NetworkChannel(String modid, int protocolVersion, String channel, boolean optional) {
        this.channel = new ResourceLocation(modid, channel);
        PacketChannelHelper.registerChannel(this.channel, protocolVersion, () -> optional);
    }

    public NetworkChannel(String modid, int protocolVersion, String channel, BooleanSupplier optional) {
        this.channel = new ResourceLocation(modid, channel);
        PacketChannelHelper.registerChannel(this.channel, protocolVersion, optional);
    }

    public final <T extends Packet<T>> void registerPacket(PacketFlow direction, ResourceLocation id, PacketHandler<T> handler, Class<T> packetClass) {
        if (direction == PacketFlow.SERVERBOUND) {
            PacketChannelHelper.registerC2SPacket(this.channel, id, handler, packetClass);
        } else {
            PacketChannelHelper.registerS2CPacket(this.channel, id, handler, packetClass);
        }
    }

    public final <T extends Packet<T>> void sendToServer(T packet) {
        PacketChannelHelper.sendToServer(this.channel, packet);
    }

    public final <T extends Packet<T>> void sendToPlayer(T packet, Player player) {
        PacketChannelHelper.sendToPlayer(this.channel, packet, player);
    }

    public final <T extends Packet<T>> void sendToPlayers(T packet, Collection<? extends Player> players) {
        players.forEach(player -> this.sendToPlayer(packet, (Player)player));
    }

    public final <T extends Packet<T>> void sendToAllPlayers(T packet, MinecraftServer server) {
        this.sendToPlayers(packet, server.getPlayerList().getPlayers());
    }

    public final <T extends Packet<T>> void sendToPlayersInLevel(T packet, Level level) {
        this.sendToPlayers(packet, level.players());
    }

    public final <T extends Packet<T>> void sendToAllLoaded(T packet, Level level, BlockPos pos) {
        ChunkSource chunkSource;
        LevelChunk chunk = level.getChunkAt(pos);
        if (chunk != null && (chunkSource = level.getChunkSource()) instanceof ServerChunkCache) {
            ServerChunkCache serverCache = (ServerChunkCache)chunkSource;
            serverCache.chunkMap.getPlayers(chunk.getPos(), false).forEach(player -> this.sendToPlayer(packet, (Player)player));
        }
    }

    public final <T extends Packet<T>> void sendToPlayersInRange(T packet, Level level, BlockPos pos, double range) {
        for (Player player : level.players()) {
            if (!(player.blockPosition().distSqr((Vec3i)pos) <= range)) continue;
            this.sendToPlayer(packet, player);
        }
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="1.21")
    @ApiStatus.Experimental
    public final boolean canSendPlayerPackets(Player player) {
        return PacketChannelHelper.canSendPlayerPackets(this.channel, player);
    }
}

