/*
 * Decompiled with CFR 0.152.
 */
package com.teamresourceful.resourcefullib.common.recipe.ingredient.neoforge;

import com.mojang.serialization.Codec;
import com.teamresourceful.resourcefullib.common.recipe.ingredient.CodecIngredient;
import com.teamresourceful.resourcefullib.common.recipe.ingredient.CodecIngredientSerializer;
import com.teamresourceful.resourcefullib.common.recipe.ingredient.neoforge.NeoForgeIngredient;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.Registry;
import net.minecraft.world.item.crafting.Ingredient;
import net.neoforged.fml.javafmlmod.FMLJavaModLoadingContext;
import net.neoforged.neoforge.common.crafting.IngredientType;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.NeoForgeRegistries;

public class IngredientHelperImpl {
    private static final Map<String, DeferredRegister<IngredientType<?>>> REGISTRIES = new HashMap();

    private static DeferredRegister<IngredientType<?>> getOrCreate(String namespace) {
        return REGISTRIES.computeIfAbsent(namespace, s -> {
            DeferredRegister registry = DeferredRegister.create((Registry)NeoForgeRegistries.INGREDIENT_TYPES, (String)s);
            registry.register(FMLJavaModLoadingContext.get().getModEventBus());
            return registry;
        });
    }

    public static <T extends CodecIngredient<T>> Ingredient getIngredient(T ingredient) {
        return new NeoForgeIngredient<T>(ingredient);
    }

    public static <C extends CodecIngredient<C>, T extends CodecIngredientSerializer<C>> void registerIngredient(T serializer) {
        Codec codec = serializer.codec().xmap(NeoForgeIngredient::new, NeoForgeIngredient::getIngredient);
        IngredientHelperImpl.getOrCreate(serializer.id().getNamespace()).register(serializer.id().getPath(), () -> new IngredientType(codec));
    }
}

