/*
 * Decompiled with CFR 0.152.
 */
package com.teamresourceful.resourcefullib.common.recipe.ingredient.neoforge;

import com.teamresourceful.resourcefullib.common.recipe.ingredient.CodecIngredient;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.stream.Stream;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NeoForgeIngredient<T extends CodecIngredient<T>>
extends Ingredient {
    private final T ingredient;
    @Nullable
    private ItemStack[] stacks;
    @Nullable
    private IntList stackingIds;

    protected NeoForgeIngredient(T ingredient) {
        super(Stream.of(new Ingredient.Value[0]));
        this.ingredient = ingredient;
    }

    public T getIngredient() {
        return this.ingredient;
    }

    public ItemStack @NotNull [] getItems() {
        if (this.stacks == null) {
            this.stacks = this.ingredient.getStacksAsArray();
        }
        return this.stacks;
    }

    public boolean synchronizeWithContents() {
        return false;
    }

    public boolean isSimple() {
        return !this.ingredient.isComplex();
    }

    public boolean test(@Nullable ItemStack stack) {
        return this.ingredient.test(stack);
    }

    public boolean isEmpty() {
        return this.ingredient.isEmpty();
    }

    @NotNull
    public IntList getStackingIds() {
        if (this.stackingIds == null) {
            this.stackingIds = Ingredient.of((ItemStack[])this.getItems()).getStackingIds();
        }
        return this.stackingIds;
    }
}

