/*
 * Decompiled with CFR 0.152.
 */
package tech.alexnijjar.endermanoverhaul.common.items.pearls;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.EnderpearlItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tech.alexnijjar.endermanoverhaul.common.constants.ConstantComponents;
import tech.alexnijjar.endermanoverhaul.common.entities.pets.BasePetEnderman;
import tech.alexnijjar.endermanoverhaul.common.entities.projectiles.ThrownAncientPearl;

public class AncientPearlItem
extends EnderpearlItem {
    public static final int HEAL_TICK_RATE = 2500;

    public AncientPearlItem(Item.Properties properties) {
        super(properties);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(Level level, Player player, @NotNull InteractionHand usedHand) {
        ItemStack stack = player.getItemInHand(usedHand);
        level.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.ENDER_PEARL_THROW, SoundSource.NEUTRAL, 0.5f, 0.4f / (level.getRandom().nextFloat() * 0.4f + 0.8f));
        player.getCooldowns().addCooldown((Item)this, 20);
        if (!level.isClientSide()) {
            ThrownAncientPearl pearl;
            CompoundTag tag = stack.getOrCreateTag();
            if (tag.contains("PetEntity")) {
                BasePetEnderman pet = ThrownAncientPearl.createPet(level, player, switch (tag.getString("PetType")) {
                    case "hammerhead_pet_enderman" -> 1;
                    case "axolotl_pet_enderman" -> 2;
                    default -> 0;
                });
                pet.load(tag.getCompound("PetEntity"));
                pearl = new ThrownAncientPearl(level, (LivingEntity)player, (Entity)pet);
            } else {
                pearl = new ThrownAncientPearl(level, (LivingEntity)player);
            }
            pearl.setItem(stack);
            pearl.shootFromRotation((Entity)player, player.getXRot(), player.getYRot(), 0.0f, 1.5f, 1.0f);
            level.addFreshEntity((Entity)pearl);
        }
        player.awardStat(Stats.ITEM_USED.get((Object)this));
        if (!player.getAbilities().instabuild) {
            stack.shrink(1);
        }
        return InteractionResultHolder.sidedSuccess((Object)stack, (boolean)level.isClientSide());
    }

    public void appendHoverText(@NotNull ItemStack stack, @Nullable Level level, List<Component> tooltipComponents, @NotNull TooltipFlag isAdvanced) {
        tooltipComponents.add(ConstantComponents.ANCIENT_PEARL_TOOLTIP);
        if (level == null) {
            return;
        }
        CompoundTag tag = stack.getOrCreateTag();
        if (tag.contains("PetEntity")) {
            CompoundTag petTag = tag.getCompound("PetEntity");
            int health = petTag.getInt("Health");
            tooltipComponents.add((Component)Component.translatable((String)"tooltip.endermanoverhaul.ancient_pet", (Object[])new Object[]{health}).withStyle(ChatFormatting.GREEN));
        }
    }

    public void inventoryTick(@NotNull ItemStack stack, Level level, @NotNull Entity entity, int slotId, boolean isSelected) {
        if (level.isClientSide()) {
            return;
        }
        if ((entity.tickCount + entity.getId()) % 2500 != 0) {
            return;
        }
        CompoundTag tag = stack.getOrCreateTag();
        if (tag.contains("PetEntity")) {
            CompoundTag petTag = tag.getCompound("PetEntity");
            petTag.putInt("Health", Math.min(petTag.getInt("Health") + 1, 30));
            tag.put("PetEntity", (Tag)petTag);
            stack.setTag(tag);
        }
    }

    public boolean isFoil(@NotNull ItemStack stack) {
        return stack.hasTag() && stack.getOrCreateTag().contains("PetEntity");
    }
}

