/*
 * Decompiled with CFR 0.152.
 */
package com.teamresourceful.resourcefulconfig.api.types.options;

import com.teamresourceful.resourcefulconfig.api.annotations.Comment;
import com.teamresourceful.resourcefulconfig.api.annotations.ConfigEntry;
import com.teamresourceful.resourcefulconfig.api.annotations.ConfigOption;
import com.teamresourceful.resourcefulconfig.api.types.options.TranslatableValue;
import java.lang.reflect.Field;
import java.util.regex.Pattern;
import net.minecraft.Optionull;
import org.jetbrains.annotations.Nullable;

public record EntryData(TranslatableValue title, TranslatableValue comment, boolean isMultiline, Pattern regex, boolean hasSlider, boolean hasRange, double min, double max, String separator, String separatorDescription, boolean isHidden) {
    public static Builder builder() {
        return new Builder();
    }

    public static EntryData of(Field field) {
        ConfigEntry entry = field.getAnnotation(ConfigEntry.class);
        Builder builder = EntryData.builder().translation(entry.id(), entry.translation()).comment((String)Optionull.mapOrDefault((Object)field.getAnnotation(Comment.class), Comment::value, (Object)""), (String)Optionull.mapOrDefault((Object)field.getAnnotation(Comment.class), Comment::translation, (Object)"")).isMultiline(field.isAnnotationPresent(ConfigOption.Multiline.class)).regex((String)Optionull.map((Object)field.getAnnotation(ConfigOption.Regex.class), ConfigOption.Regex::value)).hasSlider(field.isAnnotationPresent(ConfigOption.Slider.class)).isHidden(field.isAnnotationPresent(ConfigOption.Hidden.class));
        if (field.isAnnotationPresent(ConfigOption.Range.class)) {
            ConfigOption.Range range = field.getAnnotation(ConfigOption.Range.class);
            builder.range(range.min(), range.max());
        }
        if (field.isAnnotationPresent(ConfigOption.Separator.class)) {
            ConfigOption.Separator sep = field.getAnnotation(ConfigOption.Separator.class);
            builder.separator(sep.value(), sep.description());
        }
        return builder.build();
    }

    public boolean inRange(double value) {
        return value >= this.min && value <= this.max;
    }

    public boolean hasRegex() {
        return this.regex != null;
    }

    public boolean matchesRegex(String value) {
        return this.regex.matcher(value).matches();
    }

    public static class Builder {
        private TranslatableValue title = TranslatableValue.EMPTY;
        private TranslatableValue comment = TranslatableValue.EMPTY;
        private boolean isMultiline = false;
        private Pattern regex = null;
        private boolean hasSlider = false;
        private boolean hasRange = false;
        private double min = 0.0;
        private double max = 0.0;
        private String separator = null;
        private String separatorDescription = null;
        private boolean isHidden = false;

        public Builder translation(String value, String translation) {
            this.title = new TranslatableValue(value, translation);
            return this;
        }

        public Builder comment(String value, String translation) {
            this.comment = new TranslatableValue(value, translation);
            return this;
        }

        public Builder isMultiline(boolean value) {
            this.isMultiline = value;
            return this;
        }

        public Builder regex(@Nullable String value) {
            this.regex = (Pattern)Optionull.map((Object)value, Pattern::compile);
            return this;
        }

        public Builder hasSlider(boolean value) {
            this.hasSlider = value;
            return this;
        }

        public Builder range(double min, double max) {
            this.hasRange = true;
            this.min = min;
            this.max = max;
            return this;
        }

        public Builder separator(String title, String description) {
            this.separator = title;
            this.separatorDescription = description;
            return this;
        }

        public Builder isHidden(boolean value) {
            this.isHidden = value;
            return this;
        }

        public EntryData build() {
            return new EntryData(this.title, this.comment, this.isMultiline, this.regex, this.hasSlider, this.hasRange, this.min, this.max, this.separator, this.separatorDescription, this.isHidden);
        }
    }
}

