/*
 * Decompiled with CFR 0.152.
 */
package com.teamresourceful.resourcefulconfig.common.config;

import com.teamresourceful.resourcefulconfig.api.types.ResourcefulConfig;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public record Configurations(Map<String, List<String>> modToConfigs, Map<String, ResourcefulConfig> configs) implements Iterable<ResourcefulConfig>
{
    public static final Configurations INSTANCE = new Configurations();

    private Configurations() {
        this(new HashMap<String, List<String>>(), new HashMap<String, ResourcefulConfig>());
    }

    private void addModConfigs(String modid, String configId) {
        this.modToConfigs.computeIfAbsent(modid, s -> new ArrayList()).add(configId);
    }

    public void addConfig(ResourcefulConfig config, String modid) {
        if (modid != null) {
            this.addModConfigs(modid, config.id());
        }
        this.configs.put(config.id(), config);
    }

    @Override
    @NotNull
    public Iterator<ResourcefulConfig> iterator() {
        return this.configs.values().iterator();
    }

    public List<String> getConfigsForMod(String modid) {
        return this.modToConfigs.getOrDefault(modid, List.of());
    }

    public Collection<String> getModIds() {
        return this.modToConfigs.keySet();
    }
}

