/*
 * Decompiled with CFR 0.152.
 */
package tech.alexnijjar.endermanoverhaul.common.entities.projectiles;

import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tech.alexnijjar.endermanoverhaul.common.entities.pets.AxolotlPetEnderman;
import tech.alexnijjar.endermanoverhaul.common.entities.pets.BasePetEnderman;
import tech.alexnijjar.endermanoverhaul.common.entities.pets.HammerheadPetEnderman;
import tech.alexnijjar.endermanoverhaul.common.entities.pets.PetEnderman;
import tech.alexnijjar.endermanoverhaul.common.entities.projectiles.base.BaseThrownPearl;
import tech.alexnijjar.endermanoverhaul.common.registry.ModEntityTypes;
import tech.alexnijjar.endermanoverhaul.common.registry.ModItems;
import tech.alexnijjar.endermanoverhaul.common.registry.ModSoundEvents;
import tech.alexnijjar.endermanoverhaul.common.utils.ModUtils;

public class ThrownAncientPearl
extends BaseThrownPearl {
    @Nullable
    private Entity existingPet;

    public ThrownAncientPearl(EntityType<? extends ThrownAncientPearl> type, Level level) {
        super(type, level);
    }

    public ThrownAncientPearl(Level level, LivingEntity shooter) {
        this(level, shooter, null);
    }

    public ThrownAncientPearl(Level level, LivingEntity shooter, @Nullable Entity existingPet) {
        super((EntityType<? extends ThrowableItemProjectile>)((EntityType)ModEntityTypes.ANCIENT_PEARL.get()), shooter, level);
        this.existingPet = existingPet;
    }

    @NotNull
    protected Item getDefaultItem() {
        return (Item)ModItems.ANCIENT_PEARL.get();
    }

    protected void onHitEntity(@NotNull EntityHitResult result) {
        super.onHitEntity(result);
        result.getEntity().hurt(this.damageSources().thrown((Entity)this, this.getOwner()), 0.0f);
    }

    protected void onHit(@NotNull HitResult result) {
        super.onHit(result);
        if (this.level().isClientSide() || this.isRemoved()) {
            return;
        }
        for (int i = 0; i < 32; ++i) {
            ModUtils.sendParticles((ServerLevel)this.level(), ParticleTypes.PORTAL, this.getX(), this.getY() - 1.0 + this.random.nextDouble() * 2.0, this.getZ(), 1, 0.0, 0.0, 0.0, -1.3);
        }
        Entity entity = this.getOwner();
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity entity2 = (LivingEntity)entity;
        if (entity2 instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity2;
            if (serverPlayer.connection.isAcceptingMessages()) {
                Entity pet;
                Entity entity3 = pet = this.existingPet != null ? this.existingPet : this.createPet(serverPlayer);
                if (result instanceof EntityHitResult) {
                    EntityHitResult entityHitResult = (EntityHitResult)result;
                    if (pet instanceof Mob) {
                        Mob hit;
                        Mob mob = (Mob)pet;
                        Entity entity4 = entityHitResult.getEntity();
                        if (entity4 instanceof Mob && !((hit = (Mob)entity4) instanceof TamableAnimal)) {
                            mob.setTarget((LivingEntity)hit);
                        }
                    }
                }
                pet.setPos(this.getX(), this.getY(), this.getZ());
                this.level().addFreshEntity(pet);
            }
        }
        this.level().playSound(null, this.getX(), this.getY(), this.getZ(), (SoundEvent)ModSoundEvents.ANCIENT_PEARL_HIT.get(), this.getSoundSource(), 1.0f, this.random.nextFloat() * 0.4f + 0.8f);
        this.discard();
    }

    private Entity createPet(ServerPlayer player) {
        return ThrownAncientPearl.createPet(this.level(), (Player)player, this.random.nextInt(3));
    }

    private static BasePetEnderman createPet(Level level, Player player, int id) {
        return switch (id) {
            case 1 -> new HammerheadPetEnderman(level, player);
            case 2 -> new AxolotlPetEnderman(level, player);
            default -> new PetEnderman(level, player);
        };
    }
}

