/*
 * Decompiled with CFR 0.152.
 */
package tech.alexnijjar.endermanoverhaul.datagen;

import java.util.concurrent.CompletableFuture;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import tech.alexnijjar.endermanoverhaul.datagen.provider.client.ModItemModelProvider;
import tech.alexnijjar.endermanoverhaul.datagen.provider.client.ModLangProvider;
import tech.alexnijjar.endermanoverhaul.datagen.provider.server.ModBlockTagProvider;
import tech.alexnijjar.endermanoverhaul.datagen.provider.server.ModEntityTypeTagProvider;
import tech.alexnijjar.endermanoverhaul.datagen.provider.server.ModItemTagProvider;
import tech.alexnijjar.endermanoverhaul.datagen.provider.server.ModLootTableProvider;

@EventBusSubscriber(modid="endermanoverhaul", bus=EventBusSubscriber.Bus.MOD)
public final class EndermanOverhaulDataGenerator {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        CompletableFuture lookupProvider = event.getLookupProvider();
        PackOutput packOutput = generator.getPackOutput();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        generator.addProvider(event.includeClient(), (DataProvider)new ModLangProvider(packOutput));
        generator.addProvider(event.includeClient(), (DataProvider)new ModItemModelProvider(packOutput, existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new ModLootTableProvider(packOutput, lookupProvider));
        ModBlockTagProvider blockTagProvider = new ModBlockTagProvider(packOutput, lookupProvider, existingFileHelper);
        generator.addProvider(event.includeServer(), (DataProvider)blockTagProvider);
        generator.addProvider(event.includeServer(), (DataProvider)new ModItemTagProvider(packOutput, lookupProvider, blockTagProvider.contentsGetter(), existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new ModEntityTypeTagProvider(packOutput, lookupProvider, existingFileHelper));
    }
}

