/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei;

import codechicken.nei.NEIClientUtils;
import codechicken.nei.NEIServerUtils;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;

public class FastTransferManager {
    public LinkedList<LinkedList<Integer>> slotZones = new LinkedList();
    public HashMap<Integer, Integer> slotZoneMap = new HashMap();

    private void generateSlotMap(uy container, ye stack) {
        stack = stack.m();
        stack.b = 1;
        for (int slotNo = 0; slotNo < container.c.size(); ++slotNo) {
            if (this.slotZoneMap.containsKey(slotNo) || !container.a(slotNo).a(stack)) continue;
            HashSet<Integer> connectedSlots = new HashSet<Integer>();
            this.findConnectedSlots(container, slotNo, connectedSlots);
            LinkedList<Integer> zoneSlots = new LinkedList<Integer>(connectedSlots);
            Collections.sort(zoneSlots, new SlotPositionComparator(container));
            this.slotZones.add(zoneSlots);
            Iterator i$ = zoneSlots.iterator();
            while (i$.hasNext()) {
                int i = (Integer)i$.next();
                this.slotZoneMap.put(i, this.slotZones.size() - 1);
            }
        }
    }

    private void findConnectedSlots(uy container, int slotNo, HashSet<Integer> connectedSlots) {
        connectedSlots.add(slotNo);
        we slot = container.a(slotNo);
        int threshold = 18;
        for (int i = 0; i < container.c.size(); ++i) {
            if (connectedSlots.contains(i)) continue;
            we slot1 = container.a(i);
            if (Math.abs(slot.h - slot1.h) > 18 || Math.abs(slot.i - slot1.i) > 18) continue;
            this.findConnectedSlots(container, i, connectedSlots);
        }
    }

    public static int findSlotWithItem(uy container, ye teststack) {
        for (int slotNo = 0; slotNo < container.c.size(); ++slotNo) {
            ye stack = container.a(slotNo).d();
            if (stack == null || !NEIServerUtils.areStacksSameType(stack, teststack)) continue;
            return slotNo;
        }
        return -1;
    }

    public static void clearSlots(uy container) {
        for (int slotNo = 0; slotNo < container.c.size(); ++slotNo) {
            ((we)container.c.get(slotNo)).c(null);
        }
    }

    public void performMassTransfer(awy window, int fromSlot, int toSlot, ye heldStack) {
        this.generateSlotMap(window.e, heldStack);
        Integer fromZone = this.slotZoneMap.get(fromSlot);
        Integer toZone = this.slotZoneMap.get(toSlot);
        if (fromZone == null || toZone == null || fromZone == toZone) {
            return;
        }
        if (NEIClientUtils.getHeldItem() != null && !NEIServerUtils.areStacksSameType(heldStack, NEIClientUtils.getHeldItem())) {
            return;
        }
        if (!this.fillZoneWithHeldItem(window, toZone)) {
            return;
        }
        Iterator i$ = this.slotZones.get(fromZone).iterator();
        while (i$.hasNext()) {
            int transferFrom = (Integer)i$.next();
            ye transferStack = window.e.a(transferFrom).d();
            if (!NEIServerUtils.areStacksSameType(heldStack, transferStack)) continue;
            FastTransferManager.clickSlot(window, transferFrom);
            if (this.fillZoneWithHeldItem(window, toZone)) continue;
            FastTransferManager.clickSlot(window, transferFrom);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int findShiftClickDestinationSlot(uy container, int fromSlot) {
        LinkedList<ye> save = this.saveContainer(container);
        we slot = container.a(fromSlot);
        ye stack = slot.d();
        if (stack == null) {
            return -1;
        }
        stack.b = 1;
        slot.c(stack.m());
        LinkedList<ye> compareBefore = this.saveContainer(container);
        container.a(fromSlot, 0, 1, (uf)NEIClientUtils.mc().h);
        LinkedList<ye> compareAfter = this.saveContainer(container);
        try {
            for (int i = 0; i < compareBefore.size(); ++i) {
                ye after;
                ye before;
                if (i == fromSlot || NEIServerUtils.areStacksIdentical(before = compareBefore.get(i), after = compareAfter.get(i)) || after == null || (before != null || !NEIServerUtils.areStacksSameType(stack, after)) && (!NEIServerUtils.areStacksSameType(stack, after) || after.b - before.b <= 0)) continue;
                int n = i;
                return n;
            }
            int n = -1;
            return n;
        }
        finally {
            this.restoreContainer(container, save);
        }
    }

    public LinkedList<ye> saveContainer(uy container) {
        LinkedList<ye> stacks = new LinkedList<ye>();
        for (int i = 0; i < container.c.size(); ++i) {
            stacks.add(NEIServerUtils.copyStack(container.a(i).d()));
        }
        return stacks;
    }

    public void restoreContainer(uy container, LinkedList<ye> items) {
        for (int i = 0; i < container.c.size(); ++i) {
            container.a(i).c(items.get(i));
        }
        container.a(-999, 0, 0, (uf)NEIClientUtils.mc().h);
    }

    public void transferItem(awy window, int fromSlot) {
        int toSlot = this.findShiftClickDestinationSlot(window.e, fromSlot);
        if (toSlot == -1) {
            return;
        }
        we from = window.e.a(fromSlot);
        if (from.a(from.d())) {
            this.moveOneItem(window, fromSlot, toSlot);
        } else {
            this.moveOutputSet(window, fromSlot, toSlot);
        }
    }

    public void moveOutputSet(awy window, int fromSlot, int toSlot) {
        if (NEIClientUtils.getHeldItem() != null) {
            return;
        }
        FastTransferManager.clickSlot(window, fromSlot);
        if (NEIClientUtils.getHeldItem() == null) {
            return;
        }
        FastTransferManager.clickSlot(window, toSlot);
    }

    public void moveOneItem(awy window, int fromSlot, int toSlot) {
        FastTransferManager.clickSlot(window, fromSlot);
        FastTransferManager.clickSlot(window, toSlot, 1);
        FastTransferManager.clickSlot(window, fromSlot);
    }

    public void retrieveItem(awy window, int toSlot) {
        Integer integer;
        we slot = window.e.a(toSlot);
        ye slotStack = slot.d();
        if (slotStack == null || slotStack.b == slot.a() || slotStack.b == slotStack.e()) {
            return;
        }
        this.generateSlotMap(window.e, slotStack);
        Integer destZone = this.slotZoneMap.get(toSlot);
        if (destZone == null) {
            return;
        }
        int firstZoneSlot = this.findShiftClickDestinationSlot(window.e, toSlot);
        int firstZone = -1;
        if (firstZoneSlot != -1 && (integer = this.slotZoneMap.get(firstZoneSlot)) != null && this.retrieveItemFromZone(window, firstZone = integer.intValue(), toSlot)) {
            return;
        }
        for (int zone = 0; zone < this.slotZones.size(); ++zone) {
            if (zone == destZone || zone == firstZone || !this.retrieveItemFromZone(window, zone, toSlot)) continue;
            return;
        }
        this.retrieveItemFromZone(window, destZone, toSlot);
    }

    private boolean retrieveItemFromZone(awy window, int zone, int toSlot) {
        we slot;
        ye stack1;
        int i;
        ye stack = window.e.a(toSlot).d();
        Iterator i$ = this.slotZones.get(zone).iterator();
        while (i$.hasNext()) {
            i = (Integer)i$.next();
            if (i == toSlot || !NEIServerUtils.areStacksSameType(stack, stack1 = (slot = window.e.a(i)).d()) || stack1.b == slot.a() || stack1.b == stack1.e()) continue;
            this.moveOneItem(window, i, toSlot);
            return true;
        }
        i$ = this.slotZones.get(zone).iterator();
        while (i$.hasNext()) {
            i = (Integer)i$.next();
            if (i == toSlot || !NEIServerUtils.areStacksSameType(stack, stack1 = (slot = window.e.a(i)).d())) continue;
            this.moveOneItem(window, i, toSlot);
            return true;
        }
        return false;
    }

    public static void clickSlot(awy window, int slotIndex) {
        FastTransferManager.clickSlot(window, slotIndex, 0);
    }

    public static void clickSlot(awy window, int slotIndex, int button) {
        FastTransferManager.clickSlot(window, slotIndex, button, 0);
    }

    public static void clickSlot(awy window, int slotIndex, int button, int modifier) {
        uy container = window.e;
        we slot = null;
        if (slotIndex >= 0 && slotIndex < container.c.size()) {
            slot = container.a(slotIndex);
        }
        window.sendMouseClick(slot, slotIndex, button, modifier);
    }

    private boolean fillZoneWithHeldItem(awy window, int zoneIndex) {
        ye inToSlot;
        ye held;
        int transferTo;
        Iterator i$ = this.slotZones.get(zoneIndex).iterator();
        while (i$.hasNext()) {
            transferTo = (Integer)i$.next();
            held = NEIClientUtils.getHeldItem();
            if (held == null) break;
            inToSlot = window.e.a(transferTo).d();
            if (!NEIServerUtils.areStacksSameType(inToSlot, held)) continue;
            FastTransferManager.clickSlot(window, transferTo);
        }
        i$ = this.slotZones.get(zoneIndex).iterator();
        while (i$.hasNext()) {
            transferTo = (Integer)i$.next();
            held = NEIClientUtils.getHeldItem();
            if (held == null) break;
            inToSlot = window.e.a(transferTo).d();
            if (inToSlot != null) continue;
            FastTransferManager.clickSlot(window, transferTo);
        }
        return NEIClientUtils.getHeldItem() == null;
    }

    public void throwAll(awy window, int pickedUpFromSlot) {
        ye held = NEIClientUtils.getHeldItem();
        if (held == null) {
            return;
        }
        FastTransferManager.clickSlot(window, -999);
        this.generateSlotMap(window.e, held);
        Iterator i$ = this.slotZones.get(this.slotZoneMap.get(pickedUpFromSlot)).iterator();
        while (i$.hasNext()) {
            int slotIndex = (Integer)i$.next();
            we slot = window.e.a(slotIndex);
            if (!NEIServerUtils.areStacksSameType(held, slot.d())) continue;
            FastTransferManager.clickSlot(window, slotIndex);
            FastTransferManager.clickSlot(window, -999);
        }
    }

    public static class SlotPositionComparator
    implements Comparator<Integer> {
        uy container;

        public SlotPositionComparator(uy c) {
            this.container = c;
        }

        @Override
        public int compare(Integer arg0, Integer arg1) {
            we slot1 = this.container.a(arg0.intValue());
            we slot2 = this.container.a(arg1.intValue());
            if (slot2.i != slot1.i) {
                return slot1.i - slot2.i;
            }
            return slot1.h - slot2.h;
        }
    }
}

