/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei;

import codechicken.lib.math.MathHelper;
import codechicken.lib.render.RenderUtils;
import codechicken.nei.KeyManager;
import codechicken.nei.NEIClientConfig;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.event.ForgeSubscribe;
import org.lwjgl.opengl.GL11;

public class WorldOverlayRenderer
implements KeyManager.IKeyStateTracker {
    public static int mobOverlay = 0;
    public static int chunkOverlay = 0;

    public WorldOverlayRenderer() {
        KeyManager.trackers.add(this);
    }

    public static void reset() {
        mobOverlay = 0;
        chunkOverlay = 0;
    }

    @Override
    public void tickKeyStates() {
        if (atv.w().n != null) {
            return;
        }
        if (KeyManager.keyStates.get((Object)"world.moboverlay").down) {
            mobOverlay = (mobOverlay + 1) % 2;
        }
        if (KeyManager.keyStates.get((Object)"world.chunkoverlay").down) {
            chunkOverlay = (chunkOverlay + 1) % 3;
        }
    }

    @ForgeSubscribe
    public void onWorldRenderLast(RenderWorldLastEvent event) {
        if (!NEIClientConfig.isEnabled()) {
            return;
        }
        GL11.glPushMatrix();
        of entity = event.context.t.i;
        RenderUtils.translateToWorldCoords((nn)entity, (float)event.partialTicks);
        this.renderChunkBounds((nn)entity);
        this.renderMobSpawnOverlay((nn)entity);
        GL11.glPopMatrix();
    }

    private void renderMobSpawnOverlay(nn entity) {
        if (mobOverlay == 0) {
            return;
        }
        GL11.glDisable((int)3553);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glDisable((int)2896);
        GL11.glLineWidth((float)1.5f);
        GL11.glBegin((int)1);
        GL11.glColor4f((float)1.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        int curSpawnMode = 2;
        abw world = entity.q;
        int x1 = (int)entity.u;
        int z1 = (int)entity.w;
        int y1 = (int)MathHelper.clip((double)entity.v, (double)16.0, (double)(world.R() - 16));
        asx aabb = asx.a((double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0);
        for (int x = x1 - 16; x <= x1 + 16; ++x) {
            for (int z = z1 - 16; z <= z1 + 16; ++z) {
                adr chunk = world.d(x, z);
                acq biome = world.a(x, z);
                if (biome.a(oh.a).isEmpty() || biome.f() <= 0.0f) continue;
                for (int y = y1 - 16; y < y1 + 16; ++y) {
                    int spawnMode = this.getSpawnMode(chunk, aabb, x, y, z);
                    if (spawnMode == 0) continue;
                    if (spawnMode != curSpawnMode) {
                        if (spawnMode == 1) {
                            GL11.glColor4f((float)1.0f, (float)1.0f, (float)0.0f, (float)1.0f);
                        } else {
                            GL11.glColor4f((float)1.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                        }
                        curSpawnMode = spawnMode;
                    }
                    GL11.glVertex3d((double)x, (double)((double)y + 0.004), (double)z);
                    GL11.glVertex3d((double)(x + 1), (double)((double)y + 0.004), (double)(z + 1));
                    GL11.glVertex3d((double)(x + 1), (double)((double)y + 0.004), (double)z);
                    GL11.glVertex3d((double)x, (double)((double)y + 0.004), (double)(z + 1));
                }
            }
        }
        GL11.glEnd();
        GL11.glEnable((int)2896);
        GL11.glEnable((int)3553);
        GL11.glDisable((int)3042);
    }

    private int getSpawnMode(adr chunk, asx aabb, int x, int y, int z) {
        if (!aci.a((oh)oh.a, (abw)chunk.e, (int)x, (int)y, (int)z) || chunk.a(ach.b, x & 0xF, y, z & 0xF) >= 8) {
            return 0;
        }
        aabb.a = (double)x + 0.2;
        aabb.d = (double)x + 0.8;
        aabb.b = (double)y + 0.01;
        aabb.e = (double)y + 1.8;
        aabb.c = (double)z + 0.2;
        aabb.f = (double)z + 0.8;
        if (!chunk.e.b(aabb) || !chunk.e.a(aabb).isEmpty() || chunk.e.d(aabb)) {
            return 0;
        }
        if (chunk.a(ach.a, x & 0xF, y, z & 0xF) >= 8) {
            return 1;
        }
        return 2;
    }

    private void renderChunkBounds(nn entity) {
        if (chunkOverlay == 0) {
            return;
        }
        GL11.glDisable((int)3553);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glDisable((int)2896);
        GL11.glLineWidth((float)1.5f);
        GL11.glBegin((int)1);
        for (int cx = -4; cx <= 4; ++cx) {
            for (int cz = -4; cz <= 4; ++cz) {
                double x1 = entity.aj + cx << 4;
                double z1 = entity.al + cz << 4;
                double x2 = x1 + 16.0;
                double z2 = z1 + 16.0;
                double dy = 128.0;
                double y1 = Math.floor(entity.v - dy / 2.0);
                double y2 = y1 + dy;
                if (y1 < 0.0) {
                    y1 = 0.0;
                    y2 = dy;
                }
                if (y1 > (double)entity.q.R()) {
                    y2 = entity.q.R();
                    y1 = y2 - dy;
                }
                double dist = Math.pow(1.5, -(cx * cx + cz * cz));
                GL11.glColor4d((double)0.9, (double)0.0, (double)0.0, (double)dist);
                if (cx >= 0 && cz >= 0) {
                    GL11.glVertex3d((double)x2, (double)y1, (double)z2);
                    GL11.glVertex3d((double)x2, (double)y2, (double)z2);
                }
                if (cx >= 0 && cz <= 0) {
                    GL11.glVertex3d((double)x2, (double)y1, (double)z1);
                    GL11.glVertex3d((double)x2, (double)y2, (double)z1);
                }
                if (cx <= 0 && cz >= 0) {
                    GL11.glVertex3d((double)x1, (double)y1, (double)z2);
                    GL11.glVertex3d((double)x1, (double)y2, (double)z2);
                }
                if (cx <= 0 && cz <= 0) {
                    GL11.glVertex3d((double)x1, (double)y1, (double)z1);
                    GL11.glVertex3d((double)x1, (double)y2, (double)z1);
                }
                if (chunkOverlay != 2 || cx != 0 || cz != 0) continue;
                dy = 32.0;
                y1 = Math.floor(entity.v - dy / 2.0);
                y2 = y1 + dy;
                if (y1 < 0.0) {
                    y1 = 0.0;
                    y2 = dy;
                }
                if (y1 > (double)entity.q.R()) {
                    y2 = entity.q.R();
                    y1 = y2 - dy;
                }
                GL11.glColor4d((double)0.0, (double)0.9, (double)0.0, (double)0.4);
                for (double y = (double)((int)y1); y <= y2; y += 1.0) {
                    GL11.glVertex3d((double)x2, (double)y, (double)z1);
                    GL11.glVertex3d((double)x2, (double)y, (double)z2);
                    GL11.glVertex3d((double)x1, (double)y, (double)z1);
                    GL11.glVertex3d((double)x1, (double)y, (double)z2);
                    GL11.glVertex3d((double)x1, (double)y, (double)z2);
                    GL11.glVertex3d((double)x2, (double)y, (double)z2);
                    GL11.glVertex3d((double)x1, (double)y, (double)z1);
                    GL11.glVertex3d((double)x2, (double)y, (double)z1);
                }
                for (double h = 1.0; h <= 15.0; h += 1.0) {
                    GL11.glVertex3d((double)(x1 + h), (double)y1, (double)z1);
                    GL11.glVertex3d((double)(x1 + h), (double)y2, (double)z1);
                    GL11.glVertex3d((double)(x1 + h), (double)y1, (double)z2);
                    GL11.glVertex3d((double)(x1 + h), (double)y2, (double)z2);
                    GL11.glVertex3d((double)x1, (double)y1, (double)(z1 + h));
                    GL11.glVertex3d((double)x1, (double)y2, (double)(z1 + h));
                    GL11.glVertex3d((double)x2, (double)y1, (double)(z1 + h));
                    GL11.glVertex3d((double)x2, (double)y2, (double)(z1 + h));
                }
            }
        }
        GL11.glEnd();
        GL11.glEnable((int)2896);
        GL11.glEnable((int)3553);
        GL11.glDisable((int)3042);
    }
}

