/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei.config;

import codechicken.core.gui.GuiDraw;
import codechicken.lib.vec.Rectangle4i;
import codechicken.nei.LayoutManager;
import codechicken.nei.config.Option;
import java.util.List;
import org.lwjgl.opengl.GL11;

public abstract class OptionButton
extends Option {
    protected static bjo guiTex = new bjo("textures/gui/widgets.png");
    public final String prefix;
    public final String text;
    public final String tooltip;
    private boolean isEnabled = true;

    public OptionButton(String name, String prefix, String text, String tooltip) {
        super(name);
        this.prefix = prefix;
        this.text = text;
        this.tooltip = tooltip;
    }

    public OptionButton(String prefix, String text, String tooltip) {
        this(text, prefix, text, tooltip);
    }

    public OptionButton(String name) {
        this(null, name, name + ".tip");
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public void setEnabled(boolean b) {
        this.isEnabled = b;
    }

    @Override
    public void draw(int mousex, int mousey, float frame) {
        GuiDraw.changeTexture((bjo)guiTex);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.drawPrefix();
        this.drawButton(mousex, mousey);
    }

    public Rectangle4i buttonSize() {
        int x;
        int width;
        if (this.getPrefix() == null) {
            width = this.slot.contentWidth();
            x = (this.slot.contentWidth() - width) / 2;
        } else {
            width = Math.max(60, GuiDraw.getStringWidth((String)this.getButtonText()));
            x = this.slot.contentWidth() - width;
        }
        return new Rectangle4i(x, 2, width, 20);
    }

    public String getPrefix() {
        if (this.prefix == null) {
            return null;
        }
        String s = this.translateN(this.prefix, new Object[0]);
        if (s.equals(this.namespaced(this.prefix))) {
            return null;
        }
        return s;
    }

    public String getButtonText() {
        return this.translateN(this.name, new Object[0]);
    }

    public String getTooltip() {
        if (this.tooltip == null) {
            return null;
        }
        String s = this.translateN(this.tooltip, new Object[0]);
        if (s.equals(this.namespaced(this.tooltip))) {
            return null;
        }
        return s;
    }

    public void drawPrefix() {
        if (this.getPrefix() != null) {
            GuiDraw.drawString((String)this.getPrefix(), (int)10, (int)8, (int)-1);
        }
    }

    public void drawButton(int mousex, int mousey) {
        Rectangle4i b = this.buttonSize();
        LayoutManager.drawButtonBackground(b.x, b.y, b.w, b.h, true, this.getButtonTex(mousex, mousey));
        GuiDraw.drawStringC((String)this.getButtonText(), (int)b.x, (int)b.y, (int)b.w, (int)b.h, (int)this.getTextColour(mousex, mousey));
    }

    public int getButtonTex(int mousex, int mousey) {
        return !this.isEnabled() ? 0 : (this.pointInside(mousex, mousey) ? 2 : 1);
    }

    public int getTextColour(int mousex, int mousey) {
        return !this.isEnabled() ? -6250336 : (this.pointInside(mousex, mousey) ? -96 : -2039584);
    }

    public boolean pointInside(int mousex, int mousey) {
        return this.buttonSize().contains(mousex, mousey);
    }

    @Override
    public void mouseClicked(int x, int y, int button) {
        if (this.pointInside(x, y) && this.onClick(button)) {
            atv.w().v.a("random.click", 1.0f, 1.0f);
        }
    }

    public boolean onClick(int button) {
        return false;
    }

    @Override
    public List<String> handleTooltip(int mousex, int mousey, List<String> currenttip) {
        if (new Rectangle4i(0, 2, this.slot.contentWidth(), 20).contains(mousex, mousey) && this.getTooltip() != null) {
            currenttip.add(this.getTooltip());
        }
        return currenttip;
    }
}

