/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei.recipe;

import codechicken.nei.OffsetPositioner;
import codechicken.nei.api.API;
import codechicken.nei.api.IOverlayHandler;
import codechicken.nei.api.IStackPositioner;
import codechicken.nei.recipe.BrewingOverlayHandler;
import codechicken.nei.recipe.BrewingRecipeHandler;
import codechicken.nei.recipe.DefaultOverlayHandler;
import codechicken.nei.recipe.FireworkRecipeHandler;
import codechicken.nei.recipe.FuelRecipeHandler;
import codechicken.nei.recipe.FurnaceRecipeHandler;
import codechicken.nei.recipe.ProfilerRecipeHandler;
import codechicken.nei.recipe.ShapedRecipeHandler;
import codechicken.nei.recipe.ShapelessRecipeHandler;
import com.google.common.base.Objects;
import java.util.HashMap;

public class RecipeInfo {
    static HashMap<OverlayKey, IOverlayHandler> overlayMap = new HashMap();
    static HashMap<OverlayKey, IStackPositioner> positionerMap = new HashMap();
    static HashMap<Class<? extends awy>, int[]> offsets = new HashMap();

    public static void registerOverlayHandler(Class<? extends awy> classz, IOverlayHandler handler, String ident) {
        overlayMap.put(new OverlayKey(classz, ident), handler);
    }

    public static void registerGuiOverlay(Class<? extends awy> classz, String ident, IStackPositioner positioner) {
        positionerMap.put(new OverlayKey(classz, ident), positioner);
        if (positioner instanceof OffsetPositioner && !offsets.containsKey(classz)) {
            OffsetPositioner p = (OffsetPositioner)positioner;
            RecipeInfo.setGuiOffset(classz, p.offsetx, p.offsety);
        }
    }

    public static void setGuiOffset(Class<? extends awy> classz, int x, int y) {
        offsets.put(classz, new int[]{x, y});
    }

    public static boolean hasDefaultOverlay(awy gui, String ident) {
        return positionerMap.containsKey(new OverlayKey(((Object)((Object)gui)).getClass(), ident));
    }

    public static boolean hasOverlayHandler(awy gui, String ident) {
        return overlayMap.containsKey(new OverlayKey(((Object)((Object)gui)).getClass(), ident));
    }

    public static IOverlayHandler getOverlayHandler(awy gui, String ident) {
        return overlayMap.get(new OverlayKey(((Object)((Object)gui)).getClass(), ident));
    }

    public static IStackPositioner getStackPositioner(awy gui, String ident) {
        return positionerMap.get(new OverlayKey(((Object)((Object)gui)).getClass(), ident));
    }

    public static int[] getGuiOffset(awy gui) {
        int[] nArray;
        int[] offset = offsets.get(((Object)((Object)gui)).getClass());
        if (offset == null) {
            int[] nArray2 = new int[2];
            nArray2[0] = 5;
            nArray = nArray2;
            nArray2[1] = 11;
        } else {
            nArray = offset;
        }
        return nArray;
    }

    public static void load() {
        API.registerRecipeHandler(new ShapedRecipeHandler());
        API.registerUsageHandler(new ShapedRecipeHandler());
        API.registerRecipeHandler(new ShapelessRecipeHandler());
        API.registerUsageHandler(new ShapelessRecipeHandler());
        API.registerRecipeHandler(new FireworkRecipeHandler());
        API.registerUsageHandler(new FireworkRecipeHandler());
        API.registerRecipeHandler(new FurnaceRecipeHandler());
        API.registerUsageHandler(new FurnaceRecipeHandler());
        API.registerRecipeHandler(new BrewingRecipeHandler());
        API.registerUsageHandler(new BrewingRecipeHandler());
        API.registerRecipeHandler(new FuelRecipeHandler());
        API.registerUsageHandler(new FuelRecipeHandler());
        API.registerGuiOverlay(axk.class, "crafting");
        API.registerGuiOverlay(axv.class, "crafting2x2", 63, 20);
        API.registerGuiOverlay(axs.class, "smelting");
        API.registerGuiOverlay(axs.class, "fuel");
        API.registerGuiOverlay(axh.class, "brewing");
        API.registerGuiOverlayHandler(axk.class, new DefaultOverlayHandler(), "crafting");
        API.registerGuiOverlayHandler(axv.class, new DefaultOverlayHandler(63, 20), "crafting2x2");
        API.registerGuiOverlayHandler(axh.class, new BrewingOverlayHandler(), "brewing");
        API.registerRecipeHandler(new ProfilerRecipeHandler(true));
        API.registerUsageHandler(new ProfilerRecipeHandler(false));
    }

    private static class OverlayKey {
        String ident;
        Class<? extends awy> guiClass;

        public OverlayKey(Class<? extends awy> classz, String ident) {
            this.guiClass = classz;
            this.ident = ident;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof OverlayKey)) {
                return false;
            }
            OverlayKey key = (OverlayKey)obj;
            return Objects.equal((Object)this.ident, (Object)key.ident) && this.guiClass == key.guiClass;
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.ident, this.guiClass});
        }
    }
}

