/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei;

import codechicken.core.gui.GuiCCButton;
import codechicken.core.gui.GuiCCTextField;
import codechicken.core.gui.GuiScrollSlot;
import codechicken.core.gui.GuiWidget;
import codechicken.core.inventory.GuiContainerWidget;
import codechicken.lib.texture.TextureUtils;
import codechicken.lib.util.FontUtils;
import codechicken.nei.ContainerPotionCreator;
import java.awt.Dimension;
import java.util.ArrayList;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.text.translation.I18n;

public class GuiPotionCreator
extends GuiContainerWidget {
    int amplifier = 0;
    GuiCCButton ampDown;
    GuiCCButton ampUp;
    GuiSlotPotionEffects slotPotionEffects;
    GuiDurationField durationField;
    ContainerPotionCreator container = (ContainerPotionCreator)this.field_147002_h;

    public GuiPotionCreator(InventoryPlayer inventoryplayer) {
        super((Container)new ContainerPotionCreator(inventoryplayer, (IInventory)new ContainerPotionCreator.InventoryPotionStore()), 176, 208);
    }

    public void applyEffect() {
        if (this.slotPotionEffects.selectedslot >= 0) {
            this.container.setPotionEffect(this.slotPotionEffects.selectedPotion(), this.durationField.getDurationTicks(), this.amplifier);
        }
    }

    public String translateAmplifier(int amplifier) {
        switch (amplifier) {
            case 0: {
                return "I";
            }
            case 1: {
                return "II";
            }
            case 2: {
                return "III";
            }
            case 3: {
                return "IV";
            }
            case 4: {
                return "V";
            }
        }
        return Integer.toString(amplifier);
    }

    public void validateInputButtons() {
        this.ampDown.setEnabled(this.amplifier > 0);
        this.ampUp.setEnabled(this.amplifier < 3);
    }

    protected void func_146979_b(int par1, int par2) {
    }

    public void drawBackground() {
        TextureUtils.changeTexture((String)"nei:textures/gui/potion.png");
        this.func_73729_b(0, 0, 0, 0, this.field_146999_f, this.field_147000_g);
        FontUtils.drawCenteredString((String)"Favourite Potions", (int)(this.field_146999_f / 2), (int)4, (int)0x404040);
        this.field_146289_q.func_78276_b("Duration", 12, 40, 0x404040);
        this.field_146289_q.func_78276_b("Level", 19, 73, 0x404040);
        FontUtils.drawCenteredString((String)this.translateAmplifier(this.amplifier), (int)33, (int)86, (int)-10461088);
    }

    public void addWidgets() {
        this.ampDown = new GuiCCButton(10, 84, 12, 12, "<").setActionCommand("ampDown");
        this.add((GuiWidget)this.ampDown);
        this.ampUp = new GuiCCButton(44, 84, 12, 12, ">").setActionCommand("ampUp");
        this.add((GuiWidget)this.ampUp);
        this.durationField = new GuiDurationField(15, 53, 35, 12);
        this.add((GuiWidget)this.durationField);
        this.slotPotionEffects = new GuiSlotPotionEffects(60, 38);
        this.add((GuiWidget)this.slotPotionEffects);
    }

    public void func_73876_c() {
        super.func_73876_c();
        this.slotPotionEffects.setEnabled(this.container.potionInv.func_70301_a(0) != null);
    }

    public void actionPerformed(String ident, Object ... params) {
        if (ident.equals("ampDown")) {
            --this.amplifier;
        } else if (ident.equals("ampUp")) {
            ++this.amplifier;
        }
        this.applyEffect();
        this.validateInputButtons();
    }

    public class GuiDurationField
    extends GuiCCTextField {
        private String baseValue;

        public GuiDurationField(int x, int y, int width, int height) {
            super(x, y, width, height, "100");
            this.setMaxStringLength(4);
            this.setAllowedCharacters("0123456789");
            this.baseValue = this.getText();
        }

        public void setDurationTicks(int i) {
            String minutes = Integer.toString((i /= 20) / 60);
            String seconds = Integer.toString(i % 60);
            if (seconds.length() == 1) {
                seconds = '0' + seconds;
            }
            this.setText(minutes + seconds);
        }

        public void setEnabled(boolean b) {
            super.setEnabled(b);
            if (!this.isEnabled()) {
                this.setText("100");
            }
        }

        public void onFocusChanged() {
            if (this.isFocused()) {
                this.baseValue = this.getText();
            } else if (!this.validateValue()) {
                this.setText(this.baseValue);
            } else {
                GuiPotionCreator.this.applyEffect();
            }
        }

        public void onTextChanged(String oldText) {
            GuiPotionCreator.this.validateInputButtons();
        }

        private boolean validateValue() {
            try {
                int i = Integer.parseInt(this.getText());
                return i > 1 && this.getDurationTicks() < Short.MAX_VALUE && i / 100 <= 60 && i % 100 < 60;
            }
            catch (NumberFormatException nfe) {
                return false;
            }
        }

        public void drawText() {
            String s = this.getText();
            String seconds = s.substring(Math.max(0, s.length() - 2), Math.max(0, s.length() - 2) + Math.min(s.length(), 2));
            String minutes = s.length() < 3 ? "" : s.substring(0, s.length() - 2);
            int ty = this.y + this.height / 2 - 4;
            int tcolour = this.getTextColour();
            FontUtils.drawCenteredString((String)":", (int)(this.x + this.width / 2 + 1), (int)ty, (int)tcolour);
            FontUtils.drawRightString((String)seconds, (int)(this.x + this.width - 3), (int)ty, (int)tcolour);
            FontUtils.drawRightString((String)minutes, (int)(this.x + this.width / 2 - 1), (int)ty, (int)tcolour);
        }

        public int getTextColour() {
            return this.isFocused() ? 0xCCCCCC : 0x909090;
        }

        public int getDurationTicks() {
            int i = Integer.parseInt(this.getText());
            return (i / 100 * 60 + i % 100) * 20;
        }
    }

    public class GuiSlotPotionEffects
    extends GuiScrollSlot {
        public int selectedslot;
        public boolean enabled;
        private ArrayList<Potion> validPotions;

        public GuiSlotPotionEffects(int x, int y) {
            super(x, y, 108, 76);
            this.selectedslot = -1;
            this.enabled = true;
            this.validPotions = new ArrayList();
            for (Potion p : Potion.field_188414_b) {
                if (p == null) continue;
                this.validPotions.add(p);
            }
            this.setSmoothScroll(false);
            this.setMargins(0, 0, 0, 0);
        }

        public int getSlotHeight(int slot) {
            return 19;
        }

        public void drawBackground(float frame) {
            super.drawBackground(frame);
            GuiSlotPotionEffects.func_73734_a((int)this.x, (int)this.y, (int)(this.x + this.width), (int)(this.y + this.height), (int)-16777216);
        }

        public void drawOverlay(float frame) {
        }

        public int scrollbarGuideAlignment() {
            return 0;
        }

        public Dimension scrollbarDim() {
            Dimension dim = super.scrollbarDim();
            dim.width = 7;
            return dim;
        }

        protected void drawSlot(int slot, int x, int y, int mx, int my, float frame) {
            int textColour;
            String amp;
            boolean blank;
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            Potion potion = this.validPotions.get(slot);
            PotionEffect effect = this.getEffect(potion);
            boolean bl = blank = effect == null;
            if (effect == null) {
                effect = new PotionEffect(potion, 1200, 0);
            }
            int shade = this.selectedslot == slot ? 2 : (blank ? 1 : 0);
            TextureUtils.changeTexture((String)"textures/gui/container/enchanting_table.png");
            this.func_73729_b(x, y, 0, 166 + this.getSlotHeight(slot) * shade, this.width - 30, this.getSlotHeight(slot));
            this.func_73729_b(x + this.width - 30, y, this.width - 23, 166 + this.getSlotHeight(slot) * shade, 30, this.getSlotHeight(slot));
            if (potion.func_76400_d()) {
                TextureUtils.changeTexture((String)"textures/gui/container/inventory.png");
                int icon = potion.func_76392_e();
                this.func_73729_b(x + 1, y + 1, icon % 8 * 18, 198 + icon / 8 * 18, 18, 18);
            }
            String name = I18n.func_74838_a((String)potion.func_76393_a());
            String string = amp = effect.func_76458_c() > 0 ? " " + GuiPotionCreator.this.translateAmplifier(effect.func_76458_c()) : "";
            int n = shade == 0 ? 6839882 : (textColour = shade == 1 ? 4226832 : 0xFFFF80);
            if (this.fontRenderer.func_78256_a(name + amp) < this.width - 20) {
                this.fontRenderer.func_78276_b(name + amp, x + 20, y + 1, textColour);
            } else {
                this.fontRenderer.func_78276_b(name, x + 20, y + 1, textColour);
                FontUtils.drawRightString((String)amp, (int)(x + this.width - 10), (int)(y + 10), (int)textColour);
            }
            String duration = Potion.func_188410_a((PotionEffect)effect, (float)1.0f);
            textColour = shade == 0 ? 0xA0A0A0 : (shade == 1 ? 0x808080 : 0xCCCCCC);
            this.fontRenderer.func_175063_a(duration, (float)(x + 20), (float)(y + 10), textColour);
        }

        private PotionEffect getEffect(Potion potion) {
            ItemStack potionStack = GuiPotionCreator.this.container.potionInv.func_70301_a(0);
            if (potionStack != null && potionStack.func_77942_o() && potionStack.func_77978_p().func_74764_b("CustomPotionEffects")) {
                NBTTagList potionTagList = potionStack.func_77978_p().func_150295_c("CustomPotionEffects", 10);
                for (int i = 0; i < potionTagList.func_74745_c(); ++i) {
                    PotionEffect effect = PotionEffect.func_82722_b((NBTTagCompound)potionTagList.func_150305_b(i));
                    if (effect.func_188419_a() != potion) continue;
                    return effect;
                }
            }
            return null;
        }

        protected int getNumSlots() {
            return this.validPotions.size();
        }

        protected void slotClicked(int slot, int button, int mx, int my, int count) {
            if (!this.enabled) {
                return;
            }
            if (button == 0) {
                this.select(slot);
                GuiPotionCreator.this.applyEffect();
            } else if (button == 1) {
                this.deselect();
                GuiPotionCreator.this.container.removePotionEffect(this.validPotions.get(slot));
            }
        }

        public void selectNext() {
            if (this.selectedslot >= 0 && this.selectedslot + 1 < this.getNumSlots()) {
                this.select(this.selectedslot + 1);
                this.showSlot(this.selectedslot);
            }
        }

        public void selectPrev() {
            if (this.selectedslot > 0) {
                this.select(this.selectedslot - 1);
                this.showSlot(this.selectedslot);
            }
        }

        public void setEnabled(boolean b) {
            if (b == this.enabled) {
                return;
            }
            this.enabled = b;
            if (!this.enabled) {
                this.deselect();
            }
        }

        private void select(int slot) {
            this.selectedslot = slot;
            GuiPotionCreator.this.durationField.setEnabled(true);
            PotionEffect effect = this.getEffect(this.validPotions.get(slot));
            if (effect == null) {
                effect = new PotionEffect(this.validPotions.get(slot), 1200, 0);
            }
            GuiPotionCreator.this.durationField.setDurationTicks(effect.func_76459_b());
            GuiPotionCreator.this.amplifier = effect.func_76458_c();
            GuiPotionCreator.this.validateInputButtons();
        }

        private void deselect() {
            this.selectedslot = -1;
            GuiPotionCreator.this.durationField.setEnabled(false);
            GuiPotionCreator.this.ampDown.setEnabled(false);
            GuiPotionCreator.this.ampUp.setEnabled(false);
        }

        public Potion selectedPotion() {
            return this.validPotions.get(this.selectedslot);
        }
    }
}

