/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei;

import codechicken.lib.gui.GuiDraw;
import codechicken.nei.FastTransferManager;
import codechicken.nei.NEIClientConfig;
import codechicken.nei.api.API;
import codechicken.nei.api.GuiInfo;
import codechicken.nei.api.IInfiniteItemHandler;
import codechicken.nei.api.INEIGuiHandler;
import codechicken.nei.api.ItemInfo;
import codechicken.nei.guihook.GuiContainerManager;
import codechicken.nei.guihook.IContainerInputHandler;
import codechicken.nei.guihook.IContainerSlotClickHandler;
import codechicken.nei.network.NEIClientPacketHandler;
import codechicken.nei.util.NEIClientUtils;
import codechicken.nei.util.NEIServerUtils;
import java.awt.Point;
import java.util.LinkedList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.gui.inventory.GuiContainerCreative;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.ClickType;
import net.minecraft.inventory.Slot;
import net.minecraft.inventory.SlotCrafting;
import net.minecraft.item.ItemStack;

public class NEIController
implements IContainerSlotClickHandler,
IContainerInputHandler {
    private static NEIController instance = new NEIController();
    public static GuiContainerManager manager;
    public static FastTransferManager fastTransferManager;
    private static boolean deleteMode;
    private static int pickedUpFromSlot;
    private static IInfiniteItemHandler heldStackInfinite;
    private static int selectedItem;
    private ItemStack firstheld;

    public static void load() {
        GuiContainerManager.addSlotClickHandler(instance);
        GuiContainerManager.addInputHandler(instance);
    }

    public static void load(GuiContainer gui) {
        manager = GuiContainerManager.getManager(gui);
        deleteMode = false;
        GuiInfo.clearGuiHandlers();
        fastTransferManager = null;
        if (!NEIClientConfig.isEnabled()) {
            return;
        }
        fastTransferManager = new FastTransferManager();
        if (gui instanceof INEIGuiHandler) {
            API.registerNEIGuiHandler((INEIGuiHandler)gui);
        }
    }

    public static boolean isSpreading(GuiContainer gui) {
        return gui.field_147007_t && gui.field_147008_s.size() > 1;
    }

    public static void updateUnlimitedItems(InventoryPlayer inventory) {
        int i;
        if (!NEIClientConfig.canPerformAction("item") || !NEIClientConfig.hasSMPCounterPart()) {
            return;
        }
        LinkedList<ItemStack> beforeStacks = new LinkedList<ItemStack>();
        for (i = 0; i < inventory.func_70302_i_(); ++i) {
            beforeStacks.add(NEIServerUtils.copyStack(inventory.func_70301_a(i)));
        }
        for (i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack stack = inventory.func_70301_a(i);
            if (stack == null) continue;
            for (IInfiniteItemHandler handler : ItemInfo.infiniteHandlers) {
                if (!handler.canHandleItem(stack) || !handler.isItemInfinite(stack)) continue;
                handler.replenishInfiniteStack(inventory, i);
            }
        }
        for (i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack newstack = inventory.func_70301_a(i);
            if (NEIServerUtils.areStacksIdentical((ItemStack)beforeStacks.get(i), newstack)) continue;
            inventory.func_70299_a(i, (ItemStack)beforeStacks.get(i));
            NEIClientUtils.setSlotContents(i, newstack, false);
        }
    }

    public static void processCreativeCycling(InventoryPlayer inventory) {
        if (NEIClientConfig.invCreativeMode() && NEIClientUtils.controlKey() && selectedItem != inventory.field_70461_c) {
            if (inventory.field_70461_c == selectedItem + 1 || inventory.field_70461_c == 0 && selectedItem == 8) {
                NEIClientPacketHandler.sendCreativeScroll(1);
                inventory.field_70461_c = selectedItem;
            } else if (inventory.field_70461_c == selectedItem - 1 || inventory.field_70461_c == 8 && selectedItem == 0) {
                NEIClientPacketHandler.sendCreativeScroll(-1);
                inventory.field_70461_c = selectedItem;
            }
        }
        selectedItem = inventory.field_70461_c;
    }

    @Override
    public void beforeSlotClick(GuiContainer gui, int slotIndex, int button, Slot slot, ClickType clickType) {
        if (!NEIClientConfig.isEnabled()) {
            return;
        }
        this.firstheld = NEIClientUtils.getHeldItem();
    }

    @Override
    public boolean handleSlotClick(GuiContainer gui, int slotIndex, int button, Slot slot, ClickType clickType, boolean eventConsumed) {
        if (eventConsumed || !NEIClientConfig.isEnabled() || NEIController.isSpreading(gui)) {
            return eventConsumed;
        }
        if (deleteMode && slotIndex >= 0 && slot != null) {
            if (NEIClientUtils.shiftKey() && button == 0) {
                ItemStack itemstack1 = slot.func_75211_c();
                if (itemstack1 != null) {
                    NEIClientUtils.deleteItemsOfType(itemstack1);
                }
            } else if (button == 1) {
                NEIClientUtils.decreaseSlotStack(slot.field_75222_d);
            } else {
                NEIClientUtils.deleteSlotStack(slot.field_75222_d);
            }
            return true;
        }
        if (button == 1 && slot instanceof SlotCrafting) {
            for (int i1 = 0; i1 < 64; ++i1) {
                manager.handleSlotClick(slot.field_75222_d, button, ClickType.PICKUP);
            }
            return true;
        }
        if (NEIClientUtils.controlKey() && slot != null && slot.func_75211_c() != null && slot.func_75214_a(slot.func_75211_c())) {
            NEIClientUtils.cheatItem(slot.func_75211_c(), button, 1);
            return true;
        }
        if (GuiInfo.hasCustomSlots(gui)) {
            return false;
        }
        if (slotIndex >= 0 && NEIClientUtils.shiftKey() && NEIClientUtils.getHeldItem() != null && !slot.func_75216_d()) {
            ItemStack held = NEIClientUtils.getHeldItem();
            manager.handleSlotClick(slot.field_75222_d, button, ClickType.PICKUP);
            if (slot.func_75214_a(held) && !ItemInfo.fastTransferExemptions.contains(slot.getClass()) && !ItemInfo.fastTransferContainerExemptions.contains(gui.getClass())) {
                fastTransferManager.performMassTransfer(gui, pickedUpFromSlot, slotIndex, held);
            }
            return true;
        }
        if (slotIndex == -999 && NEIClientUtils.shiftKey() && button == 0 && !ItemInfo.fastTransferContainerExemptions.contains(gui.getClass())) {
            fastTransferManager.throwAll(gui, pickedUpFromSlot);
            return true;
        }
        return false;
    }

    @Override
    public void afterSlotClick(GuiContainer gui, int slotIndex, int button, Slot slot, ClickType clickType) {
        if (!NEIClientConfig.isEnabled()) {
            return;
        }
        ItemStack nowHeld = NEIClientUtils.getHeldItem();
        if (this.firstheld != nowHeld) {
            pickedUpFromSlot = slotIndex;
        }
        if (NEIClientConfig.canPerformAction("item") && NEIClientConfig.hasSMPCounterPart()) {
            if (heldStackInfinite != null && slot != null && slot.field_75224_c == Minecraft.func_71410_x().field_71439_g.field_71071_by) {
                ItemStack stack = slot.func_75211_c();
                if (stack != null) {
                    heldStackInfinite.onPlaceInfinite(stack);
                }
                NEIClientUtils.setSlotContents(slotIndex, stack, true);
            }
            if (this.firstheld != nowHeld) {
                heldStackInfinite = null;
            }
            if (this.firstheld != nowHeld && nowHeld != null) {
                for (IInfiniteItemHandler handler : ItemInfo.infiniteHandlers) {
                    if (!handler.canHandleItem(nowHeld) || !handler.isItemInfinite(nowHeld)) continue;
                    handler.onPickup(nowHeld);
                    NEIClientUtils.setSlotContents(-999, nowHeld, true);
                    heldStackInfinite = handler;
                    break;
                }
            }
        }
    }

    @Override
    public boolean lastKeyTyped(GuiContainer gui, char keyChar, int keyCode) {
        if (!NEIClientConfig.isEnabled() || GuiInfo.hasCustomSlots(gui) || NEIController.isSpreading(gui)) {
            return false;
        }
        Slot slot = GuiContainerManager.getSlotMouseOver(gui);
        if (slot == null) {
            return false;
        }
        int slotIndex = slot.field_75222_d;
        if (keyCode == Minecraft.func_71410_x().field_71474_y.field_74316_C.func_151463_i() && NEIClientUtils.shiftKey() && !ItemInfo.fastTransferContainerExemptions.contains(gui.getClass())) {
            FastTransferManager.clickSlot(gui, slotIndex);
            fastTransferManager.throwAll(gui, slotIndex);
            FastTransferManager.clickSlot(gui, slotIndex);
            return true;
        }
        return false;
    }

    @Override
    public boolean mouseScrolled(GuiContainer gui, int mousex, int mousey, int scrolled) {
        if (!NEIClientConfig.isEnabled() || GuiInfo.hasCustomSlots(gui)) {
            return false;
        }
        Point mousePos = GuiDraw.getMousePosition();
        Slot mouseover = NEIController.manager.window.func_146975_c(mousePos.x, mousePos.y);
        if (mouseover != null && mouseover.func_75216_d() && !ItemInfo.fastTransferContainerExemptions.contains(gui.getClass())) {
            if (scrolled > 0) {
                fastTransferManager.transferItem(NEIController.manager.window, mouseover.field_75222_d);
            } else {
                fastTransferManager.retrieveItem(NEIController.manager.window, mouseover.field_75222_d);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean keyTyped(GuiContainer gui, char keyChar, int keyCode) {
        return false;
    }

    @Override
    public boolean mouseClicked(GuiContainer gui, int mousex, int mousey, int button) {
        return false;
    }

    @Override
    public void onKeyTyped(GuiContainer gui, char keyChar, int keyID) {
    }

    @Override
    public void onMouseClicked(GuiContainer gui, int mousex, int mousey, int button) {
    }

    @Override
    public void onMouseDragged(GuiContainer gui, int mousex, int mousey, int button, long heldTime) {
    }

    @Override
    public void onMouseUp(GuiContainer gui, int mousex, int mousey, int button) {
    }

    public static boolean canUseDeleteMode() {
        return !(NEIClientUtils.getGuiContainer() instanceof GuiContainerCreative);
    }

    public static void toggleDeleteMode() {
        if (NEIController.canUseDeleteMode()) {
            deleteMode = !deleteMode;
        }
    }

    public static boolean getDeleteMode() {
        return deleteMode;
    }
}

