/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei.config;

import codechicken.nei.config.ConfigSet;
import codechicken.nei.config.GuiOptionList;
import codechicken.nei.config.Option;
import codechicken.nei.config.OptionButton;
import codechicken.nei.util.LogHelper;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;

public class OptionList
extends OptionButton {
    public static final OptionList root = new RootOptionList();
    public ArrayList<Option> optionList = new ArrayList();
    public HashMap<String, Option> options = new HashMap();

    public static OptionList getOptionList(String fullName) {
        Option o = root.getOption(fullName);
        if (o == null) {
            o = new OptionList(fullName);
            root.addOption(o);
        }
        return (OptionList)o;
    }

    public static void setOptionList(OptionList list) {
        OptionList prev = (OptionList)root.getOption(list.fullName());
        if (prev == null) {
            root.addOption(list);
        } else {
            list.parent = prev.parent;
            list.options = prev.options;
            list.optionList = prev.optionList;
            for (Option o : list.optionList) {
                o.parent = list;
            }
            list.parent.options.put(list.fullName(), list);
            list.parent.optionList.remove(prev);
            list.parent.addSorted(list);
        }
    }

    public static String parent(String fullName) {
        int i = fullName.indexOf(46);
        if (i < 0) {
            return fullName;
        }
        return fullName.substring(0, i);
    }

    public static String child(String fullName) {
        int i = fullName.indexOf(46);
        return fullName.substring(i + 1);
    }

    public OptionList(String name) {
        super(name);
    }

    private OptionList subList(String fullName) {
        OptionList o = (OptionList)this.getOption(fullName);
        if (o == null) {
            o = new OptionList(fullName);
            this.addOption(o);
        }
        return o;
    }

    public Option getOption(String fullName) {
        if (fullName.contains(".")) {
            return this.subList(OptionList.parent(fullName)).getOption(OptionList.child(fullName));
        }
        return this.options.get(fullName);
    }

    public void addOption(Option o) {
        o.namespace = this.fullName();
        this.addOption(o, o.fullName(), o.name);
    }

    private void addOption(Option o, String fullName, String subName) {
        if (subName.contains(".")) {
            this.subList(OptionList.parent(subName)).addOption(o, fullName, OptionList.child(subName));
            return;
        }
        if (this.options.containsKey(subName)) {
            LogHelper.warn("Replacing option: " + fullName);
        }
        this.options.put(subName, o);
        this.addSorted(o);
        o.onAdded(this);
    }

    public void addSorted(Option o) {
        this.optionList.add(o);
    }

    public GuiOptionList getGui(GuiScreen parent, OptionList list, boolean world) {
        return this.parent.getGui(parent, list, world);
    }

    public void openGui(GuiScreen parent, boolean world) {
        Minecraft.func_71410_x().func_147108_a((GuiScreen)this.getGui(parent, this, world));
    }

    public void synthesizeEnvironment(boolean world) {
        this.getGui(null, this, world).addWidgets();
    }

    @Override
    public boolean onClick(int button) {
        this.openGui((GuiScreen)this.slot.getGui(), this.slot.getGui().worldConfig());
        return true;
    }

    @Override
    public boolean showWorldSelector() {
        return false;
    }

    @Override
    public void onAdded(GuiOptionList.OptionScrollSlot slot) {
        super.onAdded(slot);
        this.globalConfigSet().config.getTag(this.configName()).useBraces();
        this.worldConfigSet().config.getTag(this.configName()).useBraces();
    }

    private static class RootOptionList
    extends OptionList {
        public RootOptionList() {
            super(null);
        }

        @Override
        public ConfigSet globalConfigSet() {
            return null;
        }

        @Override
        public ConfigSet worldConfigSet() {
            return null;
        }

        @Override
        public OptionList configBase() {
            return null;
        }

        @Override
        public GuiOptionList getGui(GuiScreen parent, OptionList list, boolean world) {
            return new GuiOptionList(parent, list, world);
        }
    }
}

