/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei;

import codechicken.lib.gui.GuiDraw;
import codechicken.nei.NEIClientConfig;
import codechicken.nei.api.API;
import codechicken.nei.api.GuiInfo;
import codechicken.nei.api.INEIGuiHandler;
import codechicken.nei.guihook.IInputHandler;
import codechicken.nei.handler.FastTransferManager;
import codechicken.nei.handler.NEIClientEventHandler;
import codechicken.nei.network.NEIClientPacketHandler;
import codechicken.nei.util.ItemInfo;
import codechicken.nei.util.NEIClientUtils;
import codechicken.nei.util.helper.GuiHelper;
import java.awt.Point;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.gui.inventory.GuiContainerCreative;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;

public class NEIController
implements IInputHandler {
    private static NEIController instance = new NEIController();
    public static FastTransferManager fastTransferManager;
    private static boolean deleteMode;
    private static int pickedUpFromSlot;
    private static int selectedItem;
    private ItemStack heldTracker;

    public static void load() {
        NEIClientEventHandler.addInputHandler(instance);
    }

    public static void load(GuiContainer gui) {
        deleteMode = false;
        GuiInfo.clearGuiHandlers();
        fastTransferManager = null;
        if (!NEIClientConfig.isEnabled()) {
            return;
        }
        fastTransferManager = new FastTransferManager();
        if (gui instanceof INEIGuiHandler) {
            API.registerNEIGuiHandler((INEIGuiHandler)gui);
        }
    }

    public static boolean isSpreading(GuiContainer gui) {
        return gui.field_147007_t && gui.field_147008_s.size() > 1;
    }

    public static void processCreativeCycling(InventoryPlayer inventory) {
        if (NEIClientConfig.invCreativeMode() && NEIClientUtils.controlKey() && selectedItem != inventory.field_70461_c) {
            if (inventory.field_70461_c == selectedItem + 1 || inventory.field_70461_c == 0 && selectedItem == 8) {
                NEIClientPacketHandler.sendCreativeScroll(1);
                inventory.field_70461_c = selectedItem;
            } else if (inventory.field_70461_c == selectedItem - 1 || inventory.field_70461_c == 8 && selectedItem == 0) {
                NEIClientPacketHandler.sendCreativeScroll(-1);
                inventory.field_70461_c = selectedItem;
            }
        }
        selectedItem = inventory.field_70461_c;
    }

    @Override
    public boolean lastKeyTyped(GuiScreen gui, char keyChar, int keyCode) {
        if (gui instanceof GuiContainer) {
            GuiContainer container = (GuiContainer)gui;
            if (!NEIClientConfig.isEnabled() || GuiInfo.hasCustomSlots(container) || NEIController.isSpreading(container)) {
                return false;
            }
            Slot slot = GuiHelper.getSlotMouseOver(container);
            if (slot == null) {
                return false;
            }
            int slotIndex = slot.field_75222_d;
            if (keyCode == Minecraft.func_71410_x().field_71474_y.field_74316_C.func_151463_i() && NEIClientUtils.shiftKey() && !ItemInfo.fastTransferContainerExemptions.contains(container.getClass())) {
                FastTransferManager.clickSlot(container, slotIndex);
                fastTransferManager.throwAll(container, slotIndex);
                FastTransferManager.clickSlot(container, slotIndex);
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean mouseScrolled(GuiScreen gui, int mouseX, int mouseY, int scrolled) {
        if (gui instanceof GuiContainer) {
            GuiContainer container = (GuiContainer)gui;
            if (!NEIClientConfig.isEnabled() || GuiInfo.hasCustomSlots(container)) {
                return false;
            }
            Point mousePos = GuiDraw.getMousePosition();
            Slot mouseover = container.func_146975_c(mousePos.x, mousePos.y);
            if (mouseover != null && mouseover.func_75216_d() && !ItemInfo.fastTransferContainerExemptions.contains(container.getClass())) {
                if (scrolled > 0) {
                    fastTransferManager.transferItem(container, mouseover.field_75222_d);
                } else {
                    fastTransferManager.retrieveItem(container, mouseover.field_75222_d);
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public void onMouseClicked(GuiScreen gui, int mouseX, int mouseY, int button) {
        Slot slot;
        if (gui instanceof GuiContainer && (slot = GuiHelper.getSlotMouseOver((GuiContainer)gui)) != null) {
            this.heldTracker = NEIClientUtils.getHeldItem();
        }
    }

    @Override
    public boolean mouseClicked(GuiScreen screen, int mouseX, int mouseY, int button) {
        boolean outsideGui;
        if (!(screen instanceof GuiContainer) || !NEIClientConfig.isEnabled() || NEIController.isSpreading((GuiContainer)screen)) {
            return false;
        }
        GuiContainer gui = (GuiContainer)screen;
        Slot slot = GuiHelper.getSlotMouseOver(gui);
        int slotID = -1;
        boolean bl = outsideGui = (mouseX < gui.field_147003_i || mouseY < gui.field_147009_r || mouseX >= gui.field_147003_i + gui.field_146999_f || mouseY >= gui.field_147009_r + gui.field_147000_g) && slot == null;
        if (slot != null) {
            slotID = slot.field_75222_d;
        }
        if (outsideGui) {
            slotID = -999;
        }
        if (deleteMode && slot != null && slot.field_75222_d >= 0) {
            if (NEIClientUtils.shiftKey() && button == 0) {
                ItemStack itemstack1 = slot.func_75211_c();
                if (!itemstack1.func_190926_b()) {
                    NEIClientUtils.deleteItemsOfType(itemstack1);
                }
            } else if (button == 1) {
                NEIClientUtils.decreaseSlotStack(slot.field_75222_d);
            } else {
                NEIClientUtils.deleteSlotStack(slot.field_75222_d);
            }
            return true;
        }
        if (NEIClientUtils.controlKey() && slot != null && !slot.func_75211_c().func_190926_b() && slot.func_75214_a(slot.func_75211_c())) {
            NEIClientUtils.cheatItem(slot.func_75211_c(), button, 1);
            return true;
        }
        if (GuiInfo.hasCustomSlots(gui) || ItemInfo.fastTransferContainerExemptions.contains(gui.getClass())) {
            return false;
        }
        if (slotID == -999 && NEIClientUtils.shiftKey() && button == 0 && !NEIClientUtils.getHeldItem().func_190926_b()) {
            fastTransferManager.throwAll(gui, pickedUpFromSlot);
            return true;
        }
        return false;
    }

    @Override
    public void onMouseClickedPost(GuiScreen gui, int mouseX, int mouseY, int button) {
        ItemStack nowHeld;
        if (!(gui instanceof GuiContainer) || !NEIClientConfig.isEnabled()) {
            return;
        }
        Slot slot = GuiHelper.getSlotMouseOver((GuiContainer)gui);
        if (slot != null && this.heldTracker != (nowHeld = NEIClientUtils.getHeldItem())) {
            pickedUpFromSlot = slot.field_75222_d;
        }
    }

    public static boolean canUseDeleteMode() {
        return !(NEIClientUtils.getGuiContainer() instanceof GuiContainerCreative);
    }

    public static void toggleDeleteMode() {
        if (NEIController.canUseDeleteMode()) {
            deleteMode = !deleteMode;
        }
    }

    public static boolean getDeleteMode() {
        return deleteMode;
    }
}

